/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.MenuData;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.decompiler.component.DecompilerUtils;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.program.model.pcode.Varnode;
import java.util.HashSet;

public class HighlightDefinedUseAction
extends AbstractDecompilerAction {
    private final DecompilerController controller;

    public HighlightDefinedUseAction(DecompilerController controller) {
        super("Highlight Defined Use");
        this.controller = controller;
        this.setPopupMenuData(new MenuData(new String[]{"Highlight Def-use"}, "Decompile"));
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        DecompilerPanel decompilerPanel = this.controller.getDecompilerPanel();
        ClangToken tokenAtCursor = decompilerPanel.getTokenAtCursor();
        Varnode varnode = DecompilerUtils.getVarnodeRef(tokenAtCursor);
        return varnode != null;
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        DecompilerPanel decompilerPanel = this.controller.getDecompilerPanel();
        ClangToken tokenAtCursor = decompilerPanel.getTokenAtCursor();
        Varnode varnode = DecompilerUtils.getVarnodeRef(tokenAtCursor);
        if (varnode != null) {
            HashSet<Varnode> varnodes = new HashSet<Varnode>();
            varnodes.add(varnode);
            decompilerPanel.clearHighlights();
            decompilerPanel.addVarnodeHighlights(varnodes, decompilerPanel.getDefaultHighlightColor(), varnode, varnode.getDef(), decompilerPanel.getDefaultSpecialColor());
            decompilerPanel.repaint();
        }
    }
}

