/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util;

import generic.stl.Pair;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class DataTypeDependencyOrderer {
    private Boolean processed = false;
    private DataTypeManager dtManager;
    private HashSet<Entry> inputSet = new HashSet();
    private HashSet<Entry> procSet = new HashSet();
    private HashSet<Entry> doneSet = new HashSet();
    private ArrayList<DataType> structList = new ArrayList();
    private ArrayList<DataType> orderedDependentsList = new ArrayList();
    private HashMap<Entry, Set<Entry>> whoIDependOn = new HashMap();
    private HashMap<Entry, Set<Entry>> whoDependsOnMe = new HashMap();
    private LinkedList<Entry> noDependentsQueue = new LinkedList();

    private Entry createEntry(DataType dt) {
        if (dt.getDataTypeManager() != this.dtManager) {
            dt = dt.clone(this.dtManager);
        }
        Entry result = new Entry();
        result.dataType = dt;
        result.id = this.dtManager.getID(dt);
        return result;
    }

    public void addType(DataType dataType) {
        if (dataType == null) {
            return;
        }
        this.inputSet.add(this.createEntry(dataType));
        this.processed = false;
    }

    public void addTypeList(ArrayList<DataType> dtlist) {
        for (DataType dt : dtlist) {
            if (dt == null) continue;
            this.inputSet.add(this.createEntry(dt));
        }
        this.processed = false;
    }

    public void removeType(DataType dataType) {
        if (dataType == null) {
            return;
        }
        this.inputSet.remove(this.createEntry(dataType));
        this.processed = false;
    }

    public void clear() {
        this.inputSet.clear();
        this.processed = false;
    }

    public DataTypeDependencyOrderer(DataTypeManager dtManager) {
        this.dtManager = dtManager;
    }

    public DataTypeDependencyOrderer(DataTypeManager dtManager, ArrayList<DataType> dtlist) {
        this.dtManager = dtManager;
        this.addTypeList(dtlist);
    }

    public Pair<ArrayList<DataType>, ArrayList<DataType>> getAcyclicDependencyLists() {
        if (!this.processed.booleanValue()) {
            this.processDependencyLists();
        }
        return new Pair(this.structList, this.orderedDependentsList);
    }

    public ArrayList<DataType> getStructList() {
        if (!this.processed.booleanValue()) {
            this.processDependencyLists();
        }
        return this.structList;
    }

    public ArrayList<DataType> getDependencyList() {
        if (!this.processed.booleanValue()) {
            this.processDependencyLists();
        }
        return this.orderedDependentsList;
    }

    private String dumpDebug() {
        StringBuffer res = new StringBuffer();
        res.append("\nDepend Size\n  orderedDependentsList: " + this.orderedDependentsList.size() + "\n  whoIDependOn: " + this.whoIDependOn.size() + "\n  whoDependsOnMe: " + this.whoDependsOnMe.size() + "\n\n");
        if (!this.orderedDependentsList.isEmpty()) {
            for (DataType dt : this.orderedDependentsList) {
                res.append("Ordered Dependents: " + dt.getName() + " " + dt.getClass().getName() + "\n");
            }
        }
        res.append("\n");
        if (!this.whoDependsOnMe.isEmpty()) {
            for (Entry entry : this.whoDependsOnMe.keySet()) {
                res.append("WhoDependsOnMe Me: " + entry.dataType.getName() + " " + entry.dataType.getClass().getName() + "\n");
                for (Entry dentry : this.whoDependsOnMe.get(entry)) {
                    res.append("              Dep: <-- " + dentry.dataType.getName() + " " + dentry.dataType.getClass().getName() + "\n");
                }
            }
        }
        res.append("\n");
        if (!this.whoIDependOn.isEmpty()) {
            for (Entry entry : this.whoIDependOn.keySet()) {
                res.append("WhoIDependOn I: " + entry.dataType.getName() + " " + entry.dataType.getClass().getName() + "\n");
                for (Entry dentry : this.whoIDependOn.get(entry)) {
                    res.append("            Sup: --> " + dentry.dataType.getName() + " " + dentry.dataType.getClass().getName() + "\n");
                }
            }
        }
        return res.toString();
    }

    private void processDependencyLists() {
        try {
            this.createAcyclicDependencyLists();
        }
        catch (Exception e) {
            this.structList.clear();
            this.orderedDependentsList.clear();
            for (Entry entry : this.inputSet) {
                this.orderedDependentsList.add(entry.dataType);
            }
            Msg.error((Object)this, (Object)e);
        }
        this.processed = true;
    }

    /*
     * WARNING - void declaration
     */
    private void createAcyclicDependencyLists() {
        Object entry;
        this.whoDependsOnMe.clear();
        this.whoIDependOn.clear();
        this.noDependentsQueue.clear();
        this.structList.clear();
        this.orderedDependentsList.clear();
        this.procSet.clear();
        this.procSet.addAll(this.inputSet);
        this.doneSet.clear();
        while (!this.procSet.isEmpty()) {
            entry = this.procSet.iterator().next();
            DataType dataType = ((Entry)entry).dataType;
            if (dataType instanceof Pointer) {
                this.addDependent((Entry)entry, ((Pointer)dataType).getDataType());
            } else if (dataType instanceof Array) {
                this.addDependent((Entry)entry, ((Array)dataType).getDataType());
            } else if (dataType instanceof TypeDef) {
                this.addDependent((Entry)entry, ((TypeDef)dataType).getDataType());
            } else if (dataType instanceof Structure) {
                void var7_10;
                DataTypeComponent[] dtcomps;
                Structure struct = (Structure)dataType;
                DataTypeComponent[] dataTypeComponentArray = dtcomps = struct.getComponents();
                int n = dataTypeComponentArray.length;
                boolean i = false;
                while (var7_10 < n) {
                    DataTypeComponent dtcomp = dataTypeComponentArray[var7_10];
                    this.addDependent((Entry)entry, dtcomp.getDataType());
                    ++var7_10;
                }
                if (struct.hasFlexibleArrayComponent()) {
                    this.addDependent((Entry)entry, struct.getFlexibleArrayComponent().getDataType());
                }
            } else if (dataType instanceof Composite) {
                DataTypeComponent[] dtcomps;
                for (DataTypeComponent dataTypeComponent : dtcomps = ((Composite)dataType).getComponents()) {
                    this.addDependent((Entry)entry, dataTypeComponent.getDataType());
                }
            } else if (dataType instanceof FunctionDefinition) {
                ParameterDefinition[] paramDefs = ((FunctionDefinition)dataType).getArguments();
                this.addDependent((Entry)entry, ((FunctionDefinition)dataType).getReturnType());
                for (DataTypeComponent dataTypeComponent : paramDefs) {
                    this.addDependent((Entry)entry, dataTypeComponent.getDataType());
                }
            } else {
                this.addDependent((Entry)entry);
            }
            this.doneSet.add((Entry)entry);
            this.procSet.remove(entry);
        }
        if (this.whoDependsOnMe.isEmpty()) {
            throw new AssertException("Cannot create dependency graph on data types.");
        }
        for (Entry entry2 : this.doneSet) {
            if (this.whoIDependOn.containsKey(entry2) && this.whoIDependOn.get(entry2).size() != 0) continue;
            this.noDependentsQueue.add(entry2);
            this.whoIDependOn.remove(entry2);
        }
        while (!this.noDependentsQueue.isEmpty()) {
            entry = this.noDependentsQueue.remove();
            this.orderedDependentsList.add(((Entry)entry).dataType);
            if (((Entry)entry).dataType instanceof Structure || ((Entry)entry).dataType instanceof TypeDef && ((TypeDef)((Entry)entry).dataType).getBaseDataType() instanceof Structure) {
                this.structList.add(((Entry)entry).dataType);
            }
            this.removeMyDependentsEdgesToMe((Entry)entry);
        }
        if (!this.whoDependsOnMe.isEmpty() || !this.whoIDependOn.isEmpty()) {
            throw new AssertException("Cycles still exist in the data type dependency graph. Debug follows.\n" + this.dumpDebug());
        }
    }

    private void addDependent(Entry entry, DataType subType) {
        Entry subEntry;
        if (entry == null || subType == null) {
            return;
        }
        if (subType instanceof BitFieldDataType) {
            subType = ((BitFieldDataType)subType).getBaseDataType();
        }
        if (!this.doneSet.contains(subEntry = this.createEntry(subType))) {
            this.procSet.add(subEntry);
        }
        if (entry.dataType instanceof Pointer && (subType instanceof Structure || subType instanceof TypeDef && ((TypeDef)subType).getBaseDataType() instanceof Structure)) {
            return;
        }
        Set<Entry> dependents = this.whoDependsOnMe.get(subEntry);
        if (dependents == null) {
            dependents = new HashSet<Entry>();
            this.whoDependsOnMe.put(subEntry, dependents);
        }
        dependents.add(entry);
        Set<Entry> support = this.whoIDependOn.get(entry);
        if (support == null) {
            support = new HashSet<Entry>();
            this.whoIDependOn.put(entry, support);
        }
        support.add(subEntry);
    }

    private void addDependent(Entry entry) {
        if (entry == null) {
            return;
        }
        Set<Entry> dependents = this.whoDependsOnMe.get(entry);
        if (dependents == null) {
            dependents = new HashSet<Entry>();
            this.whoDependsOnMe.put(entry, dependents);
        }
        HashSet support = new HashSet();
        this.whoIDependOn.put(entry, support);
    }

    private void removeMyDependentsEdgesToMe(Entry entry) {
        Set<Entry> myDependents = this.whoDependsOnMe.get(entry);
        if (myDependents != null) {
            for (Entry myDependent : myDependents) {
                Set<Entry> supportSet = this.whoIDependOn.get(myDependent);
                supportSet.remove(entry);
                if (supportSet.size() != 0) continue;
                this.noDependentsQueue.add(myDependent);
                this.whoIDependOn.remove(myDependent);
            }
            myDependents.clear();
            this.whoDependsOnMe.remove(entry);
        }
    }

    public static class Entry {
        protected long id;
        protected DataType dataType;

        public int hashCode() {
            int val = (int)this.id;
            return val ^= (int)(this.id >>> 32);
        }

        public boolean equals(Object op2) {
            return this.id == ((Entry)op2).id;
        }
    }
}

