/*
 * Decompiled with CFR 0.152.
 */
package util.demangler;

import util.demangler.GenericDemangledDataType;
import util.demangler.GenericDemangledFunctionPointer;
import util.demangler.GenericDemangledObject;

public class GenericDemangledVariable
extends GenericDemangledObject {
    private GenericDemangledDataType datatype;

    public GenericDemangledVariable(String name) {
        this.name = name;
    }

    public void setDatatype(GenericDemangledDataType datatype) {
        this.datatype = datatype;
    }

    public GenericDemangledDataType getDataType() {
        return this.datatype;
    }

    @Override
    public String getSignature(boolean format) {
        boolean hasName;
        StringBuffer buffer = new StringBuffer();
        buffer.append((String)(this.visibility == null || "global".equals(this.visibility) ? "" : this.visibility + " "));
        if (this.isStatic()) {
            buffer.append("static ");
        }
        String spacer = "";
        if (this.isUnsigned) {
            buffer.append("unsigned");
            spacer = " ";
        }
        if (this.isStruct) {
            buffer.append("struct");
            spacer = " ";
        }
        if (this.specialPrefix != null) {
            buffer.append(this.specialPrefix);
            spacer = " ";
        }
        boolean bl = hasName = this.name != null && !this.name.isEmpty();
        if (!(this.datatype instanceof GenericDemangledFunctionPointer) && this.datatype != null) {
            buffer.append(spacer);
            buffer.append(this.datatype.toSignature());
            spacer = " ";
        }
        if (this.storageClass != null) {
            buffer.append(spacer).append(this.storageClass);
            spacer = " ";
        }
        if (this.namespace != null) {
            buffer.append(spacer);
            spacer = "";
            buffer.append(this.namespace.toNamespace());
            if (!hasName) {
                int end = buffer.length();
                buffer.delete(end - 2, end);
            }
        }
        if (hasName) {
            buffer.append(spacer);
            spacer = "";
            buffer.append(this.name);
        }
        buffer.append((String)(this.specialMidfix == null ? "" : this.specialMidfix + " "));
        buffer.append((String)(this.specialSuffix == null ? "" : " " + this.specialSuffix));
        if (this.datatype instanceof GenericDemangledFunctionPointer) {
            GenericDemangledFunctionPointer funcPtr = (GenericDemangledFunctionPointer)this.datatype;
            return funcPtr.toSignature(buffer.toString());
        }
        if (this.isConst()) {
            buffer.append(" const");
        }
        return buffer.toString().trim();
    }
}

