/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph;

import docking.ComponentPlaceholder;
import docking.DockingWindowManager;
import docking.options.editor.GhidraColorChooser;
import ghidra.app.plugin.core.functiongraph.FGColorProvider;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.mvc.FunctionGraphVertexAttributes;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginTool;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Content;
import org.jdom.Element;

class IndependentColorProvider
implements FGColorProvider {
    private static final String VERTEX_COLORS = "VERTEX_COLORS";
    private RecentColorCache recentColorCache = new RecentColorCache();
    private final PluginTool tool;

    IndependentColorProvider(PluginTool tool) {
        this.tool = tool;
    }

    @Override
    public boolean isUsingCustomColors() {
        return true;
    }

    @Override
    public Color getColorFromUser(Color startColor) {
        GhidraColorChooser chooser = new GhidraColorChooser(startColor);
        chooser.setTitle("Please Select Background Color");
        List<Color> recentColors = this.recentColorCache.getMRUColorList();
        chooser.setColorHistory(recentColors);
        Color newColor = chooser.showDialog(this.getActiveComponent());
        if (newColor != null && !newColor.equals(startColor)) {
            this.recentColorCache.addColor(newColor);
            this.tool.setConfigChanged(true);
        }
        return newColor;
    }

    private Component getActiveComponent() {
        DockingWindowManager manager = DockingWindowManager.getActiveInstance();
        ComponentPlaceholder placeholder = manager.getFocusedComponent();
        if (placeholder != null) {
            return placeholder.getComponent();
        }
        return manager.getActiveComponent();
    }

    @Override
    public void setVertexColor(FGVertex vertex, Color newColor) {
        vertex.setBackgroundColor(newColor);
    }

    @Override
    public void clearVertexColor(FGVertex vertex) {
        vertex.clearColor();
    }

    @Override
    public Color getMostRecentColor() {
        return this.recentColorCache.getMostRecentColor();
    }

    @Override
    public List<Color> getRecentColors() {
        return this.recentColorCache.getMRUColorList();
    }

    @Override
    public void savePluginColors(SaveState saveState) {
        Element colorsElement = new Element(VERTEX_COLORS);
        for (Color color : this.recentColorCache) {
            Element element = new Element("COLOR");
            element.setAttribute("RGB", Integer.toString(color.getRGB()));
            colorsElement.addContent((Content)element);
        }
        saveState.putXmlElement(VERTEX_COLORS, colorsElement);
    }

    @Override
    public void loadPluginColor(SaveState saveState) {
        Element xmlElement = saveState.getXmlElement(VERTEX_COLORS);
        if (xmlElement != null) {
            List colorElements = xmlElement.getChildren("COLOR");
            for (Element element : colorElements) {
                String rgbString = element.getAttributeValue("RGB");
                int rgb = Integer.parseInt(rgbString);
                this.recentColorCache.addColor(new Color(rgb, true));
            }
        }
    }

    @Override
    public void saveVertexColors(FGVertex vertex, FunctionGraphVertexAttributes settings) {
        Color userDefinedColor = vertex.getUserDefinedColor();
        if (userDefinedColor != null) {
            settings.putVertexColor(vertex.getVertexAddress(), userDefinedColor);
        }
    }

    @Override
    public void loadVertexColors(FGVertex vertex, FunctionGraphVertexAttributes settings) {
        Color savedColor = settings.getVertexColor(vertex.getVertexAddress());
        if (savedColor != null) {
            vertex.restoreColor(savedColor);
        }
    }

    private class RecentColorCache
    extends LinkedHashMap<Color, Color>
    implements Iterable<Color> {
        private static final int MAX_SIZE = 10;
        private Color mostRecentColor;

        RecentColorCache() {
            super(16, 0.75f, true);
            this.mostRecentColor = Color.blue;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Color, Color> eldest) {
            return this.size() > 10;
        }

        @Override
        public Iterator<Color> iterator() {
            return this.keySet().iterator();
        }

        public void addColor(Color color) {
            this.put(color, color);
            this.mostRecentColor = color;
        }

        public List<Color> getMRUColorList() {
            ArrayList<Color> list = new ArrayList<Color>(this.keySet());
            Collections.reverse(list);
            return list;
        }

        public Color getMostRecentColor() {
            return this.mostRecentColor;
        }
    }
}

