/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.merge.tree;

import docking.widgets.button.GRadioButton;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GIconLabel;
import ghidra.app.merge.tree.ProgramTreeMergeManager;
import ghidra.program.model.listing.Program;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeListener;
import resources.ResourceManager;

class NameConflictsPanel
extends JPanel {
    private JRadioButton keepOtherRB;
    private JRadioButton addOrRenameRB;
    private JRadioButton originalRB;
    private ButtonGroup group;
    private JLabel conflictsLabel;
    private ChangeListener listener;

    NameConflictsPanel(ChangeListener listener) {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createTitledBorder("Resolve Program Tree Conflict"));
        this.create();
        this.listener = listener;
    }

    void setNames(Program resultProgram, String latestName, String myName, String origName, boolean nameChangeOnly) {
        this.conflictsLabel.setText("Tree named '" + latestName + "' (Latest) conflicts with '" + myName + "' (Checked Out)");
        String text = nameChangeOnly ? "Use name '" + latestName + "' (Latest)" : "Use '" + latestName + "' (Latest) & lose '" + myName + "' (Checked Out)";
        this.keepOtherRB.setText(text);
        String myText = myName.equals(latestName) ? "Add '" + myName + "' (Checked Out) as '" + ProgramTreeMergeManager.getUniqueTreeName(resultProgram, myName) + "'" : "Add tree '" + myName + "' (Checked Out)";
        this.addOrRenameRB.setText(myText);
        String origText = nameChangeOnly ? "Use original name '" + origName + "' (Original)" : (origName.equals(latestName) ? "Restore '" + origName + "' (Original) as '" + ProgramTreeMergeManager.getUniqueTreeName(resultProgram, origName) + "' & lose '" + myName + "' (Checked Out)" : "Restore '" + origName + "' (Original) & lose '" + myName + "' (Checked Out)");
        this.originalRB.setText(origText);
        this.group.remove(this.keepOtherRB);
        this.group.remove(this.addOrRenameRB);
        this.group.remove(this.originalRB);
        this.keepOtherRB.setSelected(false);
        this.addOrRenameRB.setSelected(false);
        this.originalRB.setSelected(false);
        this.group.add(this.keepOtherRB);
        this.group.add(this.addOrRenameRB);
        this.group.add(this.originalRB);
        this.invalidate();
    }

    int getSelectedOption() {
        if (this.keepOtherRB.isSelected()) {
            return 0;
        }
        if (this.addOrRenameRB.isSelected()) {
            return 3;
        }
        if (this.originalRB.isSelected()) {
            return 4;
        }
        return -1;
    }

    private void create() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel iconPanel = new JPanel();
        iconPanel.setLayout(new BoxLayout(iconPanel, 0));
        this.conflictsLabel = new GDLabel("'My' name already exists in Latest Version");
        ImageIcon icon = ResourceManager.loadImage((String)"images/information.png");
        iconPanel.add((Component)new GIconLabel((Icon)icon));
        iconPanel.add(Box.createHorizontalStrut(5));
        iconPanel.add(this.conflictsLabel);
        iconPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        this.keepOtherRB = new GRadioButton("Keep 'Other' Name");
        this.addOrRenameRB = new GRadioButton("Rename 'My' name to My.username");
        this.originalRB = new GRadioButton("Use 'Original' name");
        this.keepOtherRB.setName("Latest");
        this.addOrRenameRB.setName("Rename My");
        this.originalRB.setName("Original");
        this.group = new ButtonGroup();
        this.group.add(this.keepOtherRB);
        this.group.add(this.addOrRenameRB);
        this.group.add(this.originalRB);
        JPanel rbPanel = new JPanel();
        rbPanel.setLayout(new BoxLayout(rbPanel, 1));
        rbPanel.add(this.keepOtherRB);
        rbPanel.add(this.addOrRenameRB);
        rbPanel.add(this.originalRB);
        panel.add((Component)iconPanel, "North");
        panel.add((Component)rbPanel, "Center");
        this.add(panel);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (NameConflictsPanel.this.listener != null) {
                    NameConflictsPanel.this.listener.stateChanged(null);
                }
            }
        };
        this.keepOtherRB.addItemListener(itemListener);
        this.addOrRenameRB.addItemListener(itemListener);
        this.originalRB.addItemListener(itemListener);
    }
}

