/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.cmd.label.DemanglerCmd;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.demangler.DemanglerOptions;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Library;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class DemanglerAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "Demangler";
    private static final String DESCRIPTION = "After a function is created, this analyzer will attempt to demangle the name and apply datatypes to parameters.";
    private static final String OPTION_NAME_DEMANGLE_USE_KNOWN_PATTERNS = "Only Demangle Known Mangled Symbols";
    private static final String OPTION_DESCRIPTION_USE_KNOWN_PATTERNS = "Only demangle symbols that follow known compiler mangling patterns. Leaving this option off may cause non-mangled symbols to get demangled.";
    private static final String OPTION_NAME_COMMIT_SIGNATURE = "Commit Function Signatures";
    private static final String OPTION_DESCRIPTION_COMMIT_SIGNATURE = "Apply any recovered function signature, in addition to the function name";
    private boolean doSignatureEnabled = true;
    private boolean demangleAllSymbols = false;

    public DemanglerAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setPriority(AnalysisPriority.DATA_TYPE_PROPOGATION.before().before().before());
        this.setDefaultEnablement(true);
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        SymbolTable symbolTable = program.getSymbolTable();
        int progress = 0;
        monitor.initialize((long)symbolTable.getNumSymbols());
        monitor.setShowProgressValue(false);
        SymbolIterator symiter = symbolTable.getPrimarySymbolIterator(set, true);
        while (symiter.hasNext()) {
            String message;
            Function function;
            monitor.checkCanceled();
            Symbol symbol = symiter.next();
            Address address = symbol.getAddress();
            if (address.compareTo((Object)set.getMaxAddress()) > 0) break;
            if (symbol.getSource() == SourceType.DEFAULT) continue;
            Namespace parentNamespace = symbol.getParentNamespace();
            if (!symbol.isExternal() ? !parentNamespace.isGlobal() : !(parentNamespace instanceof Library)) continue;
            if (symbol.getSymbolType() == SymbolType.FUNCTION && (function = (Function)symbol.getObject()).getSignatureSource() != SourceType.DEFAULT) continue;
            int count = symbolTable.getNumSymbols();
            monitor.setMaximum((long)count);
            monitor.setProgress((long)((int)((double)progress++ / (double)count * (double)count)));
            DemanglerOptions options = new DemanglerOptions();
            options.setDoDisassembly(true);
            options.setApplySignature(this.doSignatureEnabled);
            options.setDemangleOnlyKnownPatterns(this.demangleAllSymbols);
            DemanglerCmd cmd = new DemanglerCmd(address, symbol.getName(), options);
            if (cmd.applyTo((DomainObject)program) || (message = cmd.getStatusMsg()) == null) continue;
            log.appendMsg(cmd.getName(), message);
            log.setStatus(message);
        }
        monitor.setShowProgressValue(true);
        return true;
    }

    @Override
    public void registerOptions(Options options, Program program) {
        options.registerOption(OPTION_NAME_COMMIT_SIGNATURE, (Object)this.doSignatureEnabled, null, OPTION_DESCRIPTION_COMMIT_SIGNATURE);
        options.registerOption(OPTION_NAME_DEMANGLE_USE_KNOWN_PATTERNS, (Object)false, null, OPTION_DESCRIPTION_USE_KNOWN_PATTERNS);
    }

    @Override
    public void optionsChanged(Options options, Program program) {
        this.doSignatureEnabled = options.getBoolean(OPTION_NAME_COMMIT_SIGNATURE, this.doSignatureEnabled);
        this.demangleAllSymbols = options.getBoolean(OPTION_NAME_DEMANGLE_USE_KNOWN_PATTERNS, this.demangleAllSymbols);
    }
}

