/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.disassembler.AddressTable;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.reloc.Relocation;
import ghidra.program.model.reloc.RelocationTable;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.RefTypeFactory;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.task.TaskMonitor;

public class ScalarOperandAnalyzer
extends AbstractAnalyzer {
    private static final String DESCRIPTION = "Analyzes scalar operands for references to valid addresses.";
    private static final String NAME = "Scalar Operand References";
    private static final String OPTION_NAME_RELOCATION_GUIDE = "Relocation Table Guide";
    private static final String OPTION_DESCRIPTION_RELOCATION_GUIDE = "Select this check box to use relocation table entries to guide pointer analysis.";
    private static final boolean OPTION_DEFAULT_RELOCATION_GUIDE_ENABLED = true;
    private boolean relocationGuideEnabled = true;
    private static final int MAX_NEG_ENTRIES = 32;
    private int alignment = 4;
    private TaskMonitor monitor;

    public ScalarOperandAnalyzer() {
        this(NAME, DESCRIPTION);
    }

    public ScalarOperandAnalyzer(String name, String description) {
        super(name, description, AnalyzerType.INSTRUCTION_ANALYZER);
        this.setPriority(AnalysisPriority.REFERENCE_ANALYSIS.before().before());
    }

    protected boolean isELF(Program program) {
        return "Executable and Linking Format (ELF)".equals(program.getExecutableFormat());
    }

    @Override
    public boolean canAnalyze(Program program) {
        return !this.isELF(program);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor taskMonitor, MessageLog log) {
        int count = 0;
        this.monitor = taskMonitor;
        try {
            this.monitor.initialize(set.getNumAddresses());
            Listing listing = program.getListing();
            InstructionIterator iter = listing.getInstructions(set, true);
            while (iter.hasNext() && !this.monitor.isCancelled()) {
                Instruction instr = iter.next();
                this.monitor.setProgress((long)(++count));
                this.checkOperands(program, instr);
            }
        }
        finally {
            this.monitor = null;
        }
        return true;
    }

    void checkOperands(Program program, Instruction instr) {
        for (int i = 0; i < instr.getNumOperands(); ++i) {
            Object[] objs = instr.getOpObjects(i);
            for (int j = 0; j < objs.length; ++j) {
                long value;
                if (!(objs[j] instanceof Scalar)) continue;
                Scalar scalar = (Scalar)objs[j];
                boolean found = false;
                for (int r = 0; r < instr.getLength(); ++r) {
                    Address addr = instr.getMinAddress().add((long)r);
                    RelocationTable relocTable = program.getRelocationTable();
                    Relocation reloc = relocTable.getRelocation(addr);
                    if (reloc == null) continue;
                    try {
                        switch (scalar.bitLength()) {
                            case 8: {
                                if ((long)program.getMemory().getByte(addr) != scalar.getSignedValue()) break;
                                found = true;
                                break;
                            }
                            case 16: {
                                if ((long)program.getMemory().getShort(addr) != scalar.getSignedValue()) break;
                                found = true;
                                break;
                            }
                            case 32: {
                                if ((long)program.getMemory().getInt(addr) != scalar.getSignedValue()) break;
                                found = true;
                                break;
                            }
                            case 64: {
                                if (program.getMemory().getLong(addr) != scalar.getSignedValue()) break;
                                found = true;
                            }
                        }
                        continue;
                    }
                    catch (MemoryAccessException memoryAccessException) {
                        // empty catch block
                    }
                }
                if (!found && ((value = scalar.getUnsignedValue()) < 4096L || value == 65535L || value == 65280L || value == 0xFFFFFFL || value == 0xFF0000L || value == 0xFF00FFL || value == -1L || value == -256L || value == -65536L || value == -16777216L) || this.addReference(program, instr, i, instr.getMinAddress().getAddressSpace(), scalar)) continue;
                AddressSpace[] spaces = program.getAddressFactory().getAddressSpaces();
                for (int as = 0; as < spaces.length && !this.addReference(program, instr, i, spaces[as], scalar); ++as) {
                }
            }
        }
    }

    private boolean isValidRelocationAddress(Program program, Address target) {
        RelocationTable relocationTable = program.getRelocationTable();
        return !relocationTable.isRelocatable() || relocationTable.getSize() <= 0 || relocationTable.getRelocation(target) != null;
    }

    boolean addReference(Program program, Instruction instr, int opIndex, AddressSpace space, Scalar scalar) {
        Symbol[] syms;
        Address addr = null;
        if (space.isOverlaySpace()) {
            return false;
        }
        try {
            addr = space.getAddress(scalar.getUnsignedValue(), true);
        }
        catch (AddressOutOfBoundsException e) {
            return false;
        }
        if (!(program.getMemory().contains(addr) || (syms = program.getSymbolTable().getSymbols(addr)) != null && syms.length != 0 && syms[0].getSource() != SourceType.DEFAULT)) {
            return false;
        }
        if (this.checkOffcutFuncRef(program, addr)) {
            Object[] objs = instr.getOpObjects(opIndex);
            this.checkForJumpTable(program, instr, opIndex, objs, addr);
            return false;
        }
        if (instr.getOperandReferences(opIndex).length != 0) {
            return false;
        }
        instr.addOperandReference(opIndex, addr, RefTypeFactory.getDefaultMemoryRefType((CodeUnit)instr, (int)opIndex, (Address)addr, (boolean)false), SourceType.ANALYSIS);
        return true;
    }

    void checkForJumpTable(Program program, Instruction refInstr, int opIndex, Object[] opObjects, Address addr) {
        int i;
        Address offAddr;
        Instruction instr = program.getListing().getInstructionContaining(addr);
        if (instr == null) {
            return;
        }
        FlowType ftype = instr.getFlowType();
        if (!ftype.isJump() || !ftype.isComputed()) {
            return;
        }
        long entryLen = 0L;
        for (int i2 = 0; i2 < opObjects.length; ++i2) {
            Scalar sc;
            long value;
            if (!(opObjects[i2] instanceof Scalar) || (value = (sc = (Scalar)opObjects[i2]).getUnsignedValue()) != 4L && value != 2L && value != 8L) continue;
            entryLen = value;
            break;
        }
        if (entryLen == 0L) {
            return;
        }
        try {
            offAddr = addr.addNoWrap(entryLen);
        }
        catch (AddressOverflowException e) {
            return;
        }
        if (program.getListing().getInstructionContaining(offAddr) != null) {
            return;
        }
        AddressTable table = AddressTable.getEntry(program, offAddr, this.monitor, false, 3, this.alignment, 0, 1024L, this.relocationGuideEnabled);
        if (table != null) {
            program.getReferenceManager().addOffsetMemReference(refInstr.getMinAddress(), offAddr, -entryLen, RefType.DATA, SourceType.ANALYSIS, opIndex);
            return;
        }
        AddressTable lastGoodTable = null;
        for (i = 0; i < 32; ++i) {
            Address negAddr = null;
            try {
                negAddr = addr.subtractNoWrap((entryLen + 3L) * entryLen);
            }
            catch (AddressOverflowException e) {
                break;
            }
            if (program.getListing().getInstructionContaining(negAddr) != null) {
                return;
            }
            AddressTable negTable = AddressTable.getEntry(program, negAddr, this.monitor, false, 3, this.alignment, 0, 1024L, this.relocationGuideEnabled);
            if (negTable == null) continue;
            lastGoodTable = negTable;
        }
        if (i == 32) {
            return;
        }
        if (lastGoodTable != null) {
            offAddr = lastGoodTable.getTopAddress();
            program.getReferenceManager().addOffsetMemReference(instr.getMinAddress(), offAddr, (long)(i + 3) * entryLen, RefType.DATA, SourceType.ANALYSIS, opIndex);
            return;
        }
    }

    boolean checkOffcutFuncRef(Program program, Address addr) {
        Instruction instr = program.getListing().getInstructionContaining(addr);
        if (instr == null) {
            return false;
        }
        if (!instr.getMinAddress().equals((Object)addr)) {
            return true;
        }
        Function func = program.getFunctionManager().getFunctionContaining(addr);
        return func != null && !func.getEntryPoint().equals((Object)addr);
    }

    @Override
    public boolean getDefaultEnablement(Program program) {
        if (this.isELF(program)) {
            return false;
        }
        return this.getDefaultEnablement2(program);
    }

    protected boolean getDefaultEnablement2(Program program) {
        Language language = program.getLanguage();
        if (language.getPropertyAsBoolean("addressesDoNotAppearDirectlyInCode", false)) {
            return false;
        }
        Address min = program.getMinAddress();
        if (min == null || min.getOffset() == 0L) {
            return false;
        }
        if (program.getLanguage().getInstructionAlignment() != 1) {
            return false;
        }
        return program.getAddressFactory().getDefaultAddressSpace().getSize() >= 32;
    }

    @Override
    public void registerOptions(Options options, Program program) {
        options.registerOption(OPTION_NAME_RELOCATION_GUIDE, (Object)this.relocationGuideEnabled, null, OPTION_DESCRIPTION_RELOCATION_GUIDE);
    }

    @Override
    public void optionsChanged(Options options, Program program) {
        this.relocationGuideEnabled = options.getBoolean(OPTION_NAME_RELOCATION_GUIDE, this.relocationGuideEnabled);
    }

    @Override
    public void analysisEnded(Program program) {
    }
}

