/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.disassembler;

import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.cmd.label.AddLabelCmd;
import ghidra.app.util.PseudoDisassembler;
import ghidra.docking.settings.SettingsImpl;
import ghidra.framework.model.DomainObject;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictException;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.ShiftedAddressDataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.DataIterator;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.mem.DumbMemBufferImpl;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.reloc.RelocationTable;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.util.AddressSetPropertyMap;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

public class AddressTable {
    public static final int BILLION_CASES = 0x40000000;
    public static final int TOO_MANY_ENTRIES = 0x100000;
    public static final int MINIMUM_SAFE_ADDRESS = 1024;
    private static final String TABLE_IN_PROGRESS_PROPERTY_NAME = "TableInProgress";
    private static final String NAME_PREFIX = "AddrTable";
    private static final String INDEX_PREFIX = "IndexToAddrTable";
    private Address topAddress;
    private Address[] tableElements;
    private Address topIndexAddress;
    private int indexLen;
    private int skipAmount;
    private boolean negativeTable = false;
    private int addrSize = 4;
    private boolean shiftedAddr;

    public AddressTable(Address topAddress, Address[] tableElements, int addrByteSize, int skipAmount, boolean shiftedAddr) {
        this(topAddress, tableElements, null, 0, addrByteSize, skipAmount, shiftedAddr);
    }

    public AddressTable(Address topAddress, Address[] tableElements, Address topIndexAddress, int indexLen, int addrByteSize, int skipAmount, boolean shiftedAddr) {
        this.topAddress = topAddress;
        this.tableElements = tableElements;
        this.topIndexAddress = topIndexAddress;
        this.indexLen = indexLen;
        this.addrSize = addrByteSize;
        this.skipAmount = skipAmount;
        this.shiftedAddr = shiftedAddr;
    }

    public Address getTopAddress() {
        return this.topAddress;
    }

    public int getByteLength() {
        int length = this.tableElements.length * this.addrSize;
        if (this.topIndexAddress != null) {
            length += this.indexLen;
        }
        return length;
    }

    public int getByteLength(int start, int end, boolean includeIndex) {
        int length = (end - start + 1) * this.addrSize;
        if (includeIndex && this.topIndexAddress != null) {
            length += this.indexLen;
        }
        return length;
    }

    public int getNumberAddressEntries() {
        return this.tableElements.length;
    }

    public Address[] getTableElements() {
        return this.tableElements;
    }

    public Address getTopIndexAddress() {
        return this.topIndexAddress;
    }

    public int getIndexLength() {
        return this.indexLen;
    }

    public String getTableName(int offsetLen) {
        return NAME_PREFIX + this.topAddress.addWrap((long)(offsetLen * this.addrSize)).toString();
    }

    public String getIndexName(int offsetLen) {
        return INDEX_PREFIX + this.topAddress.addWrap((long)(offsetLen * this.addrSize)).toString();
    }

    public String getElementPrefix(int offsetLen) {
        return NAME_PREFIX + this.topAddress.addWrap((long)(offsetLen * this.addrSize)).toString() + "Element";
    }

    public boolean makeTable(Program program, int start, int end, boolean autoLabel) {
        return this.makeTable(program, start, end, true, autoLabel);
    }

    public boolean makeTable(Program program, int start, int end, boolean createIndex, boolean autoLabel) {
        if (end > this.tableElements.length - 1) {
            end = this.tableElements.length - 1;
        }
        if (end < start) {
            end = start;
        }
        int len = end - start + 1;
        Address currentAddress = this.topAddress.addWrap((long)(start * this.addrSize));
        Object adt = this.shiftedAddr ? ShiftedAddressDataType.dataType : new PointerDataType(DataType.DEFAULT, this.addrSize);
        adt = program.getDataTypeManager().resolve((DataType)adt, null);
        Address newAddress = currentAddress;
        Listing listing = program.getListing();
        int totalLen = len * this.addrSize + this.skipAmount;
        if (createIndex) {
            totalLen += this.getIndexLength();
        }
        if (!listing.isUndefined(currentAddress, currentAddress.addWrap((long)(totalLen - 1)))) {
            for (int k = 0; k < totalLen; ++k) {
                Data data = listing.getDataContaining(currentAddress.addWrap((long)k));
                if (data != null && (data.isPointer() || data.getDataType() instanceof Undefined || !data.isDefined())) continue;
                return false;
            }
        }
        for (int j = 0; j < len; ++j) {
            try {
                DataUtilities.createData((Program)program, (Address)newAddress, (DataType)adt, (int)adt.getLength(), (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_UNDEFINED_CONFLICT_DATA);
            }
            catch (CodeUnitInsertionException codeUnitInsertionException) {
                // empty catch block
            }
            newAddress = newAddress.addWrap((long)(this.addrSize + this.skipAmount));
        }
        if (createIndex) {
            this.createTableIndex(program);
        }
        if (autoLabel) {
            this.setLabels(program, currentAddress, len, start);
        }
        return true;
    }

    public boolean createSwitchTable(Program program, Instruction start_inst, int opindex, boolean flagNewCode, TaskMonitor monitor) {
        Listing listing = program.getListing();
        int tableSize = this.getNumberAddressEntries();
        Address tableAddr = this.getTopAddress();
        ArrayList<AddLabelCmd> switchLabelList = new ArrayList<AddLabelCmd>();
        AddLabelCmd tableNameLabel = null;
        FlowType ftype = start_inst.getFlowType();
        Object tableName = ftype.isCall() ? "callTable" : "switchTable";
        String comment = null;
        String caseName = "case_0x";
        if (this.isNegativeTable()) {
            tableName = "neg_" + (String)tableName;
            caseName = "case_n0x";
            comment = "This table is a negative switch table,\r\nit indexes from the bottom";
        }
        if (start_inst.getMnemonicReferences().length > 0) {
            return false;
        }
        boolean instrBlockExecutable = false;
        MemoryBlock instrBlock = program.getMemory().getBlock(start_inst.getMinAddress());
        if (instrBlock != null && instrBlock.isExecute()) {
            instrBlockExecutable = true;
        }
        boolean newCodeFound = false;
        boolean notInAFunction = program.getFunctionManager().getFunctionContaining(start_inst.getMinAddress()) == null;
        boolean tableInProgress = this.checkTableInProgress(program, tableAddr);
        try {
            Symbol curSymbol = program.getSymbolTable().getPrimarySymbol(tableAddr);
            tableNameLabel = curSymbol != null && curSymbol.getName().startsWith("Addr") ? new AddLabelCmd(tableAddr, (String)tableName, true, SourceType.ANALYSIS) : new AddLabelCmd(tableAddr, (String)tableName, true, SourceType.ANALYSIS);
            Address lastAddress = null;
            DataType ptrDT = program.getDataTypeManager().addDataType((DataType)PointerDataType.getPointer(null, (int)this.addrSize), null);
            for (int i = 0; i < tableSize; ++i) {
                Address target;
                Data data;
                Address loc = tableAddr.add((long)(i * this.addrSize));
                try {
                    try {
                        program.getListing().createData(loc, ptrDT, this.addrSize);
                    }
                    catch (CodeUnitInsertionException e) {
                        CodeUnit cu = listing.getCodeUnitAt(loc);
                        if (cu instanceof Instruction) break;
                        if (cu == null) {
                            Msg.warn((Object)this, (Object)"Couldn't get data at ");
                            cu = listing.getDefinedDataContaining(loc);
                            if (cu == null || cu instanceof Instruction || (cu = ((Data)cu).getPrimitiveAt((int)loc.subtract(cu.getMinAddress()))) == null) break;
                        }
                        if (!((Data)cu).isPointer()) {
                            listing.clearCodeUnits(loc, loc.add((long)(this.addrSize - 1)), false);
                            program.getListing().createData(loc, ptrDT, this.addrSize);
                        }
                    }
                }
                catch (CodeUnitInsertionException e) {
                    // empty catch block
                }
                if ((data = program.getListing().getDataAt(loc)) == null || (target = (Address)data.getValue()) == null) continue;
                Address tableTarget = this.tableElements[i];
                if (tableTarget != null && !target.equals((Object)tableTarget)) {
                    data.removeValueReference(target);
                    data.addValueReference(tableTarget, RefType.DATA);
                    target = tableTarget;
                }
                MemoryBlock thisBlock = program.getMemory().getBlock(target);
                if (lastAddress != null) {
                    try {
                        long diff = lastAddress.subtract(target);
                        if (diff > 131072L) {
                        }
                    }
                    catch (IllegalArgumentException e) {}
                    break;
                    MemoryBlock lastBlock = program.getMemory().getBlock(lastAddress);
                    if (lastBlock == null || !lastBlock.equals(thisBlock)) break;
                }
                lastAddress = target;
                if (instrBlockExecutable && thisBlock != null && !thisBlock.isExecute()) break;
                if ((program.getListing().getInstructionAt(target) == null || notInAFunction) && !tableInProgress) {
                    newCodeFound = true;
                }
                if (!flagNewCode || !newCodeFound) {
                    if (!ftype.isCall()) {
                        AddLabelCmd lcmd = new AddLabelCmd(target, caseName + Integer.toHexString(i), true, SourceType.ANALYSIS);
                        switchLabelList.add(lcmd);
                    }
                    start_inst.addMnemonicReference(target, (RefType)ftype, SourceType.ANALYSIS);
                }
                this.disassembleTarget(program, target, monitor);
            }
            if (!ftype.isCall()) {
                this.fixupFunctionBody(program, start_inst, monitor);
            }
        }
        catch (DataTypeConflictException e1) {
            return false;
        }
        if (this.getIndexLength() > 0) {
            this.createTableIndex(program);
        }
        if (comment != null) {
            program.getListing().setComment(this.topAddress, 0, comment);
        }
        if (flagNewCode && newCodeFound) {
            Reference[] refs;
            for (Reference ref : refs = start_inst.getMnemonicReferences()) {
                start_inst.removeMnemonicReference(ref.getToAddress());
            }
            this.setTableInProgress(program, tableAddr);
            return true;
        }
        this.clearTableInProgress(program, tableAddr);
        this.labelTable(program, start_inst, switchLabelList, tableNameLabel);
        return false;
    }

    private void clearTableInProgress(Program program, Address tableAddr) {
        AddressSetPropertyMap list = program.getAddressSetPropertyMap(TABLE_IN_PROGRESS_PROPERTY_NAME);
        if (list == null) {
            return;
        }
        list.remove(tableAddr, tableAddr);
    }

    private void setTableInProgress(Program program, Address tableAddr) {
        AddressSetPropertyMap list = program.getAddressSetPropertyMap(TABLE_IN_PROGRESS_PROPERTY_NAME);
        if (list == null) {
            try {
                list = program.createAddressSetPropertyMap(TABLE_IN_PROGRESS_PROPERTY_NAME);
            }
            catch (DuplicateNameException e) {
                list = program.getAddressSetPropertyMap(TABLE_IN_PROGRESS_PROPERTY_NAME);
            }
        }
        if (list == null) {
            return;
        }
        list.add(tableAddr, tableAddr);
    }

    private boolean checkTableInProgress(Program program, Address tableAddr) {
        AddressSetPropertyMap list = program.getAddressSetPropertyMap(TABLE_IN_PROGRESS_PROPERTY_NAME);
        if (list == null) {
            return false;
        }
        return list.contains(tableAddr);
    }

    public void labelTable(Program program, Instruction start_inst, ArrayList<AddLabelCmd> switchLabelList, AddLabelCmd tableNameLabel) {
        Symbol[] syms;
        for (Symbol sym : syms = program.getSymbolTable().getSymbols(this.getTopAddress())) {
            if (!sym.getName(false).startsWith(tableNameLabel.getLabelName())) continue;
            return;
        }
        long tableNumber = 0L;
        boolean needTableNumber = false;
        boolean succeed = false;
        String oldName = tableNameLabel.getLabelName();
        Namespace space = null;
        try {
            space = program.getSymbolTable().createNameSpace(null, "switch_" + start_inst.getMinAddress(), SourceType.ANALYSIS);
        }
        catch (DuplicateNameException duplicateNameException) {
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
        Symbol oldSym = program.getSymbolTable().getPrimarySymbol(tableNameLabel.getLabelAddr());
        if (oldSym != null && oldSym.getSource() == SourceType.ANALYSIS && oldSym.getName().startsWith("Addr")) {
            oldSym.delete();
        }
        do {
            tableNameLabel.setNamespace(space);
            succeed = tableNameLabel.applyTo((DomainObject)program);
            if (succeed) break;
            needTableNumber = true;
            tableNameLabel.setLabelName(oldName + "_" + ++tableNumber);
        } while (tableNumber < 20L);
        if (needTableNumber && tableNumber >= 20L) {
            tableNumber = this.topAddress.getOffset();
            tableNameLabel.setLabelName(oldName + "_" + Long.toHexString(tableNumber));
        }
        Symbol s = program.getSymbolTable().getGlobalSymbol(tableNameLabel.getLabelName(), tableNameLabel.getLabelAddr());
        block5: for (int op = 0; op < start_inst.getNumOperands(); ++op) {
            Reference[] fromRefs;
            for (Reference fromRef : fromRefs = start_inst.getOperandReferences(op)) {
                if (!fromRef.getToAddress().equals((Object)tableNameLabel.getLabelAddr())) continue;
                program.getReferenceManager().setAssociation(s, fromRef);
                continue block5;
            }
        }
        if (this.getIndexLength() > 0) {
            AddLabelCmd lcmd = new AddLabelCmd(this.getTopIndexAddress(), "switchIndex", true, SourceType.ANALYSIS);
            switchLabelList.add(lcmd);
        }
        for (AddLabelCmd lcmd : switchLabelList) {
            lcmd.setNamespace(space);
            if (needTableNumber) {
                lcmd.setLabelName(lcmd.getLabelName() + "_" + Long.toHexString(tableNumber));
            }
            if ((oldSym = program.getSymbolTable().getPrimarySymbol(lcmd.getLabelAddr())) != null && oldSym.getSource() == SourceType.ANALYSIS && oldSym.getName().startsWith("Addr")) {
                oldSym.delete();
            }
            lcmd.applyTo((DomainObject)program);
        }
    }

    public void fixupFunctionBody(Program program, Instruction start_inst, TaskMonitor monitor) {
        Function func = program.getFunctionManager().getFunctionContaining(start_inst.getMinAddress());
        if (func == null) {
            return;
        }
        if (start_inst.getFlowType().isCall()) {
            return;
        }
        AddressSetView oldBody = func.getBody();
        Address entryPoint = func.getEntryPoint();
        AddressSetView funcBody = null;
        try {
            funcBody = CreateFunctionCmd.getFunctionBody(program, entryPoint);
            funcBody = funcBody.union(oldBody);
            AddressSet body = funcBody.union(this.getTableBody());
            Iterator fiter = program.getFunctionManager().getFunctionsOverlapping(funcBody);
            while (fiter.hasNext()) {
                Function function = (Function)fiter.next();
                if (function.getEntryPoint().equals((Object)func.getEntryPoint())) continue;
                body = body.subtract(function.getBody());
            }
            if (!oldBody.hasSameAddresses((AddressSetView)body)) {
                func.setBody((AddressSetView)body);
            }
        }
        catch (OverlappingFunctionException e) {
            try {
                funcBody = CreateFunctionCmd.getFunctionBody(monitor, program, entryPoint);
                funcBody = funcBody.union(oldBody);
                AddressSet body = funcBody.union(this.getTableBody());
                if (!oldBody.hasSameAddresses((AddressSetView)body)) {
                    func.setBody((AddressSetView)body);
                }
            }
            catch (OverlappingFunctionException e1) {
                try {
                    func.setBody(funcBody);
                }
                catch (OverlappingFunctionException overlappingFunctionException) {}
            }
            catch (CancelledException cancelledException) {
                // empty catch block
            }
        }
    }

    public void createTableIndex(Program program) {
        Listing listing = program.getListing();
        if (this.getTopIndexAddress() != null) {
            ByteDataType bdt = new ByteDataType();
            ArrayDataType arraydt = new ArrayDataType((DataType)bdt, this.getIndexLength(), bdt.getLength());
            try {
                listing.createData(this.getTopIndexAddress(), (DataType)arraydt, this.getIndexLength());
            }
            catch (CodeUnitInsertionException codeUnitInsertionException) {
                // empty catch block
            }
        }
    }

    public boolean isFunctionTable(Program program, int offset) {
        PseudoDisassembler pdis = new PseudoDisassembler(program);
        ArrayList<Address> disassembleList = new ArrayList<Address>();
        AddressSet execSet = this.getExecuteSet(program.getMemory());
        for (int j = offset; j < this.tableElements.length; ++j) {
            Address testAddr = this.tableElements[j];
            if (testAddr == null) {
                return false;
            }
            if (execSet != null && !execSet.contains(testAddr)) {
                return false;
            }
            if (pdis.isValidCode(testAddr)) {
                disassembleList.add(testAddr);
            }
            if (!this.tableContains(testAddr)) continue;
            disassembleList.add(testAddr);
        }
        return disassembleList.size() == this.tableElements.length - offset;
    }

    public ArrayList<Address> getFunctionEntries(Program program, int offset) {
        PseudoDisassembler pdis = new PseudoDisassembler(program);
        ArrayList<Address> disassembleList = new ArrayList<Address>();
        AddressSet execSet = this.getExecuteSet(program.getMemory());
        Listing listing = program.getListing();
        for (int j = offset; j < this.tableElements.length; ++j) {
            Address testAddr = this.tableElements[j];
            if (testAddr == null) {
                return disassembleList;
            }
            if (execSet != null && !execSet.contains(testAddr)) continue;
            Instruction instr = listing.getInstructionContaining(testAddr);
            if (instr != null) {
                if (!instr.getMinAddress().equals((Object)testAddr)) continue;
                disassembleList.add(testAddr);
                continue;
            }
            if (listing.getDefinedDataContaining(testAddr) != null || !pdis.isValidCode(testAddr)) continue;
            disassembleList.add(testAddr);
        }
        return disassembleList;
    }

    private AddressSet getExecuteSet(Memory memory) {
        MemoryBlock[] blocks;
        AddressSet set = new AddressSet();
        for (MemoryBlock block : blocks = memory.getBlocks()) {
            if (!block.isExecute()) continue;
            set.addRange(block.getStart(), block.getEnd());
        }
        return set.isEmpty() ? null : set;
    }

    public boolean disassemble(Program program, Instruction instr, TaskMonitor monitor) {
        ProgramContext programContext = program.getProgramContext();
        Register baseContextRegister = programContext.getBaseContextRegister();
        RegisterValue switchContext = null;
        if (baseContextRegister != null) {
            switchContext = programContext.getRegisterValue(baseContextRegister, instr.getMinAddress());
        }
        Listing listing = program.getListing();
        boolean gotNewCode = false;
        for (Address tableElement : this.tableElements) {
            Address caseStart = tableElement;
            if (listing.getUndefinedDataAt(caseStart) == null) continue;
            if (switchContext != null) {
                try {
                    RegisterValue curContext = programContext.getRegisterValue(baseContextRegister, caseStart);
                    if (curContext != null) {
                        curContext = curContext.combineValues(switchContext);
                        programContext.setRegisterValue(caseStart, caseStart, curContext);
                    } else {
                        programContext.setRegisterValue(caseStart, caseStart, switchContext);
                    }
                }
                catch (ContextChangeException e) {
                    continue;
                }
            }
            gotNewCode |= !this.disassembleTarget(program, caseStart, monitor).isEmpty();
        }
        return gotNewCode;
    }

    private AddressSet disassembleTarget(Program program, Address target, TaskMonitor monitor) {
        RegisterValue regContext = PseudoDisassembler.getTargetContextRegisterValueForDisassembly((Program)program, (Address)target);
        DisassembleCommand cmd = new DisassembleCommand(target, null, true);
        cmd.setInitialContext(regContext);
        cmd.applyTo((DomainObject)program, monitor);
        return cmd.getDisassembledAddressSet();
    }

    private boolean tableContains(Address testAddr) {
        Address end = this.topAddress.add((long)this.getByteLength());
        AddressRangeImpl range = new AddressRangeImpl(this.topAddress, end);
        return range.contains(testAddr);
    }

    private void setLabels(Program program, Address currentAddress, int len, int offset) {
        SymbolTable symbolTable = program.getSymbolTable();
        try {
            Symbol sym = symbolTable.getPrimarySymbol(currentAddress);
            if (sym == null || sym.isDynamic()) {
                symbolTable.createLabel(currentAddress, this.getTableName(offset), SourceType.ANALYSIS);
            } else if (sym.getName().regionMatches(0, NAME_PREFIX, 0, 9)) {
                sym.setName(this.getTableName(offset), SourceType.ANALYSIS);
            }
            if (this.getTopIndexAddress() != null) {
                Symbol indexSym = symbolTable.getPrimarySymbol(this.getTopIndexAddress());
                if (indexSym == null || indexSym.isDynamic()) {
                    symbolTable.createLabel(this.getTopIndexAddress(), this.getIndexName(offset), SourceType.ANALYSIS);
                } else if (indexSym.getName().regionMatches(0, "Index", 0, 5)) {
                    indexSym.setName(this.getIndexName(offset), SourceType.ANALYSIS);
                }
            }
        }
        catch (DuplicateNameException duplicateNameException) {
        }
        catch (InvalidInputException invalidInputException) {
            // empty catch block
        }
    }

    public String getTableTypeString(Memory memory) {
        Object str;
        Address addr = this.tableElements[0];
        DumbMemBufferImpl memBuf = new DumbMemBufferImpl(memory, addr);
        StringDataType sdt = new StringDataType();
        try {
            str = this.getByteCodeString(memBuf, null, null, this.addrSize) + " (" + sdt.getValue((MemBuffer)memBuf, SettingsImpl.NO_SETTINGS, this.addrSize) + ")";
        }
        catch (AddressOutOfBoundsException e) {
            str = "";
        }
        return str;
    }

    private String getByteCodeString(DumbMemBufferImpl memBuf, Object object, Object object2, int length) {
        StringBuffer bytes = new StringBuffer();
        for (int ii = 0; ii < length; ++ii) {
            String hex;
            if (ii != 0) {
                bytes.append(" ");
            }
            try {
                hex = Integer.toHexString(memBuf.getByte(ii));
            }
            catch (MemoryAccessException e) {
                hex = "00";
            }
            if (hex.length() == 1) {
                bytes.append("0");
            }
            if (hex.length() > 2) {
                bytes.append(hex.substring(hex.length() - 2));
                continue;
            }
            bytes.append(hex);
        }
        return bytes.toString();
    }

    public static AddressTable getEntry(Program program, Address topAddr, TaskMonitor monitor, boolean checkExisting, int minimumTableSize, int alignment, int skipAmount, long minAddressOffset, boolean useRelocationTable) {
        return AddressTable.getEntry(program, topAddr, monitor, checkExisting, minimumTableSize, alignment, skipAmount, minAddressOffset, true, false, useRelocationTable);
    }

    public static AddressTable getEntry(Program program, Address topAddr, TaskMonitor monitor, boolean checkExisting, int minimumTableSize, int alignment, int skipAmount, long minAddressOffset, boolean useShiftedAddressesIfNecessary, boolean checkForIndex, boolean useRelocationTable) {
        boolean shiftedAddresses;
        int addressShiftAmount;
        Memory memory = program.getMemory();
        Listing listing = program.getListing();
        if (useShiftedAddressesIfNecessary) {
            addressShiftAmount = program.getDataTypeManager().getDataOrganization().getPointerShift();
            shiftedAddresses = addressShiftAmount != 0;
        } else {
            shiftedAddresses = false;
            addressShiftAmount = 0;
        }
        int langAlignment = program.getLanguage().getInstructionAlignment();
        if (alignment < 1 && langAlignment != 1) {
            alignment = langAlignment;
        }
        if (alignment < 1 || alignment > 8) {
            alignment = 1;
        }
        if (topAddr.getOffset() % (long)alignment != 0L) {
            return null;
        }
        AddressRange range = memory.getRangeContaining(topAddr);
        if (range == null) {
            return null;
        }
        ArrayList<Address> arrayElements = new ArrayList<Address>();
        HashSet<Address> arrayEntries = new HashSet<Address>();
        int count = 0;
        Address currentAddr = topAddr;
        int addrSize = program.getDefaultPointerSize();
        AddressSet pointerSet = new AddressSet();
        while (!monitor.isCancelled() && range.contains(currentAddr)) {
            try {
                int addrInt;
                long addrLong = 0L;
                if (addrSize == 3) {
                    addrInt = memory.getInt(currentAddr);
                    addrLong = (long)addrInt & 0xFFFFFFFFL;
                }
                if (addrSize == 4) {
                    addrInt = memory.getInt(currentAddr);
                    addrLong = shiftedAddresses ? (long)(addrInt << addressShiftAmount) & 0xFFFFFFFFL : (long)addrInt & 0xFFFFFFFFL;
                } else if (addrSize == 8) {
                    addrLong = memory.getLong(currentAddr);
                }
                Address testAddr = currentAddr.getNewAddress(addrLong);
                if (testAddr.equals((Object)Address.NO_ADDRESS) || addrLong > 0L && addrLong < minAddressOffset || addrLong == 0L || testAddr.getOffset() % (long)alignment != 0L || !memory.contains(testAddr) || useRelocationTable && !AddressTable.isValidRelocationAddress(program, currentAddr) || count > 1 && program.getReferenceManager().getReferenceCountTo(currentAddr) > 0 || checkExisting && AddressTable.checkForCollisionAtTarget(program, testAddr)) break;
                arrayElements.add(testAddr);
                arrayEntries.add(currentAddr);
                pointerSet.add(currentAddr, currentAddr.add((long)(addrSize - 1)));
                currentAddr = currentAddr.add((long)(addrSize + skipAmount));
                ++count;
            }
            catch (MemoryAccessException e) {
                break;
            }
            catch (AddressOutOfBoundsException e) {
                // empty catch block
                break;
            }
        }
        if (count < minimumTableSize) {
            return null;
        }
        Address nextSymAddr = null;
        try {
            AddressIterator addrIter = program.getReferenceManager().getReferenceDestinationIterator(topAddr.add(1L), true);
            nextSymAddr = addrIter.next();
        }
        catch (AddressOutOfBoundsException addrIter) {
            // empty catch block
        }
        Address endAddr = topAddr.add((long)(count * (addrSize + skipAmount)));
        if (nextSymAddr != null && nextSymAddr.compareTo((Object)endAddr) < 0) {
            count = (int)(nextSymAddr.subtract(topAddr) / (long)(addrSize + skipAmount));
        }
        if (count < minimumTableSize) {
            return null;
        }
        if (checkExisting) {
            Address iAddr;
            CodeUnit codeUnitContaining = listing.getCodeUnitContaining(topAddr);
            if (codeUnitContaining != null) {
                if (!codeUnitContaining.getMinAddress().equals((Object)topAddr)) {
                    return null;
                }
                if (codeUnitContaining instanceof Instruction) {
                    return null;
                }
            }
            Instruction instructionAfter = listing.getInstructionAfter(topAddr);
            endAddr = topAddr.add((long)(count * (addrSize + skipAmount)));
            if (instructionAfter != null && (iAddr = instructionAfter.getMinAddress()).compareTo((Object)endAddr) < 0) {
                count = (int)(iAddr.subtract(topAddr) / (long)(addrSize + skipAmount));
            }
            if (count < minimumTableSize) {
                return null;
            }
            endAddr = topAddr.add((long)(count * (addrSize + skipAmount) - 1));
            DataIterator definedData = listing.getDefinedData(topAddr, true);
            while (definedData.hasNext()) {
                Data data = definedData.next();
                Address dataAddr = data.getMinAddress();
                if (data == null || dataAddr.compareTo((Object)endAddr) > 0) break;
                if (arrayEntries.contains(dataAddr) && data.isPointer() || !pointerSet.intersects(dataAddr, data.getMaxAddress())) continue;
                count = (int)(dataAddr.subtract(topAddr) / (long)(addrSize + skipAmount));
                break;
            }
        }
        if (count < minimumTableSize) {
            return null;
        }
        currentAddr = topAddr.add((long)(count * (addrSize + skipAmount)));
        Address tableElements = new Address[count];
        arrayElements.subList(0, count).toArray((T[])tableElements);
        arrayElements = null;
        if (checkForIndex && count < 128) {
            Address topIndexAddr = currentAddr;
            long maxIndexSize = 100000L;
            for (Address tableElement : tableElements) {
                long temp = tableElement.subtract(topIndexAddr);
                if (temp < 0L) {
                    MemoryBlock block = memory.getBlock(topIndexAddr);
                    temp = block == null ? 0L : block.getEnd().subtract(topIndexAddr);
                }
                if (temp >= maxIndexSize) continue;
                maxIndexSize = temp;
            }
            int numIndexBytes = 0;
            int numZeroBytes = 0;
            boolean isIndex = true;
            if (maxIndexSize == 0L) {
                isIndex = false;
            }
            while (isIndex && (long)numIndexBytes < maxIndexSize) {
                byte b;
                try {
                    b = memory.getByte(currentAddr);
                }
                catch (MemoryAccessException e) {
                    break;
                }
                if (b >= 0 && b < count) {
                    ++numIndexBytes;
                    if (b == 0) {
                        ++numZeroBytes;
                    }
                } else {
                    isIndex = false;
                }
                currentAddr = currentAddr.next();
            }
            if (numIndexBytes >= count && numZeroBytes < numIndexBytes && numZeroBytes < 100) {
                return new AddressTable(topAddr, (Address[])tableElements, topIndexAddr, numIndexBytes, addrSize, skipAmount, shiftedAddresses);
            }
        }
        return new AddressTable(topAddr, (Address[])tableElements, null, 0, addrSize, skipAmount, shiftedAddresses);
    }

    private static boolean checkForCollisionAtTarget(Program program, Address testAddr) {
        boolean allowOffcutCode = PseudoDisassembler.hasLowBitCodeModeInAddrValues((Program)program);
        Instruction instr = program.getListing().getInstructionContaining(testAddr);
        if (instr == null) {
            return false;
        }
        if (AddressTable.isOffcutReference(testAddr, instr.getMinAddress(), allowOffcutCode)) {
            return true;
        }
        if (instr.getFallFrom() != null) {
            return true;
        }
        Function func = program.getFunctionManager().getFunctionContaining(testAddr);
        if (func != null && AddressTable.isOffcutReference(testAddr, func.getEntryPoint(), allowOffcutCode)) {
            ReferenceIterator referencesTo = program.getReferenceManager().getReferencesTo(testAddr);
            for (Reference reference : referencesTo) {
                RefType referenceType = reference.getReferenceType();
                if (referenceType.isData()) {
                    return false;
                }
                if (!referenceType.isJump() || referenceType.isComputed()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean isOffcutReference(Address testAddr, Address target, boolean processorUsesLowBitForCode) {
        if (testAddr.equals((Object)target)) {
            return false;
        }
        return !processorUsesLowBitForCode || !target.isSuccessor(testAddr);
    }

    public static int getThresholdRunOfValidPointers(Program program, long oneInNumberOfCases) {
        MemoryBlock[] blocks = program.getMemory().getBlocks();
        double byteCount = 0.0;
        for (MemoryBlock memoryBlock : blocks) {
            if (memoryBlock.getStart().getAddressSpace().isOverlaySpace()) continue;
            byteCount += (double)memoryBlock.getSize();
        }
        double bitSize = program.getLanguage().getDefaultCompilerSpec().getDataOrganization().getPointerSize() * 8;
        double byteSize = Math.ceil(Math.pow(2.0, bitSize));
        if (byteCount >= byteSize) {
            return 0x100000;
        }
        double threshold = 1.0 / (double)oneInNumberOfCases;
        double numberInRowNeeded = Math.ceil(Math.log(threshold) / Math.log(byteCount / byteSize));
        return (int)numberInRowNeeded;
    }

    private static boolean isValidRelocationAddress(Program program, Address target) {
        RelocationTable relocationTable = program.getRelocationTable();
        return !relocationTable.isRelocatable() || relocationTable.getSize() <= 0 || relocationTable.getRelocation(target) != null;
    }

    public AddressSetView getTableBody() {
        AddressSet set = new AddressSet();
        set.addRange(this.topAddress, this.topAddress.add((long)(this.getByteLength() - 1)));
        if (this.topIndexAddress != null) {
            set.addRange(this.topIndexAddress, this.topIndexAddress.add((long)(this.indexLen - 1)));
        }
        return set;
    }

    public void setNegativeTable(boolean isNegative) {
        this.negativeTable = isNegative;
    }

    public boolean isNegativeTable() {
        return this.negativeTable;
    }

    public void changeEntry(int i, Address address) {
        if (i < 0 || i >= this.tableElements.length) {
            return;
        }
        this.tableElements[i] = address;
    }

    public void truncate(int tableLen) {
        Address[] newTable = new Address[tableLen];
        System.arraycopy(this.tableElements, 0, newTable, 0, tableLen);
        this.tableElements = newTable;
    }
}

