/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function.tags;

import generic.jar.ResourceFile;
import ghidra.app.plugin.core.function.tags.FunctionTagTemp;
import ghidra.framework.Application;
import ghidra.program.model.listing.FunctionTag;
import ghidra.util.Msg;
import ghidra.xml.NonThreadedXmlPullParserImpl;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class FunctionTagLoader {
    protected static List<FunctionTag> loadTags(File tagFile) {
        return FunctionTagLoader.loadTags(new ResourceFile(tagFile));
    }

    protected static List<FunctionTag> loadTags(String moduleDataFilePath) {
        try {
            return FunctionTagLoader.loadTags(Application.getModuleDataFile((String)moduleDataFilePath));
        }
        catch (FileNotFoundException e) {
            Msg.error(null, (Object)("Error loading function tags file from " + moduleDataFilePath), (Throwable)e);
            return new ArrayList<FunctionTag>();
        }
    }

    protected static List<FunctionTag> loadTags(ResourceFile tagDataFile) {
        ArrayList<FunctionTag> tags = new ArrayList<FunctionTag>();
        try {
            NonThreadedXmlPullParserImpl parser;
            ErrorHandler errHandler = new ErrorHandler(){

                @Override
                public void error(SAXParseException exception) throws SAXException {
                    throw new SAXException("Error: " + exception);
                }

                @Override
                public void fatalError(SAXParseException exception) throws SAXException {
                    throw new SAXException("Fatal error: " + exception);
                }

                @Override
                public void warning(SAXParseException exception) throws SAXException {
                    throw new SAXException("Warning: " + exception);
                }
            };
            try (InputStream inputStream = tagDataFile.getInputStream();){
                parser = new NonThreadedXmlPullParserImpl(inputStream, tagDataFile.getName(), errHandler, false);
            }
            parser.start(new String[]{"tags"});
            while (parser.hasNext()) {
                XmlElement el = parser.next();
                if (!el.isEnd() || !"name".equals(el.getName())) continue;
                String name = el.getText();
                String comment = "";
                if (name == null || name.trim().length() == 0) continue;
                if (parser.hasNext() && "comment".equals(parser.peek().getName())) {
                    el = parser.next();
                    comment = parser.end().getText();
                }
                FunctionTagTemp tag = new FunctionTagTemp(name, comment);
                tags.add(tag);
            }
            parser.dispose();
        }
        catch (XmlException e) {
            Msg.error(null, (Object)("Error parsing function tags from " + tagDataFile), (Throwable)e);
        }
        catch (IOException | SAXException e) {
            Msg.error(null, (Object)("Error loading function tags from " + tagDataFile), (Throwable)e);
        }
        return tags;
    }
}

