/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.marker;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import docking.widgets.PopupWindow;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.marker.AreaMarkerSet;
import ghidra.app.plugin.core.marker.MarkerPanel;
import ghidra.app.plugin.core.marker.MarkerSetImpl;
import ghidra.app.plugin.core.marker.NavigationPanel;
import ghidra.app.plugin.core.marker.PointMarkerSet;
import ghidra.app.services.GoToService;
import ghidra.app.services.MarkerService;
import ghidra.app.services.MarkerSet;
import ghidra.app.util.viewer.listingpanel.MarginProvider;
import ghidra.app.util.viewer.listingpanel.OverviewProvider;
import ghidra.app.util.viewer.listingpanel.VerticalPixelAddressMap;
import ghidra.app.util.viewer.util.AddressIndexMap;
import ghidra.framework.options.Options;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.MarkerLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.FixedSizeHashMap;
import ghidra.util.exception.AssertException;
import ghidra.util.task.SwingUpdateManager;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.event.ChangeListener;

public class MarkerManager
implements MarkerService {
    private static final String POPUP_WINDOW_NAME = "Bookmark ToolTip Window";
    private static final int MAX_TOOLTIP_LINES = 10;
    private MarkerPanel markPanel;
    private NavigationPanel navigationPanel;
    private MarkerActionList actionList;
    private VerticalPixelAddressMap pixmap;
    private AddressIndexMap addrMap;
    private Map<String, Map<Program, MarkerSetImpl>> groupToProgramMarkerMap;
    private List<MarkerSetImpl> currentMarkerSets;
    @Deprecated
    private List<MarkerSetImpl> deprecatedMarkerSets;
    private Map<Program, List<MarkerSetImpl>> markerSetCache;
    private SwingUpdateManager updateMgr;
    private GoToService goToService;
    private Navigatable navigatable;
    private MarginProvider marginProvider;
    private OverviewProvider overviewProvider;
    private PluginTool tool;
    private String owner;
    private Program currentProgram;
    private AddressColorCache addressColorCache = new AddressColorCache();
    private PopupWindow popupWindow;
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();

    public MarkerManager(Plugin ownerPlugin) {
        this(ownerPlugin.getName(), ownerPlugin.getTool());
    }

    public MarkerManager(String owner, PluginTool tool) {
        this.owner = owner;
        this.tool = tool;
        this.currentMarkerSets = Collections.emptyList();
        this.deprecatedMarkerSets = new ArrayList<MarkerSetImpl>();
        this.markerSetCache = new HashMap<Program, List<MarkerSetImpl>>();
        this.updateMgr = new SwingUpdateManager(100, 60000, () -> {
            this.markPanel.repaint();
            this.navigationPanel.repaint();
            this.notifyListeners();
        });
        this.navigationPanel = new NavigationPanel(this);
        this.navigationPanel.setPreferredSize(new Dimension(16, 1));
        this.navigationPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MarkerManager.this.updateMarkerSets(true, true, true);
            }
        });
        this.overviewProvider = new MyOverviewProvider();
        this.markPanel = new MarkerPanel(this);
        this.markPanel.setPreferredSize(new Dimension(16, 1));
        this.marginProvider = new MyMarginProvider();
        this.actionList = new MarkerActionList();
        this.groupToProgramMarkerMap = new HashMap<String, Map<Program, MarkerSetImpl>>();
    }

    void programClosed(Program program) {
        this.markerSetCache.remove(program);
        Map<String, Map<Program, MarkerSetImpl>> values = this.groupToProgramMarkerMap;
        Collection<Map<Program, MarkerSetImpl>> valueValues = values.values();
        for (Map<Program, MarkerSetImpl> map : valueValues) {
            map.remove(program);
        }
    }

    @Override
    public MarkerSet createAreaMarker(String name, String markerDescription, Program program, int priority, boolean showMarkers, boolean showNavigation, boolean colorBackground, Color color) {
        AreaMarkerSet mgr = new AreaMarkerSet(this, name, markerDescription, priority, showMarkers, showNavigation, colorBackground, color, program);
        this.insertManager(mgr, program);
        return mgr;
    }

    @Override
    public MarkerSet createAreaMarker(String name, String markerDescription, Program program, int priority, boolean showMarkers, boolean showNavigation, boolean colorBackground, Color color, boolean isPreferred) {
        AreaMarkerSet mgr = new AreaMarkerSet(this, name, markerDescription, priority, showMarkers, showNavigation, colorBackground, color, isPreferred);
        this.insertManager(mgr, program);
        return mgr;
    }

    @Override
    @Deprecated
    public MarkerSet createAreaMarker(String name, String markerDescription, int priority, boolean showMarkers, boolean showNavigation, boolean colorBackground, Color color) {
        AreaMarkerSet areaMarker = new AreaMarkerSet(this, name, markerDescription, priority, showMarkers, showNavigation, colorBackground, color, this.getProgram());
        this.insertManager(areaMarker);
        return areaMarker;
    }

    @Override
    public MarkerSet createPointMarker(String name, String markerDescription, Program program, int priority, boolean showMarkers, boolean showNavigation, boolean colorBackground, Color color, ImageIcon icon) {
        PointMarkerSet mgr = new PointMarkerSet(this, name, markerDescription, priority, showMarkers, showNavigation, colorBackground, color, icon);
        this.insertManager(mgr, program);
        return mgr;
    }

    @Override
    public MarkerSet createPointMarker(String name, String markerDescription, Program program, int priority, boolean showMarkers, boolean showNavigation, boolean colorBackground, Color color, ImageIcon icon, boolean isPreferred) {
        PointMarkerSet mgr = new PointMarkerSet(this, name, markerDescription, priority, showMarkers, showNavigation, colorBackground, color, icon, isPreferred);
        this.insertManager(mgr, program);
        return mgr;
    }

    @Override
    @Deprecated
    public MarkerSet createPointMarker(String name, String markerDescription, int priority, boolean showMarkers, boolean showNavigation, boolean colorBackground, Color color, ImageIcon icon) {
        PointMarkerSet pointMarker = new PointMarkerSet(this, name, markerDescription, priority, showMarkers, showNavigation, colorBackground, color, icon);
        this.insertManager(pointMarker);
        return pointMarker;
    }

    @Override
    @Deprecated
    public MarkerSet getMarkerSet(String name) {
        for (MarkerSetImpl set : this.deprecatedMarkerSets) {
            if (!name.equals(set.getName())) continue;
            return set;
        }
        return null;
    }

    @Override
    public MarkerSet getMarkerSet(String name, Program program) {
        if (name == null) {
            throw new NullPointerException("Marker set name cannot be null.");
        }
        if (program == null) {
            throw new NullPointerException("Program cannot be null.");
        }
        List<MarkerSetImpl> programMarkerList = this.markerSetCache.get(program);
        if (programMarkerList != null) {
            for (MarkerSetImpl set : programMarkerList) {
                if (!name.equals(set.getName())) continue;
                return set;
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public void removeMarker(MarkerSet markerManager) {
        if (markerManager == null) {
            return;
        }
        this.deprecatedMarkerSets.remove(markerManager);
        this.actionList.refresh();
        this.update();
    }

    @Override
    public void removeMarker(MarkerSet markerManager, Program program) {
        if (program == null) {
            throw new NullPointerException("Cannot remove marker set for a null program.");
        }
        this.doRemoveMarker(markerManager, program);
        this.actionList.refresh();
        this.update();
    }

    private void doRemoveMarker(MarkerSet markerManager, Program program) {
        if (markerManager == null || program == null) {
            return;
        }
        List<MarkerSetImpl> list = this.markerSetCache.get(program);
        if (list == null) {
            return;
        }
        list.remove(markerManager);
        Collection<Map<Program, MarkerSetImpl>> values = this.groupToProgramMarkerMap.values();
        for (Map<Program, MarkerSetImpl> map : values) {
            MarkerSetImpl markerSetImpl = map.get(program);
            if (markerSetImpl != markerManager) continue;
            map.clear();
            break;
        }
    }

    public MarginProvider getMarginProvider() {
        return this.marginProvider;
    }

    public OverviewProvider getOverviewProvider() {
        return this.overviewProvider;
    }

    public void setProgram(Program program) {
        this.currentProgram = program;
        this.addressColorCache.clear();
        if (program == null) {
            this.currentMarkerSets = Collections.emptyList();
            this.updateMgr.update();
            return;
        }
        this.setCurrentMarkerSets(program);
        this.actionList.refresh();
        this.updateMgr.update();
    }

    public void dispose() {
        if (this.updateMgr != null) {
            this.updateMgr.dispose();
        }
        this.actionList.dispose();
        this.deprecatedMarkerSets.clear();
        this.currentMarkerSets.clear();
        this.markerSetCache.clear();
    }

    void navigateTo(int x, int y) {
        int viewHeight = this.navigationPanel.getHeight() - 4;
        for (int i = this.currentMarkerSets.size() - 1; i >= 0; --i) {
            MarkerSetImpl marker = this.currentMarkerSets.get(i);
            if (!marker.isActive()) continue;
            GoToService service = this.getGoToService();
            ProgramLocation loc = marker.getProgramLocation(y, viewHeight, this.addrMap, x);
            if (loc == null || service == null) continue;
            service.goTo(this.navigatable, loc, loc.getProgram());
            break;
        }
    }

    void paintMarkers(Graphics g) {
        Iterator<MarkerSetImpl> iter = this.currentMarkerSets.iterator();
        int count = 0;
        while (iter.hasNext()) {
            MarkerSetImpl marker = iter.next();
            if (!marker.isActive()) continue;
            marker.paintMarkers(g, count++, this.pixmap, this.addrMap);
        }
    }

    void paintNavigation(Graphics g, NavigationPanel panel) {
        if (this.addrMap == null) {
            return;
        }
        int viewHeight = panel.getHeight() - 4;
        for (MarkerSetImpl mgr : this.currentMarkerSets) {
            if (!mgr.active) continue;
            mgr.paintNavigation(g, viewHeight, panel, this.addrMap);
        }
    }

    String getTooltip(MouseEvent event) {
        String tip = this.generateToolTip(event);
        if (tip == null) {
            return null;
        }
        JToolTip toolTip = new JToolTip();
        toolTip.setTipText("<html><font size=\"4\">" + tip);
        if (this.popupWindow != null) {
            this.popupWindow.dispose();
        }
        this.popupWindow = new PopupWindow(event.getComponent(), (JComponent)toolTip);
        this.popupWindow.setWindowName(POPUP_WINDOW_NAME);
        this.popupWindow.showPopup(event);
        return null;
    }

    String generateToolTip(MouseEvent event) {
        if (this.pixmap == null) {
            return null;
        }
        int y = event.getY();
        int x = event.getX();
        int layoutIndex = this.pixmap.findLayoutAt(y);
        Address layoutAddress = this.pixmap.getLayoutAddress(layoutIndex);
        if (layoutAddress == null) {
            return null;
        }
        List<String> lines = this.getMarkerTooltipLines(y, x, layoutIndex, layoutAddress);
        return this.toHTML(lines);
    }

    private List<String> getMarkerTooltipLines(int y, int x, int layoutIndex, Address layoutAddress) {
        Address endAddr = this.pixmap.getLayoutEndAddress(layoutIndex);
        ArrayList<String> lines = new ArrayList<String>();
        block0: for (int i = this.currentMarkerSets.size() - 1; i >= 0; --i) {
            MarkerSetImpl marker = this.currentMarkerSets.get(i);
            if (!marker.displayInMarkerBar()) continue;
            AddressSet set = marker.getAddressSet();
            AddressSet intersection = set.intersect((AddressSetView)new AddressSet(layoutAddress, endAddr));
            for (Address a : intersection.getAddresses(true)) {
                lines.add(this.getMarkerToolTip(marker, a, x, y));
                if (marker instanceof AreaMarkerSet) continue block0;
                if (lines.size() < 10) continue;
                lines.add("...");
                return lines;
            }
        }
        return lines;
    }

    private String getMarkerToolTip(MarkerSetImpl marker, Address a, int x, int y) {
        String markerTip = marker.getTooltip(a, x, y);
        if (markerTip == null) {
            markerTip = marker.getName();
        }
        return markerTip;
    }

    private String toHTML(List<String> lines) {
        if (lines.isEmpty()) {
            return null;
        }
        StringBuilder buffy = new StringBuilder("<html><font size=\"4\">");
        for (String string : lines) {
            buffy.append(string).append("<BR>");
        }
        return buffy.toString();
    }

    void update() {
        this.addressColorCache.clear();
        if (this.updateMgr != null) {
            this.updateMgr.update();
        }
    }

    @Deprecated
    private void insertManager(MarkerSetImpl mgr) {
        int index = Collections.binarySearch(this.deprecatedMarkerSets, mgr);
        if (index < 0) {
            index = -(index + 1);
        }
        this.deprecatedMarkerSets.add(index, mgr);
        this.actionList.refresh();
    }

    private void insertManager(MarkerSetImpl mgr, Program program) {
        if (program == null) {
            throw new AssertException("Program cannot be null");
        }
        List<MarkerSetImpl> markerSetList = this.getMarkerSetListForProgram(program);
        if (markerSetList == null) {
            return;
        }
        int index = Collections.binarySearch(markerSetList, mgr);
        if (index < 0) {
            index = -(index + 1);
        }
        markerSetList.add(index, mgr);
        this.actionList.refresh();
    }

    private void setCurrentMarkerSets(Program program) {
        boolean switchingLists;
        List<MarkerSetImpl> markerSetList = this.getMarkerSetListForProgram(program);
        boolean bl = switchingLists = markerSetList != this.currentMarkerSets;
        if (!switchingLists) {
            return;
        }
        this.currentMarkerSets = markerSetList;
        this.currentMarkerSets.removeAll(this.deprecatedMarkerSets);
        this.currentMarkerSets.addAll(this.deprecatedMarkerSets);
        Collections.sort(this.currentMarkerSets);
    }

    private List<MarkerSetImpl> getMarkerSetListForProgram(Program program) {
        if (program == null) {
            return null;
        }
        List<MarkerSetImpl> markerSetList = this.markerSetCache.get(program);
        if (markerSetList != null) {
            return markerSetList;
        }
        markerSetList = new ArrayList<MarkerSetImpl>();
        this.markerSetCache.put(program, markerSetList);
        return markerSetList;
    }

    private Address getAddress(int y) {
        if (this.pixmap == null) {
            return null;
        }
        int i = this.pixmap.findLayoutAt(y);
        return this.pixmap.getLayoutAddress(i);
    }

    private void updateMarkerSets(boolean updateMarkers, boolean updateNavigation, boolean updateNow) {
        for (MarkerSetImpl marker : this.currentMarkerSets) {
            marker.updateView(updateMarkers, updateNavigation);
        }
        if (this.updateMgr != null) {
            if (updateNow) {
                this.updateMgr.updateNow();
            } else {
                this.updateMgr.update();
            }
        }
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(null);
        }
    }

    private MarkerSetImpl getMarkerSet(Address addr) {
        for (int i = this.currentMarkerSets.size() - 1; i >= 0; --i) {
            MarkerSetImpl marker = this.currentMarkerSets.get(i);
            if (!marker.displayInMarkerBar() || !marker.contains(addr)) continue;
            return marker;
        }
        return null;
    }

    Program getProgram() {
        return this.currentProgram;
    }

    @Override
    public void setMarkerForGroup(String groupName, MarkerSet ms, Program program) {
        MarkerSetImpl previousSet;
        MarkerSetImpl markerSet;
        if (!(ms instanceof MarkerSetImpl)) {
            throw new IllegalArgumentException("Invalid marker set provided");
        }
        Map<Program, MarkerSetImpl> programToMarkerMap = this.groupToProgramMarkerMap.get(groupName);
        if (programToMarkerMap == null) {
            programToMarkerMap = new HashMap<Program, MarkerSetImpl>();
            this.groupToProgramMarkerMap.put(groupName, programToMarkerMap);
        }
        if ((markerSet = (MarkerSetImpl)ms) == (previousSet = programToMarkerMap.get(program))) {
            return;
        }
        this.removeMarker(previousSet, program);
        programToMarkerMap.put(program, markerSet);
        this.insertManager(markerSet, program);
    }

    @Override
    public void removeMarkerForGroup(String groupName, MarkerSet markerSet, Program program) {
        Map<Program, MarkerSetImpl> programToMarkerMap = this.groupToProgramMarkerMap.get(groupName);
        MarkerSet currentMarkerSet = programToMarkerMap.get(program);
        if (markerSet == currentMarkerSet) {
            programToMarkerMap.remove(program);
            this.removeMarker(currentMarkerSet, program);
        }
    }

    @Override
    public Color getBackgroundColor(Address address) {
        if (this.addressColorCache.containsKey(address)) {
            return (Color)this.addressColorCache.get(address);
        }
        Color color = null;
        for (int index = this.currentMarkerSets.size() - 1; index >= 0; --index) {
            MarkerSet marker = this.currentMarkerSets.get(index);
            if (!marker.isActive() || !marker.isColoringBackground() || !marker.contains(address)) continue;
            color = marker.getMarkerColor();
            break;
        }
        if (color != null) {
            this.addressColorCache.put(address, color);
        }
        return color;
    }

    public GoToService getGoToService() {
        if (this.goToService == null) {
            this.goToService = (GoToService)this.tool.getService(GoToService.class);
        }
        return this.goToService;
    }

    public void setGoToService(GoToService goToService) {
        this.goToService = goToService;
    }

    public void setNavigatable(Navigatable navigatable) {
        this.navigatable = navigatable;
    }

    static class AddressColorCache
    extends FixedSizeHashMap<Address, Color> {
        private static final int MAX_SIZE = 50;

        AddressColorCache() {
            super(50, 50);
        }
    }

    private class MyOverviewProvider
    implements OverviewProvider {
        private MyOverviewProvider() {
        }

        @Override
        public JComponent getComponent() {
            return MarkerManager.this.navigationPanel;
        }

        @Override
        public void setAddressIndexMap(AddressIndexMap map) {
            MarkerManager.this.addrMap = map;
            MarkerManager.this.updateMarkerSets(true, true, false);
        }
    }

    private class MyMarginProvider
    implements MarginProvider {
        private MyMarginProvider() {
        }

        @Override
        public JComponent getComponent() {
            return MarkerManager.this.markPanel;
        }

        @Override
        public MarkerLocation getMarkerLocation(int x, int y) {
            Address addr = MarkerManager.this.getAddress(y);
            if (addr == null) {
                return null;
            }
            MarkerSetImpl marker = MarkerManager.this.getMarkerSet(addr);
            return new MarkerLocation(marker, addr, x, y);
        }

        @Override
        public boolean isResizeable() {
            return false;
        }

        @Override
        public void setPixelMap(VerticalPixelAddressMap pixmap) {
            MarkerManager.this.pixmap = pixmap;
            MarkerManager.this.updateMarkerSets(true, false, true);
        }
    }

    private static class ActivateMarkerGroupAction
    extends ToggleDockingAction {
        private List<MarkerSetImpl> managerList;
        private NavigationPanel panel;
        private Options options;

        ActivateMarkerGroupAction(String owner, List<MarkerSetImpl> managerList, NavigationPanel panel, Options options) {
            super(managerList.get(0).getName(), owner);
            this.managerList = managerList;
            this.panel = panel;
            this.options = options;
            HelpLocation helpLocation = new HelpLocation("CodeBrowserPlugin", "Markers");
            options.registerOption(this.getName(), (Object)true, helpLocation, "This options enables/disables the display of " + this.getName() + " marker types.");
            this.setEnabled(true);
            this.setSelected(this.isActive());
            ImageIcon icon = managerList.get(0).getNavIcon();
            this.setPopupMenuData(new MenuData(new String[]{this.getName()}, (Icon)icon));
            boolean isEnabled = this.isOptionEnabled();
            this.setSelected(isEnabled);
            this.setActive(isEnabled);
            this.setHelpLocation(helpLocation);
        }

        private void setActive(boolean active) {
            for (MarkerSetImpl manager : this.managerList) {
                manager.setActive(active);
            }
        }

        private boolean isActive() {
            for (MarkerSetImpl manager : this.managerList) {
                if (!manager.isActive()) continue;
                return true;
            }
            return false;
        }

        public boolean isEnabledForContext(ActionContext context) {
            Object contextObject = context.getContextObject();
            return contextObject == this.panel;
        }

        void optionsChanged() {
            boolean selected = this.isOptionEnabled();
            if (selected != this.isSelected()) {
                this.setSelected(selected);
                this.setActive(selected);
            }
        }

        private boolean isOptionEnabled() {
            return this.options.getBoolean(this.getName(), true);
        }

        public void actionPerformed(ActionContext context) {
            this.options.setBoolean(this.getName(), this.isSelected());
            this.setActive(this.isSelected());
        }
    }

    private static class ActivateMarkerAction
    extends ToggleDockingAction {
        private MarkerSetImpl mgr;
        private NavigationPanel panel;
        private Options options;

        ActivateMarkerAction(String owner, MarkerSetImpl mgr, NavigationPanel panel, Options options) {
            super(mgr.getName(), owner);
            this.mgr = mgr;
            this.panel = panel;
            this.options = options;
            HelpLocation helpLocation = new HelpLocation("CodeBrowserPlugin", "Markers");
            options.registerOption(mgr.getName(), (Object)true, helpLocation, "This options enables/disables the display of " + mgr.getName() + " marker types.");
            this.setEnabled(true);
            this.setSelected(mgr.active);
            this.setPopupMenuData(new MenuData(new String[]{mgr.getName()}, (Icon)mgr.getNavIcon(), null));
            boolean isEnabled = this.isOptionEnabled();
            this.setSelected(isEnabled);
            mgr.setActive(isEnabled);
            HelpLocation location = new HelpLocation("CodeBrowserPlugin", "Markers");
            this.setHelpLocation(location);
        }

        public boolean isEnabledForContext(ActionContext context) {
            Object contextObject = context.getContextObject();
            return contextObject == this.panel;
        }

        void optionsChanged() {
            boolean selected = this.isOptionEnabled();
            if (selected != this.isSelected()) {
                this.setSelected(selected);
                this.mgr.setActive(selected);
            }
        }

        private boolean isOptionEnabled() {
            return this.options.getBoolean(this.mgr.getName(), true);
        }

        public void actionPerformed(ActionContext context) {
            this.options.setBoolean(this.mgr.getName(), this.isSelected());
            this.mgr.setActive(this.isSelected());
        }
    }

    class MarkerActionList
    implements OptionsChangeListener {
        private ArrayList<DockingAction> actions = new ArrayList();
        private ToolOptions listOptions;

        MarkerActionList() {
            this.initOptions();
            this.refresh();
        }

        private void initOptions() {
            this.listOptions = MarkerManager.this.tool.getOptions("Navigation Markers");
            this.listOptions.removeOptionsChangeListener((OptionsChangeListener)this);
            this.listOptions.addOptionsChangeListener((OptionsChangeListener)this);
        }

        public void optionsChanged(ToolOptions options, String name, Object oldValue, Object newValue) {
            for (DockingAction action : this.actions) {
                if (action instanceof ActivateMarkerAction) {
                    ((ActivateMarkerAction)action).optionsChanged();
                }
                if (!(action instanceof ActivateMarkerGroupAction)) continue;
                ((ActivateMarkerGroupAction)action).optionsChanged();
            }
        }

        void refresh() {
            SystemUtilities.runSwingLater(() -> this.doRefresh());
        }

        private void doRefresh() {
            ToggleDockingAction action;
            if (MarkerManager.this.tool == null || MarkerManager.this.currentProgram == null) {
                return;
            }
            for (DockingAction dockingAction : this.actions) {
                MarkerManager.this.tool.removeAction((DockingActionIf)dockingAction);
            }
            this.actions.clear();
            ArrayList<MarkerSetImpl> list = new ArrayList<MarkerSetImpl>();
            for (MarkerSetImpl mgr : MarkerManager.this.currentMarkerSets) {
                list.add(mgr);
            }
            List<List<MarkerSetImpl>> list2 = this.extractManagerGroups(list);
            Collections.sort(list2, (ms1, ms2) -> ((MarkerSetImpl)ms1.get(0)).getName().compareTo(((MarkerSetImpl)ms2.get(0)).getName()));
            for (List<MarkerSetImpl> group : list2) {
                action = new ActivateMarkerGroupAction(MarkerManager.this.owner, group, MarkerManager.this.navigationPanel, (Options)this.listOptions);
                this.actions.add((DockingAction)action);
                MarkerManager.this.tool.addAction((DockingActionIf)action);
            }
            Collections.sort(list, (ms1, ms2) -> ms1.getName().compareTo(ms2.getName()));
            for (MarkerSetImpl mgr : list) {
                action = new ActivateMarkerAction(MarkerManager.this.owner, mgr, MarkerManager.this.navigationPanel, (Options)this.listOptions);
                this.actions.add((DockingAction)action);
                MarkerManager.this.tool.addAction((DockingActionIf)action);
            }
            MarkerManager.this.navigationPanel.repaint();
        }

        private List<List<MarkerSetImpl>> extractManagerGroups(List<MarkerSetImpl> fromList) {
            HashMap<String, ArrayList<MarkerSetImpl>> nameToManagerMap = new HashMap<String, ArrayList<MarkerSetImpl>>();
            Iterator<MarkerSetImpl> iterator = fromList.iterator();
            while (iterator.hasNext()) {
                MarkerSetImpl markerSetImpl = iterator.next();
                String name = markerSetImpl.getName();
                ArrayList<MarkerSetImpl> subList = (ArrayList<MarkerSetImpl>)nameToManagerMap.get(name);
                if (subList == null) {
                    subList = new ArrayList<MarkerSetImpl>();
                    nameToManagerMap.put(name, subList);
                }
                subList.add(markerSetImpl);
                iterator.remove();
            }
            ArrayList<List<MarkerSetImpl>> groupList = new ArrayList<List<MarkerSetImpl>>(fromList.size());
            Set entrySet = nameToManagerMap.entrySet();
            for (Map.Entry entry : entrySet) {
                List listValue = (List)entry.getValue();
                if (listValue.size() == 1) {
                    fromList.add((MarkerSetImpl)listValue.get(0));
                    continue;
                }
                groupList.add(listValue);
            }
            return groupList;
        }

        void dispose() {
            this.listOptions.removeOptionsChangeListener((OptionsChangeListener)this);
            for (DockingAction action : this.actions) {
                MarkerManager.this.tool.removeAction((DockingActionIf)action);
            }
        }
    }
}

