/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation.locationreferences;

import docking.widgets.fieldpanel.support.Highlight;
import ghidra.app.plugin.core.navigation.FunctionUtils;
import ghidra.app.plugin.core.navigation.locationreferences.LocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReference;
import ghidra.app.plugin.core.navigation.locationreferences.ReferenceUtils;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.FieldStringInfo;
import ghidra.app.util.viewer.field.FunctionSignatureFieldFactory;
import ghidra.app.util.viewer.field.OperandFieldFactory;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.util.FunctionLocation;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.program.util.ProgramLocation;
import ghidra.util.UndefinedFunction;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;

class FunctionSignatureFieldLocationDescriptor
extends LocationDescriptor {
    protected Function function;

    FunctionSignatureFieldLocationDescriptor(FunctionLocation location, Program program) {
        super((ProgramLocation)location, program);
        this.validate(location);
        this.programLocation = location;
        this.program = program;
        FunctionManager functionManager = program.getFunctionManager();
        this.function = functionManager.getFunctionAt(location.getFunctionAddress());
        if (this.function == null) {
            this.function = new UndefinedFunction(program, location.getFunctionAddress());
        }
        this.init();
    }

    protected void validate(FunctionLocation location) {
        if (location == null) {
            throw new NullPointerException("Cannot create a LocationDescriptor from a null ProgramLocation");
        }
    }

    protected void init() {
        this.validate((FunctionLocation)((FunctionSignatureFieldLocation)this.programLocation));
        this.homeAddress = this.function.getEntryPoint();
        this.label = this.function.getName();
    }

    @Override
    protected boolean domainObjectChanged(DomainObjectChangedEvent changeEvent) {
        if (super.domainObjectChanged(changeEvent)) {
            return true;
        }
        for (int i = 0; i < changeEvent.numRecords(); ++i) {
            Address containingEntryPoint;
            DomainObjectChangeRecord domainObjectRecord = changeEvent.getChangeRecord(i);
            int eventType = domainObjectRecord.getEventType();
            if (!(domainObjectRecord instanceof ProgramChangeRecord)) continue;
            ProgramChangeRecord programChangeRecord = (ProgramChangeRecord)domainObjectRecord;
            if (eventType == 151) {
                Address effectedEntryPoint = programChangeRecord.getStart();
                if (!effectedEntryPoint.equals((Object)this.function.getEntryPoint())) continue;
                this.checkForAddressChange(domainObjectRecord);
                return true;
            }
            if (eventType != 61) continue;
            Address addr = programChangeRecord.getStart();
            Function functionContaining = this.program.getFunctionManager().getFunctionContaining(addr);
            if (functionContaining == null || !(containingEntryPoint = functionContaining.getEntryPoint()).equals((Object)this.function.getEntryPoint())) continue;
            this.checkForAddressChange(domainObjectRecord);
            return true;
        }
        return false;
    }

    @Override
    protected void doGetReferences(Accumulator<LocationReference> accumulator, TaskMonitor monitor) throws CancelledException {
        ReferenceUtils.getReferences(accumulator, this.programLocation, monitor);
    }

    @Override
    Highlight[] getHighlights(String text, Object object, Class<? extends FieldFactory> fieldFactoryClass, Color highlightColor) {
        Address currentAddress = this.getAddressForHighlightObject(object);
        if (!this.isInAddresses(currentAddress)) {
            return this.EMPTY_HIGHLIGHTS;
        }
        if (OperandFieldFactory.class.isAssignableFrom(fieldFactoryClass) && !currentAddress.equals((Object)this.homeAddress)) {
            String functionNameString = this.getFunctionNameString(text);
            int offset = text.indexOf(functionNameString);
            if (offset >= 0) {
                int length = offset + functionNameString.length() - 1;
                return new Highlight[]{new Highlight(offset, length, highlightColor)};
            }
        } else if (FunctionSignatureFieldFactory.class.isAssignableFrom(fieldFactoryClass)) {
            FieldStringInfo nameStringInfo = FunctionUtils.getFunctionNameStringInfo(this.function, text);
            String functionName = nameStringInfo.getFieldString();
            int offset = nameStringInfo.getOffset();
            return new Highlight[]{new Highlight(offset, functionName.length() + offset - 1, highlightColor)};
        }
        return this.EMPTY_HIGHLIGHTS;
    }

    private String getFunctionNameString(String text) {
        String functionName = this.function.getName(true);
        if (text.indexOf(functionName) != -1) {
            return functionName;
        }
        return this.function.getName();
    }

    @Override
    ProgramLocation getHomeLocation() {
        return this.programLocation;
    }
}

