/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.programtree;

import ghidra.app.events.TreeSelectionPluginEvent;
import ghidra.app.plugin.core.programtree.ProgramDnDTree;
import ghidra.app.plugin.core.programtree.ProgramNode;
import ghidra.app.plugin.core.programtree.ProgramTreePlugin;
import ghidra.app.plugin.core.programtree.TreeListener;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import ghidra.program.util.GroupPath;
import ghidra.program.util.GroupView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

class ProgramTreePanel
extends JPanel
implements ChangeListener {
    private Program program;
    private ProgramDnDTree tree;
    private JScrollPane scrollp;
    private DefaultTreeModel treeModel;
    private Comparator<TreePath> nodeComparator;
    private PluginTool tool;
    private ProgramTreePlugin plugin;

    ProgramTreePanel(String treeName, ProgramTreePlugin plugin) {
        this.plugin = plugin;
        this.create(treeName);
        this.initialize();
        if (this.tree != null) {
            this.tree.setToggleClickCount(0);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof JViewport) {
            JViewport viewport = (JViewport)e.getSource();
            Rectangle viewRect = viewport.getViewRect();
            Rectangle treeRect = this.tree.getBounds();
            if (viewRect.y < treeRect.y) {
                treeRect.y = 0;
                this.tree.setBounds(treeRect);
            }
            this.invalidate();
            this.validate();
        } else {
            this.tool.setConfigChanged(true);
        }
    }

    void setTreeName(String treeName) {
        this.tree.setTreeName(treeName);
    }

    void setProgram(Program p) {
        this.tree.clearSelection();
        this.tree.setProgram(p);
        this.program = p;
        if (p != null) {
            ProgramNode root = (ProgramNode)this.treeModel.getRoot();
            this.tree.setViewPaths(new TreePath[]{root.getTreePath()});
        }
    }

    Program getProgram() {
        return this.program;
    }

    void addTreeListener(TreeListener l) {
        this.tree.addTreeListener(l);
    }

    void removeTreeListener() {
        this.tree.removeTreeListener();
    }

    void addGroupViewPath(GroupPath p) {
        this.tree.addGroupViewPath(p);
    }

    void setGroupView(GroupView view) {
        int count = view.getCount();
        GroupPath[] gp = new GroupPath[count];
        for (int i = 0; i < count; ++i) {
            gp[i] = view.getPath(i);
        }
        this.tree.setGroupViewPaths(gp);
    }

    void setGroupSelection(GroupPath[] groupPaths) {
        this.tree.setGroupSelection(groupPaths);
    }

    GroupView getGroupView() {
        ArrayList<TreePath> viewList = this.tree.getViewList();
        ArrayList<GroupPath> list = new ArrayList<GroupPath>();
        for (int i = 0; i < viewList.size(); ++i) {
            TreePath p = viewList.get(i);
            ProgramNode node = (ProgramNode)p.getLastPathComponent();
            GroupPath gp = node.getGroupPath();
            if (gp == null) continue;
            list.add(gp);
        }
        GroupPath[] gps = new GroupPath[list.size()];
        gps = list.toArray(gps);
        return new GroupView(gps);
    }

    GroupPath[] getSelectedGroupPaths() {
        return this.tree.getSelectedGroupPaths();
    }

    void setHasFocus(boolean state) {
        this.tree.setHasFocus(state);
    }

    ProgramNode prepareSelectionForPopup(MouseEvent event) {
        return this.tree.prepareSelectionForPopup(event);
    }

    GroupPath[] getViewedGroups() {
        ArrayList<TreePath> list = new ArrayList<TreePath>(this.tree.getViewList());
        Collections.sort(list, this.nodeComparator);
        GroupPath[] gp = new GroupPath[list.size()];
        for (int i = 0; i < gp.length; ++i) {
            TreePath path = list.get(i);
            ProgramNode node = (ProgramNode)path.getLastPathComponent();
            gp[i] = node.getGroupPath();
        }
        return gp;
    }

    ProgramNode getSelectedNode() {
        if (this.tree.getSelectionCount() == 0) {
            return null;
        }
        return (ProgramNode)this.tree.getSelectionPath().getLastPathComponent();
    }

    String getTreeName() {
        return this.tree.getTreeName();
    }

    ProgramDnDTree getDnDTree() {
        return this.tree;
    }

    private void create(String treeName) {
        this.setLayout(new BorderLayout());
        ProgramNode root = null;
        root = new ProgramNode(null, "No Program");
        this.treeModel = new DefaultTreeModel(root);
        this.tree = new ProgramDnDTree(treeName, this.treeModel, this.plugin);
        this.scrollp = new JScrollPane(this.tree);
        this.scrollp.setPreferredSize(new Dimension(300, 300));
        this.add((Component)this.scrollp, "Center");
        this.scrollp.getViewport().addChangeListener(this);
        this.setFocusable(false);
    }

    private void initialize() {
        this.addListeners();
        this.nodeComparator = this.tree.getNodeComparator();
    }

    private void fireSelectionEvent() {
        GroupPath[] groupPaths = this.getSelectedGroupPaths();
        this.plugin.firePluginEvent(new TreeSelectionPluginEvent(this.plugin.getName(), this.getTreeName(), groupPaths));
    }

    private void checkMouseEvent(MouseEvent e) {
        int selectedRow = this.tree.getRowForLocation(e.getX(), e.getY());
        if (selectedRow < 0) {
            return;
        }
        if (e.getClickCount() == 2 && e.getButton() == 1) {
            TreePath path = this.tree.getPathForRow(selectedRow);
            ProgramNode node = (ProgramNode)path.getLastPathComponent();
            this.plugin.doubleClick(node);
        }
    }

    void replaceView(ProgramNode node) {
        this.tree.setViewPaths(new TreePath[]{node.getTreePath()});
    }

    private void addListeners() {
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ProgramTreePanel.this.checkMouseEvent(e);
            }
        });
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ProgramTreePanel.this.fireSelectionEvent();
            }
        });
    }
}

