/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.select.reference;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.context.NavigatableActionContext;
import ghidra.app.context.NavigatableContextAction;
import ghidra.app.nav.NavigationUtils;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.util.ProgramSelection;
import ghidra.util.HelpLocation;

public class SelectBackRefsAction
extends NavigatableContextAction {
    private final PluginTool tool;

    SelectBackRefsAction(PluginTool tool, String owner) {
        super("Back Refs", owner);
        this.tool = tool;
        String group = "references";
        this.setMenuBarData(new MenuData(new String[]{"Select", "Back Refs"}, null, group));
        this.setKeyBindingData(new KeyBindingData(59, 2));
        this.setHelpLocation(new HelpLocation("Selection", "Backward"));
    }

    @Override
    protected boolean isEnabledForContext(NavigatableActionContext context) {
        return context.getAddress() != null || context.hasSelection();
    }

    @Override
    public void actionPerformed(NavigatableActionContext context) {
        ProgramSelection addressSet = null;
        addressSet = context.hasSelection() ? context.getSelection() : new AddressSet(context.getAddress());
        ProgramSelection selection = this.getSelection(context.getProgram(), addressSet);
        NavigationUtils.setSelection(this.tool, context.getNavigatable(), selection);
    }

    private ProgramSelection getSelection(Program program, AddressSetView addressSetView) {
        AddressSet addressSet = new AddressSet();
        AddressIterator refAddrIter = program.getReferenceManager().getReferenceDestinationIterator(addressSetView, true);
        while (refAddrIter.hasNext()) {
            Address reffedAddr = refAddrIter.next();
            ReferenceIterator memRefIter = program.getReferenceManager().getReferencesTo(reffedAddr);
            while (memRefIter.hasNext()) {
                Reference memRef = memRefIter.next();
                Address addr = memRef.getFromAddress();
                if (!addr.isMemoryAddress()) continue;
                addressSet.addRange(addr, addr);
            }
        }
        return new ProgramSelection((AddressSetView)addressSet);
    }
}

