/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.spaceview;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Hashtable;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class SpacecurveRasterPanel
extends JPanel {
    protected static final Hashtable<?, ?> EMPTY_HASHTABLE = new Hashtable();
    byte[] raster;
    private int width;
    private int height;
    private IndexColorModel colorModel;

    public SpacecurveRasterPanel(IndexColorModel colorModel) {
        this.colorModel = colorModel;
    }

    public void setRaster(byte[] raster, int width, int height) {
        if (raster.length != width * height) {
            throw new IllegalArgumentException("raster.length != width * height");
        }
        this.raster = raster;
        this.width = width;
        this.height = height;
        this.repaint();
    }

    public void setColorModel(IndexColorModel colorModel) {
        this.colorModel = colorModel;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.raster != null) {
            DataBufferByte dbb = new DataBufferByte(this.raster, this.height * this.width, 0);
            ComponentSampleModel sm = this.getComponentSampleModel();
            WritableRaster wr = Raster.createWritableRaster(sm, dbb, null);
            BufferedImage img = new BufferedImage(this.colorModel, wr, true, EMPTY_HASHTABLE);
            g2.drawImage((Image)img, 0, 0, null);
        }
    }

    protected ComponentSampleModel getComponentSampleModel() {
        return new ComponentSampleModel(0, this.width, this.height, 1, this.width, new int[]{0});
    }

    public static void main(String[] args) {
        byte[] red = new byte[256];
        byte[] grn = new byte[256];
        byte[] blu = new byte[256];
        for (int ii = 0; ii < 256; ++ii) {
            int jj = 255 - ii;
            red[ii] = (byte)jj;
            grn[ii] = (byte)(jj * jj / 255);
            blu[ii] = (byte)(Math.sqrt(jj) / Math.sqrt(255.0) * 255.0);
        }
        IndexColorModel colorModel = new IndexColorModel(8, 256, red, grn, blu);
        int width = 256;
        int height = 256;
        byte[] raster = new byte[65536];
        for (int ii = 0; ii < raster.length; ++ii) {
            raster[ii] = (byte)(ii * 1 % 256);
        }
        SpacecurveRasterPanel panel = new SpacecurveRasterPanel(colorModel);
        panel.setRaster(raster, 256, 256);
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(panel);
        frame.setSize(256, 256);
        frame.setVisible(true);
    }
}

