/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.match;

import generic.hash.FNV1a64MessageDigest;
import generic.hash.MessageDigest;
import generic.stl.Pair;
import ghidra.app.plugin.match.AbstractFunctionHasher;
import ghidra.program.model.lang.IncompatibleMaskException;
import ghidra.program.model.lang.Mask;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;

public class ExactInstructionsFunctionHasher
extends AbstractFunctionHasher {
    public static final ExactInstructionsFunctionHasher INSTANCE = new ExactInstructionsFunctionHasher();
    protected MessageDigest digest = new FNV1a64MessageDigest();

    protected ExactInstructionsFunctionHasher() {
    }

    @Override
    public int commonBitCount(Function funcA, Function funcB, TaskMonitor monitor) {
        int count = 0;
        Pair<Integer, ArrayList<CodeUnit>> aCodeUnitsPair = this.getAllCodeUnits(monitor, funcA.getProgram(), funcA.getBody());
        Pair<Integer, ArrayList<CodeUnit>> bCodeUnitsPair = this.getAllCodeUnits(monitor, funcB.getProgram(), funcB.getBody());
        if (((ArrayList)aCodeUnitsPair.second).size() != ((ArrayList)bCodeUnitsPair.second).size()) {
            throw new RuntimeException("different number of codeunits");
        }
        for (int ii = 0; ii < ((ArrayList)aCodeUnitsPair.second).size(); ++ii) {
            CodeUnit aUnit = (CodeUnit)((ArrayList)aCodeUnitsPair.second).get(ii);
            CodeUnit bUnit = (CodeUnit)((ArrayList)aCodeUnitsPair.second).get(ii);
            try {
                byte[] aBytes = aUnit.getBytes();
                byte[] bBytes = bUnit.getBytes();
                if (aBytes.length != bBytes.length) continue;
                for (int jj = 0; jj < aBytes.length; ++jj) {
                    count += Integer.bitCount(0xFF & ~(aBytes[jj] ^ bBytes[jj]));
                }
                continue;
            }
            catch (MemoryAccessException memoryAccessException) {
                // empty catch block
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long hash(TaskMonitor monitor, ArrayList<CodeUnit> units, int byteCount) throws MemoryAccessException, CancelledException {
        byte[] buffer = new byte[byteCount];
        int offset = 0;
        for (CodeUnit codeUnit : units) {
            monitor.checkCanceled();
            try {
                codeUnit.getBytesInCodeUnit(buffer, offset);
                ExactInstructionsFunctionHasher.applyMask(buffer, offset, codeUnit);
            }
            catch (MemoryAccessException e) {
                Msg.warn((Object)this, (Object)("Could not get code unit bytes at " + codeUnit.getAddress()));
            }
            offset += codeUnit.getLength();
        }
        if (offset != byteCount) {
            throw new IllegalStateException("did NOT use all the codeUnit buffer bytes");
        }
        MessageDigest messageDigest = this.digest;
        synchronized (messageDigest) {
            this.digest.reset();
            this.digest.update(buffer, monitor);
            return this.digest.digestLong();
        }
    }

    private static void applyMask(byte[] buffer, int offset, CodeUnit codeUnit) {
        if (!(codeUnit instanceof Instruction)) {
            return;
        }
        Instruction i = (Instruction)codeUnit;
        Mask mask = i.getPrototype().getInstructionMask();
        if (mask == null) {
            return;
        }
        try {
            mask.applyMask(buffer, offset, buffer, offset);
        }
        catch (IncompatibleMaskException e) {
            throw new RuntimeException(e);
        }
    }
}

