/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.prototype.analysis;

import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.bookmark.BookmarkEditCmd;
import ghidra.app.plugin.core.clear.ClearFlowAndRepairCmd;
import ghidra.app.services.AbstractAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.PseudoDisassembler;
import ghidra.app.util.PseudoDisassemblerContext;
import ghidra.app.util.PseudoFlowProcessor;
import ghidra.app.util.PseudoInstruction;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.ContextChangeException;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.FlowType;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.Msg;
import ghidra.util.task.TaskMonitor;
import java.math.BigInteger;
import java.util.Iterator;

public class ArmAggressiveInstructionFinderAnalyzer
extends AbstractAnalyzer {
    private static final String NAME = "ARM Aggressive Instruction Finder";
    private static final String DESCRIPTION = "Aggressively attempt to disassemble ARM/Thumb mixed code.";
    private Program curProgram;
    private Listing listing;
    private int numInstr = 0;
    private boolean addsInfo = false;
    private Register tmodeReg;
    private AddressSet lastBody = null;
    private int lastBodyTheSameCount = 0;
    private PseudoDisassembler pseudo;
    private AddressSetView todoSet;

    public ArmAggressiveInstructionFinderAnalyzer() {
        super(NAME, DESCRIPTION, AnalyzerType.BYTE_ANALYZER);
        this.setPrototype();
        this.setPriority(AnalysisPriority.DATA_TYPE_PROPOGATION.after());
        this.setSupportsOneTimeAnalysis();
    }

    @Override
    public boolean canAnalyze(Program p) {
        Language language = p.getLanguage();
        return language.getProcessor().equals((Object)Processor.findOrPossiblyCreateProcessor((String)"ARM"));
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) {
        this.curProgram = program;
        this.listing = program.getListing();
        this.todoSet = this.checkExecBlocks(program, set);
        this.tmodeReg = this.curProgram.getProgramContext().getRegister("TMode");
        this.lastBody = null;
        this.lastBodyTheSameCount = 0;
        this.pseudo = new PseudoDisassembler(program);
        monitor.setMessage("ARM AIF " + set.getMinAddress());
        SymbolTable symbolTable = this.curProgram.getSymbolTable();
        AddressIterator iter = symbolTable.getExternalEntryPointIterator();
        while (iter.hasNext()) {
            Address entry = iter.next();
            if (monitor.isCancelled()) {
                return true;
            }
            if (!this.todoSet.contains(entry)) continue;
            Symbol symbol = symbolTable.getPrimarySymbol(entry);
            AddressSet subSet = new AddressSet(entry, entry);
            this.todoSet = this.todoSet.subtract((AddressSetView)subSet);
            if (!symbol.isExternalEntryPoint() || !this.doValidStart(entry, monitor)) continue;
            this.scheduleFollowOnAnalysis(this.curProgram, this.todoSet);
            return true;
        }
        while (!this.todoSet.isEmpty()) {
            boolean isvalid;
            Address minAddr = this.todoSet.getMinAddress();
            if (minAddr.getOffset() % 2L != 0L) {
                this.todoSet = this.todoSet.subtract((AddressSetView)new AddressSet(minAddr, minAddr));
                continue;
            }
            Data data = this.listing.getUndefinedDataAt(minAddr);
            if (data == null) {
                this.todoSet = this.todoSet.subtract((AddressSetView)new AddressSet(minAddr, minAddr));
                data = this.listing.getFirstUndefinedData(this.todoSet, monitor);
            }
            if (data == null) {
                return true;
            }
            Address entry = data.getMinAddress();
            if (monitor.isCancelled()) break;
            AddressSet subSet = new AddressSet(this.todoSet.getMinAddress(), data.getMaxAddress());
            boolean contains = this.todoSet.contains(entry);
            this.todoSet = this.todoSet.subtract((AddressSetView)subSet);
            if (!contains || !(isvalid = this.doValidStart(entry, monitor))) continue;
            this.scheduleFollowOnAnalysis(program, this.todoSet);
            return true;
        }
        Iterator biter = this.curProgram.getBookmarkManager().getBookmarksIterator("Error");
        while (biter.hasNext() && !monitor.isCancelled()) {
            Instruction beforeInstr;
            Bookmark abmark;
            Bookmark bookmark = (Bookmark)biter.next();
            Address addr = bookmark.getAddress();
            if (this.listing.getInstructionAt(addr) != null || (abmark = this.curProgram.getBookmarkManager().getBookmark(addr, "Analysis", NAME)) == null || addr.subtract((beforeInstr = this.listing.getInstructionBefore(addr)).getMaxAddress()) >= 6L) continue;
            ClearFlowAndRepairCmd cmd = new ClearFlowAndRepairCmd(addr, true, false, true);
            cmd.applyTo((DomainObject)this.curProgram);
        }
        return true;
    }

    private void scheduleFollowOnAnalysis(Program program, AddressSetView doLaterSet) {
        if (!doLaterSet.isEmpty()) {
            AutoAnalysisManager mgr = AutoAnalysisManager.getAnalysisManager(program);
            mgr.scheduleOneTimeAnalysis(this, doLaterSet);
        }
    }

    private boolean doValidStart(Address entry, TaskMonitor monitor) {
        FlowType ftype;
        boolean isvalid;
        Instruction instr;
        BigInteger curValue = null;
        PseudoDisassemblerContext pseudoContext = new PseudoDisassemblerContext(this.curProgram.getProgramContext());
        curValue = this.curProgram.getProgramContext().getValue(this.tmodeReg, entry, false);
        if (curValue == null && (instr = this.listing.getInstructionBefore(entry)) != null && (curValue = this.curProgram.getProgramContext().getValue(this.tmodeReg, instr.getMinAddress(), false)) != null) {
            pseudoContext.setValue(this.tmodeReg, entry, curValue);
        }
        if (!(isvalid = this.pseudo.checkValidSubroutine(entry, pseudoContext, true, false)) && this.tmodeReg != null) {
            curValue = curValue != null ? curValue.flipBit(0) : BigInteger.ONE;
            pseudoContext = new PseudoDisassemblerContext(this.curProgram.getProgramContext());
            pseudoContext.setValue(this.tmodeReg, entry, curValue);
            isvalid = this.pseudo.checkValidSubroutine(entry, pseudoContext, true, false);
        }
        if (!isvalid) {
            return false;
        }
        this.numInstr = 0;
        this.addsInfo = false;
        Symbol sym = this.curProgram.getSymbolTable().getPrimarySymbol(entry);
        if (sym != null && sym.getSource() == SourceType.IMPORTED) {
            this.addsInfo = true;
        }
        pseudoContext = new PseudoDisassemblerContext(this.curProgram.getProgramContext());
        pseudoContext.setValue(this.tmodeReg, entry, curValue);
        AddressSet body = this.pseudo.followSubFlows(entry, pseudoContext, 1000, new PseudoFlowProcessor(){
            Object[] lastResults = null;
            Instruction lastInstr = null;
            int duplicateCount = 0;

            public boolean followFlows(PseudoInstruction instr) {
                return true;
            }

            public boolean process(PseudoInstruction instr) {
                if (instr == null) {
                    ArmAggressiveInstructionFinderAnalyzer.this.addsInfo = false;
                    return false;
                }
                if (this.lastInstr != null && this.lastInstr.equals(instr)) {
                    ++this.duplicateCount;
                    if (this.duplicateCount > 4) {
                        ArmAggressiveInstructionFinderAnalyzer.this.addsInfo = false;
                        return false;
                    }
                }
                this.lastInstr = instr;
                ++ArmAggressiveInstructionFinderAnalyzer.this.numInstr;
                FlowType ftype = instr.getFlowType();
                if (ftype.isTerminal()) {
                    return this.validTerminator(instr);
                }
                if (ftype.isComputed() && ftype.isJump()) {
                    return true;
                }
                Address[] flows = instr.getFlows();
                if (flows != null && flows.length > 0) {
                    Function func;
                    if (!ArmAggressiveInstructionFinderAnalyzer.this.curProgram.getMemory().contains(flows[0])) {
                        ArmAggressiveInstructionFinderAnalyzer.this.addsInfo = false;
                        return false;
                    }
                    if (ftype.isJump() && (func = ArmAggressiveInstructionFinderAnalyzer.this.curProgram.getFunctionManager().getFunctionAt(flows[0])) != null) {
                        ArmAggressiveInstructionFinderAnalyzer.this.addsInfo = true;
                        return false;
                    }
                    if (ftype.isCall()) {
                        func = ArmAggressiveInstructionFinderAnalyzer.this.curProgram.getFunctionManager().getFunctionAt(flows[0]);
                        if (func != null) {
                            ArmAggressiveInstructionFinderAnalyzer.this.addsInfo = true;
                            return !func.hasNoReturn();
                        }
                        if (ArmAggressiveInstructionFinderAnalyzer.this.curProgram.getListing().getInstructionAt(flows[0]) == null) {
                            ArmAggressiveInstructionFinderAnalyzer.this.addsInfo = true;
                            return true;
                        }
                    }
                }
                if (ftype.isCall() && ftype.isComputed() && this.lastResults != null && instr.getNumOperands() == 1) {
                    Register reg = instr.getRegister(0);
                    for (int i = 0; i < this.lastResults.length; ++i) {
                        if (!reg.equals(this.lastResults[i])) continue;
                        ArmAggressiveInstructionFinderAnalyzer.this.addsInfo = true;
                        return true;
                    }
                }
                this.lastResults = null;
                if (instr.getMnemonicString().startsWith("ld")) {
                    this.lastResults = instr.getResultObjects();
                }
                return true;
            }

            private boolean validTerminator(PseudoInstruction instr) {
                Object[] inObjs;
                if (instr.getMnemonicString().startsWith("ldm") && (inObjs = instr.getInputObjects()) != null) {
                    for (int i = 0; i < inObjs.length; ++i) {
                        if (!(inObjs[i] instanceof Register) || (((Register)inObjs[i]).getTypeFlags() & 2) != 0) continue;
                        return true;
                    }
                    return false;
                }
                return true;
            }
        });
        if (this.lastBody != null && this.lastBody.contains((AddressSetView)body) && this.lastBodyTheSameCount++ > 5) {
            this.todoSet = this.todoSet.subtract((AddressSetView)body);
            this.lastBody = null;
            this.lastBodyTheSameCount = 0;
        } else {
            this.lastBody = body;
        }
        if (this.numInstr <= 2 || !this.addsInfo) {
            return false;
        }
        if (body.getNumAddressRanges() > 1 && ((AddressRange)body.getAddressRanges().next()).getLength() <= 6L) {
            return false;
        }
        if (this.listing.getDefinedData((AddressSetView)body, true).hasNext()) {
            return false;
        }
        Instruction iBefore = this.listing.getInstructionBefore(entry);
        if (iBefore != null && iBefore.getMaxAddress().add(1L).equals((Object)entry) && (ftype = iBefore.getFlowType()).isComputed() && ftype.isJump() && this.curProgram.getReferenceManager().getReferenceCountTo(entry) > 0) {
            AddressSet badSet = new AddressSet(body.getMinAddress(), body.getMaxAddress());
            this.todoSet = this.todoSet.subtract((AddressSetView)badSet);
            return false;
        }
        AddressRangeIterator riter = body.getAddressRanges();
        long distance = 0L;
        Address last = null;
        while (riter.hasNext()) {
            AddressRange range = (AddressRange)riter.next();
            if (last != null) {
                distance += Math.abs(last.subtract(range.getMinAddress()));
            }
            last = range.getMaxAddress();
            if (range.getMinAddress().subtract(entry) < 0L) {
                distance = 0x777777L;
                break;
            }
            if (range.getLength() > 4L) continue;
            distance = 0x777777L;
            break;
        }
        if (distance > 4096L) {
            return false;
        }
        if (this.curProgram.getListing().getFunctions((AddressSetView)body, true).hasNext()) {
            return false;
        }
        monitor.setMessage("ARM AIF : " + entry);
        if (isvalid) {
            try {
                this.curProgram.getProgramContext().setValue(this.tmodeReg, entry, entry, curValue);
            }
            catch (ContextChangeException e) {
                Msg.error((Object)this, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
                return false;
            }
            DisassembleCommand cmd = new DisassembleCommand(entry, null, true);
            int beforeErrorCount = this.curProgram.getBookmarkManager().getBookmarkCount("Error");
            cmd.applyTo((DomainObject)this.curProgram);
            int afterErrorCount = this.curProgram.getBookmarkManager().getBookmarkCount("Error");
            if (beforeErrorCount < afterErrorCount) {
                ClearFlowAndRepairCmd clearCmd = new ClearFlowAndRepairCmd(entry, true, false, false);
                clearCmd.applyTo((DomainObject)this.curProgram);
                return false;
            }
            this.todoSet = this.todoSet.subtract((AddressSetView)cmd.getDisassembledAddressSet());
            BookmarkEditCmd bcmd = new BookmarkEditCmd(entry, "Analysis", "ARM Aggressive Intruction Finder", "Found code");
            bcmd.applyTo((DomainObject)this.curProgram);
            return true;
        }
        return false;
    }

    private AddressSetView checkExecBlocks(Program program, AddressSetView set) {
        AddressSet execSet = new AddressSet();
        MemoryBlock[] blocks = program.getMemory().getBlocks();
        for (int i = 0; i < blocks.length; ++i) {
            if (!blocks[i].isExecute()) continue;
            execSet.addRange(blocks[i].getStart(), blocks[i].getEnd());
        }
        if (execSet.isEmpty()) {
            return set;
        }
        if (set.isEmpty()) {
            return execSet;
        }
        return set.intersect((AddressSetView)execSet);
    }
}

