/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.script;

import generic.jar.ResourceFile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.JavaFileObject;

public class ResourceFileJavaFileObject
implements JavaFileObject {
    private ResourceFile file;
    private String pathName;
    private JavaFileObject.Kind kind;

    public ResourceFileJavaFileObject(ResourceFile sourceRoot, ResourceFile file, JavaFileObject.Kind kind) {
        this.file = file;
        this.kind = kind;
        String sourceRootPath = sourceRoot.getAbsolutePath();
        this.pathName = file.getAbsolutePath().substring(sourceRootPath.length() + 1);
    }

    @Override
    public URI toUri() {
        return this.file.toURI();
    }

    @Override
    public String getName() {
        return this.pathName;
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return this.file.getInputStream();
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
        return new InputStreamReader(this.file.getInputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        Reader openReader = this.openReader(true);
        try (BufferedReader in = new BufferedReader(openReader);){
            String line;
            StringBuffer buffy = new StringBuffer();
            while ((line = in.readLine()) != null) {
                buffy.append(line);
                buffy.append("\n");
            }
            StringBuffer stringBuffer = buffy;
            return stringBuffer;
        }
    }

    @Override
    public Writer openWriter() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    public boolean delete() {
        throw new UnsupportedOperationException();
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return this.kind;
    }

    @Override
    public boolean isNameCompatible(String compatibleName, JavaFileObject.Kind testKind) {
        if (compatibleName == null) {
            throw new NullPointerException("simpleName cannot be null");
        }
        if (this.kind != testKind && testKind == JavaFileObject.Kind.OTHER) {
            return false;
        }
        String testName = compatibleName + testKind.extension;
        String myName = this.file.getName();
        if (myName.equals(testName)) {
            return true;
        }
        if (myName.equalsIgnoreCase(testName)) {
            ResourceFile canonicalFile = this.file.getCanonicalFile();
            String myCanonicalName = canonicalFile.getName();
            return myCanonicalName.equals(testName);
        }
        return false;
    }

    @Override
    public NestingKind getNestingKind() {
        return null;
    }

    @Override
    public Modifier getAccessLevel() {
        return null;
    }

    public String toString() {
        return this.file.getName();
    }
}

