/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.encoding;

import java.util.HashMap;
import java.util.Map;

public enum DWARFAccessibility {
    DW_ACCESS_public(1),
    DW_ACCESS_protected(2),
    DW_ACCESS_private(3);

    private final int value;
    private static final Map<Integer, DWARFAccessibility> valueMap;

    private DWARFAccessibility(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static DWARFAccessibility find(Number key) {
        DWARFAccessibility access = valueMap.get(key.intValue());
        if (access != null) {
            return access;
        }
        throw new IllegalArgumentException("Invalid Integer value: " + key.toString());
    }

    static {
        valueMap = new HashMap<Integer, DWARFAccessibility>();
        for (DWARFAccessibility access : DWARFAccessibility.values()) {
            valueMap.put(access.getValue(), access);
        }
    }
}

