/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf4.next.sectionprovider;

import ghidra.app.util.bin.format.dwarf4.next.sectionprovider.BaseSectionProvider;
import ghidra.app.util.bin.format.dwarf4.next.sectionprovider.DSymSectionProvider;
import ghidra.app.util.bin.format.dwarf4.next.sectionprovider.DWARFSectionNames;
import ghidra.app.util.bin.format.dwarf4.next.sectionprovider.DWARFSectionProvider;
import ghidra.app.util.bin.format.dwarf4.next.sectionprovider.ElfSectionProvider;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class DWARFSectionProviderFactory {
    private static final List<Function<Program, DWARFSectionProvider>> sectionProviderFactoryFuncs = new ArrayList<Function<Program, DWARFSectionProvider>>();

    public static DWARFSectionProvider createSectionProviderFor(Program program) {
        for (Function<Program, DWARFSectionProvider> factoryFunc : sectionProviderFactoryFuncs) {
            DWARFSectionProvider sp = factoryFunc.apply(program);
            if (sp == null) continue;
            try {
                if (sp.hasSection(DWARFSectionNames.MINIMAL_DWARF_SECTIONS)) {
                    return sp;
                }
            }
            catch (Exception e) {
                Msg.warn(DWARFSectionProviderFactory.class, (Object)"Problem detecting DWARFSectionProvider", (Throwable)e);
            }
            sp.close();
        }
        return null;
    }

    static {
        sectionProviderFactoryFuncs.add(BaseSectionProvider::createSectionProviderFor);
        sectionProviderFactoryFuncs.add(DSymSectionProvider::createSectionProviderFor);
        sectionProviderFactoryFuncs.add(ElfSectionProvider::createSectionProviderFor);
    }
}

