/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.bin.format.elf.ElfHeader;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfRelocationTable;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.extend.ElfLoadAdapter;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandlerFactory;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.NotEmptyException;
import ghidra.util.exception.NotFoundException;
import java.util.Map;

public class ElfRelocationContext {
    protected final ElfRelocationHandler handler;
    protected final ElfLoadHelper loadHelper;
    protected final ElfRelocationTable relocationTable;
    protected final ElfSymbol[] symbols;
    protected final Map<ElfSymbol, Address> symbolMap;
    protected final Program program;

    protected ElfRelocationContext(ElfRelocationHandler handler, ElfLoadHelper loadHelper, ElfRelocationTable relocationTable, Map<ElfSymbol, Address> symbolMap) {
        this.handler = handler;
        this.loadHelper = loadHelper;
        this.relocationTable = relocationTable;
        this.symbols = relocationTable.getAssociatedSymbolTable().getSymbols();
        this.symbolMap = symbolMap;
        this.program = loadHelper.getProgram();
    }

    public final void processRelocation(ElfRelocation relocation, Address relocationAddress) {
        if (this.handler == null) {
            this.handleNoHandlerError(relocation, relocationAddress);
            return;
        }
        long symbolIndex = relocation.getSymbolIndex();
        if (symbolIndex < 0L || symbolIndex >= (long)this.symbols.length) {
            ElfRelocationHandler.markAsUnhandled(this.program, relocationAddress, relocation.getType(), symbolIndex, "index " + Long.toString(symbolIndex), this.getLog());
            return;
        }
        ElfSymbol sym = this.symbols[(int)symbolIndex];
        if (sym.isTLS()) {
            this.handleUnsupportedTLSRelocation(relocation, relocationAddress);
            return;
        }
        try {
            this.handler.relocate(this, relocation, relocationAddress);
        }
        catch (MemoryAccessException | NotFoundException e) {
            this.loadHelper.log(e);
            ElfRelocationHandler.markAsUnhandled(this.program, relocationAddress, relocation.getType(), symbolIndex, sym.getNameAsString(), this.getLog());
        }
    }

    private void handleUnsupportedTLSRelocation(ElfRelocation relocation, Address relocationAddress) {
        long symbolIndex = relocation.getSymbolIndex();
        ElfSymbol sym = this.symbols[(int)symbolIndex];
        ElfRelocationHandler.markAsError(this.program, relocationAddress, relocation.getType(), sym.getNameAsString(), "TLS symbol relocation not yet supported", this.getLog());
    }

    private void handleNoHandlerError(ElfRelocation relocation, Address relocationAddress) {
        String symName = this.symbols[relocation.getSymbolIndex()].getNameAsString();
        this.program.getBookmarkManager().setBookmark(relocationAddress, "Error", "Relocation", "No handler to process ELF Relocation to : " + symName);
        this.loadHelper.log("WARNING: At " + relocationAddress + " no handler to process ELF Relocations to " + symName);
    }

    public static ElfRelocationContext getRelocationContext(ElfLoadHelper loadHelper, ElfRelocationTable relocationTable, Map<ElfSymbol, Address> symbolMap) {
        ElfHeader elf = loadHelper.getElfHeader();
        ElfRelocationContext context = null;
        ElfRelocationHandler handler = ElfRelocationHandlerFactory.getHandler(elf);
        if (handler != null) {
            context = handler.createRelocationContext(loadHelper, relocationTable, symbolMap);
        }
        if (context == null) {
            context = new ElfRelocationContext(handler, loadHelper, relocationTable, symbolMap);
        }
        return context;
    }

    public final boolean hasRelocationHandler() {
        return this.handler != null;
    }

    public long getImageBaseWordAdjustmentOffset() {
        return this.loadHelper.getImageBaseWordAdjustmentOffset();
    }

    public boolean extractAddend() {
        return !this.relocationTable.hasAddendRelocations();
    }

    public final Program getProgram() {
        return this.program;
    }

    public final boolean isBigEndian() {
        return this.program.getMemory().isBigEndian();
    }

    public final ElfHeader getElfHeader() {
        return this.loadHelper.getElfHeader();
    }

    public final ElfLoadHelper getLoadHelper() {
        return this.loadHelper;
    }

    public final ElfLoadAdapter getLoadAdapter() {
        return this.getElfHeader().getLoadAdapter();
    }

    public final MessageLog getLog() {
        return this.loadHelper.getLog();
    }

    public final ElfSymbol getSymbol(int symbolIndex) {
        return this.symbols[symbolIndex];
    }

    public Address getSymbolAddress(ElfSymbol symbol) {
        return this.symbolMap.get(symbol);
    }

    public long getSymbolValue(ElfSymbol symbol) {
        Address symAddr = this.symbolMap.get(symbol);
        return symAddr != null ? symAddr.getAddressableWordOffset() : 0L;
    }

    public long getGOTValue() throws NotFoundException {
        Long gotValue = this.loadHelper.getGOTValue();
        if (gotValue == null) {
            throw new NotFoundException("Failed to identify _GLOBAL_OFFSET_TABLE_");
        }
        return gotValue;
    }

    public void dispose() {
        Listing listing = this.program.getListing();
        try {
            String extendedBlockName = "EXTERNAL.ext";
            ProgramFragment extendedFragment = listing.getFragment("Program Tree", extendedBlockName);
            if (extendedFragment != null) {
                ProgramFragment externalFragment = listing.getFragment("Program Tree", "EXTERNAL");
                if (externalFragment == null) {
                    extendedFragment.setName("EXTERNAL");
                } else {
                    externalFragment.move(extendedFragment.getMinAddress(), extendedFragment.getMaxAddress());
                    externalFragment.getParents()[0].removeChild(extendedBlockName);
                }
            }
        }
        catch (DuplicateNameException | NotEmptyException | NotFoundException e) {
            Msg.error((Object)this, (Object)"Failed to reconcile extended EXTERNAL block fragment");
        }
    }
}

