/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfComdefRecord;
import ghidra.app.util.bin.format.omf.OmfCommentRecord;
import ghidra.app.util.bin.format.omf.OmfEnumeratedData;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.OmfExternalSymbol;
import ghidra.app.util.bin.format.omf.OmfFileHeader;
import ghidra.app.util.bin.format.omf.OmfFixupRecord;
import ghidra.app.util.bin.format.omf.OmfGroupRecord;
import ghidra.app.util.bin.format.omf.OmfIteratedData;
import ghidra.app.util.bin.format.omf.OmfLineNumberRecord;
import ghidra.app.util.bin.format.omf.OmfModuleEnd;
import ghidra.app.util.bin.format.omf.OmfNamesRecord;
import ghidra.app.util.bin.format.omf.OmfSegmentHeader;
import ghidra.app.util.bin.format.omf.OmfSymbolRecord;
import java.io.IOException;

public abstract class OmfRecord {
    public static final byte THEADR = -128;
    public static final byte LHEADR = -126;
    public static final byte COMENT = -120;
    public static final byte MODEND = -118;
    public static final byte EXTDEF = -116;
    public static final byte PUBDEF = -112;
    public static final byte LINNUM = -108;
    public static final byte LNAMES = -106;
    public static final byte SEGDEF = -104;
    public static final byte GRPDEF = -102;
    public static final byte FIXUPP = -100;
    public static final byte LEDATA = -96;
    public static final byte LIDATA = -94;
    public static final byte COMDEF = -80;
    public static final byte LEXTDEF = -76;
    public static final byte LPUBDEF = -74;
    public static final byte LCOMDEF = -72;
    protected byte recordType;
    protected int recordLength;
    protected byte checkSum;

    public byte getRecordType() {
        return this.recordType;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public void readRecordHeader(BinaryReader reader) throws IOException {
        this.recordType = reader.readNextByte();
        this.recordLength = reader.readNextShort() & 0xFFFF;
    }

    public void readCheckSumByte(BinaryReader reader) throws IOException {
        this.checkSum = reader.readNextByte();
    }

    public byte calcCheckSum(BinaryReader reader) throws IOException {
        byte res = reader.readNextByte();
        res = (byte)(res + reader.readNextByte());
        res = (byte)(res + reader.readNextByte());
        for (int i = 0; i < this.recordLength; ++i) {
            res = (byte)(res + reader.readNextByte());
        }
        return res;
    }

    public boolean validCheckSum(BinaryReader reader) throws IOException {
        if (this.checkSum == 0) {
            return true;
        }
        return this.calcCheckSum(reader) == 0;
    }

    public boolean hasBigFields() {
        return (this.recordType & 1) != 0;
    }

    public static int readInt1Or2(BinaryReader reader, boolean isBig) throws IOException {
        if (isBig) {
            return reader.readNextShort() & 0xFFFF;
        }
        return reader.readNextByte() & 0xFF;
    }

    public static int readInt2Or4(BinaryReader reader, boolean isBig) throws IOException {
        if (isBig) {
            return reader.readNextInt();
        }
        return reader.readNextShort() & 0xFFFF;
    }

    public static int readIndex(BinaryReader reader) throws IOException {
        int firstByte = reader.readNextByte();
        int indexWord = (firstByte & 0x80) != 0 ? (firstByte & 0x7F) * 256 + (reader.readNextByte() & 0xFF) : firstByte;
        return indexWord;
    }

    public static OmfRecord readRecord(BinaryReader reader) throws IOException, OmfException {
        OmfRecord res = null;
        byte type = reader.peekNextByte();
        type = (byte)(type & 0xFE);
        switch (type) {
            case -128: 
            case -126: {
                res = new OmfFileHeader(reader);
                break;
            }
            case -120: {
                res = new OmfCommentRecord(reader);
                break;
            }
            case -118: {
                res = new OmfModuleEnd(reader);
                break;
            }
            case -116: {
                res = new OmfExternalSymbol(reader, false);
                break;
            }
            case -112: {
                res = new OmfSymbolRecord(reader, false);
                break;
            }
            case -108: {
                res = new OmfLineNumberRecord(reader);
                break;
            }
            case -106: {
                res = new OmfNamesRecord(reader);
                break;
            }
            case -104: {
                res = new OmfSegmentHeader(reader);
                break;
            }
            case -102: {
                res = new OmfGroupRecord(reader);
                break;
            }
            case -100: {
                res = new OmfFixupRecord(reader);
                break;
            }
            case -96: {
                res = new OmfEnumeratedData(reader);
                break;
            }
            case -94: {
                res = new OmfIteratedData(reader);
                break;
            }
            case -80: {
                res = new OmfComdefRecord(reader, false);
                break;
            }
            case -76: {
                res = new OmfExternalSymbol(reader, true);
                break;
            }
            case -74: {
                res = new OmfSymbolRecord(reader, true);
                break;
            }
            case -72: {
                res = new OmfComdefRecord(reader, true);
                break;
            }
            default: {
                throw new OmfException("Unrecognized record type");
            }
        }
        return res;
    }

    public static String readString(BinaryReader reader) throws IOException {
        int count = reader.readNextByte() & 0xFF;
        return reader.readNextAsciiString(count);
    }
}

