/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class TLSDirectory
implements StructConverter {
    private boolean is64bit;
    private long startAddressOfRawData;
    private long endAddressOfRawData;
    private long addressOfIndex;
    private long addressOfCallBacks;
    private int sizeOfZeroFill;
    private int characteristics;

    static TLSDirectory createTLSDirectory(FactoryBundledWithBinaryReader reader, int index, boolean is64bit) throws IOException {
        TLSDirectory tlsDirectory = (TLSDirectory)reader.getFactory().create(TLSDirectory.class, new Object[0]);
        tlsDirectory.initTLSDirectory(reader, index, is64bit);
        return tlsDirectory;
    }

    private void initTLSDirectory(FactoryBundledWithBinaryReader reader, int index, boolean is64bit) throws IOException {
        this.is64bit = is64bit;
        if (is64bit) {
            this.startAddressOfRawData = reader.readLong(index);
            this.endAddressOfRawData = reader.readLong(index += 8);
            this.addressOfIndex = reader.readLong(index += 8);
            this.addressOfCallBacks = reader.readLong(index += 8);
            index += 8;
        } else {
            this.startAddressOfRawData = (long)reader.readInt(index) & 0xFFFFFFFFL;
            this.endAddressOfRawData = (long)reader.readInt(index += 4) & 0xFFFFFFFFL;
            this.addressOfIndex = (long)reader.readInt(index += 4) & 0xFFFFFFFFL;
            this.addressOfCallBacks = (long)reader.readInt(index += 4) & 0xFFFFFFFFL;
            index += 4;
        }
        Msg.info((Object)this, (Object)("TLS callbacks at " + Long.toHexString(this.addressOfCallBacks)));
        this.sizeOfZeroFill = reader.readInt(index);
        this.characteristics = reader.readInt(index += 4);
        index += 4;
    }

    public long getStartAddressOfRawData() {
        return this.startAddressOfRawData;
    }

    public long getEndAddressOfRawData() {
        return this.endAddressOfRawData;
    }

    public long getAddressOfIndex() {
        return this.addressOfIndex;
    }

    public long getAddressOfCallBacks() {
        return this.addressOfCallBacks;
    }

    public int getSizeOfZeroFill() {
        return this.sizeOfZeroFill;
    }

    public int getCharacteristics() {
        return this.characteristics;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(this.getName(), 0);
        DataType dt = this.is64bit ? QWORD : DWORD;
        struct.add(dt, "StartAddressOfRawData", null);
        struct.add(dt, "EndAddressOfRawData", null);
        struct.add(dt, "AddressOfIndex", null);
        struct.add(dt, "AddressOfCallBacks", null);
        struct.add(DWORD, "SizeOfZeroFill", null);
        struct.add(DWORD, "Characteristics", null);
        struct.setCategoryPath(new CategoryPath("/PE"));
        return struct;
    }

    public String getName() {
        return "IMAGE_THUNK_DATA" + (this.is64bit ? "64" : "32");
    }
}

