/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.cli.blobs.CliBlob;
import ghidra.app.util.bin.format.pe.cli.blobs.CliSigField;
import ghidra.app.util.bin.format.pe.cli.streams.CliAbstractStream;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTableTypeDef;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.app.util.bin.format.pe.cli.tables.flags.CliFlags;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class CliTableField
extends CliAbstractTable {
    public CliTableField(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        CliTableTypeDef typeDefTable = (CliTableTypeDef)this.metadataStream.getTable(CliTypeTable.TypeDef);
        for (int i = 0; i < this.numRows; ++i) {
            CliFieldRow row = new CliFieldRow(reader.readNextShort(), this.readStringIndex(reader), this.readBlobIndex(reader));
            this.rows.add(row);
            this.strings.add(row.nameIndex);
            row.typeDefOwnerIndex = typeDefTable.getOwnerOfFieldIndex(i);
        }
        reader.setPointerIndex(this.readerOffset);
    }

    @Override
    public void markup(Program program, boolean isBinary, TaskMonitor monitor, MessageLog log, NTHeader ntHeader) throws DuplicateNameException, CodeUnitInsertionException, IOException {
        for (CliAbstractTableRow row : this.rows) {
            CliFieldRow fieldRow = (CliFieldRow)row;
            Address sigAddr = CliAbstractStream.getStreamMarkupAddress(program, isBinary, monitor, log, ntHeader, this.metadataStream.getBlobStream(), fieldRow.sigIndex);
            CliSigField fieldSig = new CliSigField(this.metadataStream.getBlobStream().getBlob(fieldRow.sigIndex));
            this.metadataStream.getBlobStream().updateBlob(fieldSig, sigAddr, program);
        }
    }

    public StructureDataType getRowDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "Field Row", 0);
        rowDt.add((DataType)CliFlags.CliEnumFieldAttributes.dataType, "Flags", "see CorFieldAttr");
        rowDt.add(this.metadataStream.getStringIndexDataType(), "Name", "index into String heap");
        rowDt.add(this.metadataStream.getBlobIndexDataType(), "Signature", "index into Blob heap");
        return rowDt;
    }

    public class CliFieldRow
    extends CliAbstractTableRow {
        public short flags;
        public int nameIndex;
        public int sigIndex;
        public static final int TYPEDEF_OWNER_INIT_VALUE = -1;
        public int typeDefOwnerIndex = -1;

        public CliFieldRow(short flags, int nameIndex, int sigIndex) {
            this.flags = flags;
            this.nameIndex = nameIndex;
            this.sigIndex = sigIndex;
        }

        @Override
        public String getRepresentation() {
            String sigRep = Integer.toHexString(this.sigIndex);
            CliBlob sigBlob = CliTableField.this.metadataStream.getBlobStream().getBlob(this.sigIndex);
            try {
                CliSigField fieldSig = new CliSigField(sigBlob);
                sigRep = fieldSig.getShortRepresentation(CliTableField.this.metadataStream);
            }
            catch (IOException fieldSig) {
                // empty catch block
            }
            Object ownerRep = this.typeDefOwnerIndex == -1 ? "" : CliTableField.this.getRowShortRepSafe(CliTypeTable.TypeDef, this.typeDefOwnerIndex) + "::";
            return String.format("%s %s%s Flags %s", sigRep, ownerRep, CliTableField.this.metadataStream.getStringsStream().getString(this.nameIndex), CliFlags.CliEnumFieldAttributes.dataType.getName(this.flags & 0xFFFF));
        }
    }
}

