/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.tables;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.MemoryByteProvider;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.PeUtils;
import ghidra.app.util.bin.format.pe.cli.blobs.CliBlob;
import ghidra.app.util.bin.format.pe.cli.blobs.CliSigMethodDef;
import ghidra.app.util.bin.format.pe.cli.methods.CliMethodDef;
import ghidra.app.util.bin.format.pe.cli.methods.CliMethodExtraSections;
import ghidra.app.util.bin.format.pe.cli.streams.CliAbstractStream;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.bin.format.pe.cli.tables.CliTypeTable;
import ghidra.app.util.bin.format.pe.cli.tables.flags.CliFlags;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class CliTableMethodDef
extends CliAbstractTable {
    public CliTableMethodDef(BinaryReader reader, CliStreamMetadata stream, CliTypeTable tableId) throws IOException {
        super(reader, stream, tableId);
        CliMethodDefRow lastRow = null;
        for (int i = 0; i < this.numRows; ++i) {
            CliMethodDefRow row = new CliMethodDefRow(reader.readNextInt(), reader.readNextShort(), reader.readNextShort(), this.readStringIndex(reader), this.readBlobIndex(reader), this.readTableIndex(reader, CliTypeTable.Param));
            this.rows.add(row);
            this.strings.add(row.nameIndex);
            if (lastRow != null) {
                lastRow.nextRowParamIndex = row.paramIndex;
            }
            lastRow = row;
        }
        reader.setPointerIndex(this.readerOffset);
    }

    @Override
    public void markup(Program program, boolean isBinary, TaskMonitor monitor, MessageLog log, NTHeader ntHeader) throws DuplicateNameException, CodeUnitInsertionException, IOException {
        int rvaZero = 0;
        for (CliAbstractTableRow methodRow : this.rows) {
            CliMethodDefRow method = (CliMethodDefRow)methodRow;
            if (method.RVA == 0) {
                ++rvaZero;
                continue;
            }
            Address addr = PeUtils.getMarkupAddress(program, isBinary, ntHeader, method.RVA);
            BinaryReader reader = new BinaryReader(new MemoryByteProvider(program.getMemory(), addr), !program.getMemory().isBigEndian());
            CliMethodDef methodDef = new CliMethodDef(addr, reader);
            PeUtils.createData(program, addr, methodDef.toDataType(), log);
            Address startAddr = addr.add((long)methodDef.toDataType().getLength());
            Address endAddr = startAddr.add((long)(methodDef.getMethodSize() - 1));
            AddressSet funcAddrSet = new AddressSet(startAddr, endAddr);
            Object funcName = "func_" + method.RVA;
            try {
                if (method.nameIndex != 0) {
                    Address nameAddr = CliAbstractStream.getStreamMarkupAddress(program, isBinary, monitor, log, ntHeader, this.metadataStream.getStringsStream(), method.nameIndex);
                    BinaryReader strReader = new BinaryReader(new MemoryByteProvider(program.getMemory(), nameAddr), !program.getMemory().isBigEndian());
                    funcName = strReader.readNextAsciiString();
                    funcName = (String)funcName + "-" + method.sigIndex + "-" + method.RVA;
                    if (program.getFunctionManager().getFunctionAt(startAddr) == null) {
                        program.getFunctionManager().createFunction((String)funcName, startAddr, (AddressSetView)funcAddrSet, SourceType.ANALYSIS);
                    }
                }
            }
            catch (InvalidInputException e) {
                e.printStackTrace();
            }
            catch (OverlappingFunctionException e) {
                e.printStackTrace();
            }
            if (methodDef.hasMoreSections()) {
                int extraOffset = methodDef.toDataType().getLength() + methodDef.getMethodSize();
                while (extraOffset % 4 != 0) {
                    ++extraOffset;
                }
                reader.setPointerIndex(extraOffset);
                CliMethodExtraSections extras = new CliMethodExtraSections(reader);
                Address extraAddr = addr.add((long)extraOffset);
                PeUtils.createData(program, extraAddr, extras.toDataType(), log);
            }
            CliBlob blob = this.metadataStream.getBlobStream().getBlob(method.sigIndex);
            Address sigAddr = CliAbstractStream.getStreamMarkupAddress(program, isBinary, monitor, log, ntHeader, this.metadataStream.getBlobStream(), method.sigIndex);
            CliSigMethodDef methodSig = new CliSigMethodDef(blob);
            this.metadataStream.getBlobStream().updateBlob(methodSig, sigAddr, program);
            Function func = program.getFunctionManager().getFunctionAt(startAddr);
            try {
                if (func == null || methodSig.getReturnType() == null) continue;
                func.setReturnType(methodSig.getReturnType().getExecutionDataType(), SourceType.ANALYSIS);
            }
            catch (InvalidInputException e) {
                e.printStackTrace();
            }
        }
        if (rvaZero > 0) {
            Msg.warn((Object)this, (Object)(rvaZero + " methods with RVA 0"));
        }
    }

    public StructureDataType getRowDataType() {
        StructureDataType rowDt = new StructureDataType(new CategoryPath("/PE/CLI/Metadata/Tables"), "MethodDef Row", 0);
        rowDt.add(DWORD, "RVA", null);
        rowDt.add((DataType)CliFlags.CliEnumMethodImplAttributes.dataType, "ImplFlags", "Bitmask of type MethodImplAttributes");
        rowDt.add((DataType)CliFlags.CliEnumMethodAttributes.dataType, "Flags", "Bitmask of type MethodAttribute");
        rowDt.add(this.metadataStream.getStringIndexDataType(), "Name", "index into String heap");
        rowDt.add(this.metadataStream.getBlobIndexDataType(), "Signature", "index into Blob heap");
        rowDt.add(this.metadataStream.getTableIndexDataType(CliTypeTable.Param), "ParamList", "index into Param table");
        return rowDt;
    }

    private String commaifyList(List<?> list) {
        Object commaSeparated = "";
        for (Object item : list) {
            commaSeparated = (String)commaSeparated + item + ", ";
        }
        if (list.size() > 0) {
            commaSeparated = ((String)commaSeparated).substring(0, ((String)commaSeparated).length() - 2);
        }
        return commaSeparated;
    }

    public class CliMethodDefRow
    extends CliAbstractTableRow {
        public int RVA;
        public short ImplFlags;
        public short Flags;
        public int nameIndex;
        public int sigIndex;
        private int paramIndex;
        public static final int NEXT_ROW_PARAM_INIT_VALUE = -1;
        public int nextRowParamIndex = -1;

        public CliMethodDefRow(int rva, short implFlags, short flags, int nameIndex, int sigIndex, int paramIndex) {
            this.RVA = rva;
            this.ImplFlags = implFlags;
            this.Flags = flags;
            this.nameIndex = nameIndex;
            this.sigIndex = sigIndex;
            this.paramIndex = paramIndex;
            this.nextRowParamIndex = -1;
        }

        @Override
        public String getRepresentation() {
            String paramsStr;
            String methodRep = "error retrieving method representation";
            CliBlob blob = CliTableMethodDef.this.metadataStream.getBlobStream().getBlob(this.sigIndex);
            try {
                CliSigMethodDef methodSig = new CliSigMethodDef(blob);
                methodRep = methodSig.getRepresentation();
            }
            catch (IOException methodSig) {
                // empty catch block
            }
            if (this.nextRowParamIndex == -1) {
                this.nextRowParamIndex = CliTableMethodDef.this.metadataStream.getTable(CliTypeTable.Param).getNumRows() + 1;
            }
            if (this.nextRowParamIndex == this.paramIndex) {
                paramsStr = "";
            } else {
                String[] params = new String[this.nextRowParamIndex - this.paramIndex];
                for (int i = 0; i < params.length; ++i) {
                    params[i] = CliTableMethodDef.this.getRowRepresentationSafe(CliTypeTable.Param, this.paramIndex + i);
                }
                paramsStr = CliTableMethodDef.this.commaifyList(Arrays.asList(params));
            }
            return String.format("%s %s Params: %s [RVA %x] Impl: %s Attr: %s", CliTableMethodDef.this.metadataStream.getStringsStream().getString(this.nameIndex), methodRep, paramsStr, this.RVA, CliFlags.CliEnumMethodImplAttributes.dataType.getName(this.ImplFlags & 0xFFFF), CliFlags.CliEnumMethodAttributes.dataType.getName(this.Flags & 0xFFFF));
        }

        @Override
        public String getRepresentation(CliStreamMetadata stream) {
            String paramsStr;
            String methodRep = "error retrieving method representation";
            CliBlob blob = stream.getBlobStream().getBlob(this.sigIndex);
            try {
                CliSigMethodDef methodSig = new CliSigMethodDef(blob);
                methodRep = methodSig.getRepresentation(stream);
            }
            catch (IOException methodSig) {
                // empty catch block
            }
            if (this.nextRowParamIndex == -1) {
                this.nextRowParamIndex = CliTableMethodDef.this.metadataStream.getTable(CliTypeTable.Param).getNumRows() + 1;
            }
            if (this.nextRowParamIndex == this.paramIndex) {
                paramsStr = "";
            } else {
                String[] params = new String[this.nextRowParamIndex - this.paramIndex];
                for (int i = 0; i < params.length; ++i) {
                    params[i] = CliTableMethodDef.this.getRowShortRepSafe(CliTypeTable.Param, this.paramIndex + i);
                }
                paramsStr = CliTableMethodDef.this.commaifyList(Arrays.asList(params));
            }
            return String.format("%s %s Params: %s [RVA %x] Impl: %s Attr: %s", stream.getStringsStream().getString(this.nameIndex), methodRep, paramsStr, this.RVA, CliFlags.CliEnumMethodImplAttributes.dataType.getName(this.ImplFlags & 0xFFFF), CliFlags.CliEnumMethodAttributes.dataType.getName(this.Flags & 0xFFFF));
        }
    }
}

