/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler;

import ghidra.app.util.demangler.DemangledTemplate;
import ghidra.app.util.demangler.DemangledType;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.BooleanDataType;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.DWordDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DoubleDataType;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.model.data.FloatDataType;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.LongDataType;
import ghidra.program.model.data.LongDoubleDataType;
import ghidra.program.model.data.LongLongDataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.ShortDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.data.Union;
import ghidra.program.model.data.UnionDataType;
import ghidra.program.model.data.UnsignedCharDataType;
import ghidra.program.model.data.UnsignedIntegerDataType;
import ghidra.program.model.data.UnsignedLongDataType;
import ghidra.program.model.data.UnsignedLongLongDataType;
import ghidra.program.model.data.UnsignedShortDataType;
import ghidra.program.model.data.VoidDataType;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import util.demangler.GenericDemangledDataType;
import util.demangler.GenericDemangledTemplate;
import util.demangler.GenericDemangledType;

public class DemangledDataType
extends DemangledType {
    private static final Pattern ARRAY_SUBSCRIPT_PATTERN = Pattern.compile("\\[\\d*\\]");
    public static final char SPACE = ' ';
    public static final String UNSIGNED = "unsigned";
    public static final String SIGNED = "signed";
    public static final String ARR_NOTATION = "[]";
    public static final String REF_NOTATION = "&";
    public static final String PTR_NOTATION = "*";
    public static final String VOLATILE = "volatile";
    public static final String COMPLEX = "complex";
    public static final String CLASS = "class";
    public static final String ENUM = "enum";
    public static final String STRUCT = "struct";
    public static final String UNION = "union";
    public static final String CONST = "const";
    public static final String COCLASS = "coclass";
    public static final String COINTERFACE = "cointerface";
    public static final String VARARGS = "...";
    public static final String VOID = "void";
    public static final String BOOL = "bool";
    public static final String CHAR = "char";
    public static final String WCHAR_T = "wchar_t";
    public static final String SHORT = "short";
    public static final String INT = "int";
    public static final String INT0_T = "int0_t";
    public static final String LONG = "long";
    public static final String LONG_LONG = "long long";
    public static final String FLOAT = "float";
    public static final String DOUBLE = "double";
    public static final String INT8 = "__int8";
    public static final String INT16 = "__int16";
    public static final String INT32 = "__int32";
    public static final String INT64 = "__int64";
    public static final String INT128 = "__int128";
    public static final String FLOAT128 = "__float128";
    public static final String LONG_DOUBLE = "long double";
    public static final String PTR64 = "__ptr64";
    public static final String STRING = "string";
    public static final String UNDEFINED = "undefined";
    public static final String UNALIGNED = "__unaligned";
    public static final String RESTRICT = "__restrict";
    public static final String[] PRIMITIVES = new String[]{"void", "bool", "char", "wchar_t", "short", "int", "int0_t", "long", "long long", "float", "double", "__int128", "__float128", "long double"};
    private int arrayDimensions = 0;
    private boolean isClass;
    private boolean isComplex;
    private boolean isEnum;
    private boolean isPointer64;
    private boolean isReference;
    private boolean isSigned;
    private boolean isStruct;
    private boolean isTemplate;
    private boolean isUnaligned;
    private boolean isUnion;
    private boolean isUnsigned;
    private boolean isVarArgs;
    private int pointerLevels = 0;
    private String enumType;
    private boolean isRestrict;
    private String basedName;
    private String memberScope;
    private boolean isCoclass;
    private boolean isCointerface;

    public DemangledDataType(String name) {
        super(name);
    }

    DemangledDataType(GenericDemangledDataType source) {
        super((GenericDemangledType)source);
        GenericDemangledTemplate otherTemplate;
        if (source.isArray()) {
            this.arrayDimensions = 1;
        }
        this.isClass = source.isClass();
        this.isComplex = source.isComplex();
        this.isEnum = source.isEnum();
        this.isPointer64 = source.isPointer64();
        this.isReference = source.isReference();
        this.isSigned = source.isSigned();
        this.isStruct = source.isStruct();
        this.isTemplate = source.isTemplate();
        this.isUnaligned = source.isUnaligned();
        this.isUnion = source.isUnion();
        this.isUnsigned = source.isUnsigned();
        this.isVarArgs = source.isVarArgs();
        this.pointerLevels = source.getPointerLevels();
        this.isRestrict = source.isRestrict();
        this.basedName = source.getBasedName();
        this.memberScope = source.getMemberScope();
        this.isCoclass = source.isCoclass();
        this.isCointerface = source.isCointerface();
        GenericDemangledType otherNamespace = source.getNamespace();
        if (otherNamespace != null) {
            this.namespace = DemangledType.convertToNamespace(source.getNamespace());
        }
        if ((otherTemplate = source.getTemplate()) != null) {
            this.template = new DemangledTemplate(otherTemplate);
        }
        if (source.isConst()) {
            this.setConst();
        }
    }

    public DemangledDataType copy() {
        DemangledDataType copy = new DemangledDataType(this.getName());
        this.copy(this, copy);
        return copy;
    }

    protected void copy(DemangledDataType source, DemangledDataType destination) {
        destination.arrayDimensions = source.arrayDimensions;
        destination.isClass = source.isClass;
        destination.isComplex = source.isComplex;
        destination.isEnum = source.isEnum;
        destination.isPointer64 = source.isPointer64;
        destination.isReference = source.isReference;
        destination.isSigned = source.isSigned;
        destination.isStruct = source.isStruct;
        destination.isTemplate = source.isTemplate;
        destination.isUnion = source.isUnion;
        destination.isUnsigned = source.isUnsigned;
        destination.isVarArgs = source.isVarArgs;
        destination.pointerLevels = source.pointerLevels;
        destination.isUnaligned = source.isUnaligned();
        destination.isRestrict = source.isRestrict();
        destination.basedName = source.getBasedName();
        destination.memberScope = source.getMemberScope();
        destination.setNamespace(source.getNamespace());
        destination.setTemplate(source.getTemplate());
        destination.isCoclass = source.isCoclass;
        destination.isCointerface = source.isCointerface;
        if (source.isConst()) {
            destination.setConst();
        }
    }

    public DataType getDataType(DataTypeManager dataTypeManager) {
        String name = this.getName();
        if (name == null) {
            return DataType.DEFAULT;
        }
        Object dt = null;
        if (this.namespace == null) {
            dt = this.getBuiltInType(dataTypeManager);
        }
        if (dt == null) {
            DataType baseType = dt = DemangledDataType.findDataType(dataTypeManager, this.namespace, name);
            if (dt instanceof TypeDef) {
                baseType = ((TypeDef)dt).getBaseDataType();
            }
            if (this.isStruct()) {
                if (baseType == null || !(baseType instanceof Structure)) {
                    dt = DemangledDataType.createPlaceHolderStructure(name, this.getNamespace());
                }
            } else if (this.isUnion()) {
                if (baseType == null || !(baseType instanceof Union)) {
                    dt = new UnionDataType(DemangledDataType.getDemanglerCategoryPath(name, this.getNamespace()), name);
                }
            } else if (this.isEnum()) {
                if (baseType == null || !(baseType instanceof Enum)) {
                    dt = this.enumType == null || INT.equals(this.enumType) || "unsigned int".equals(this.enumType) ? new EnumDataType(DemangledDataType.getDemanglerCategoryPath(name, this.getNamespace()), name, dataTypeManager.getDataOrganization().getIntegerSize()) : (CHAR.equals(this.enumType) || "unsigned char".equals(this.enumType) ? new EnumDataType(DemangledDataType.getDemanglerCategoryPath(name, this.getNamespace()), name, dataTypeManager.getDataOrganization().getCharSize()) : (SHORT.equals(this.enumType) || "unsigned short".equals(this.enumType) ? new EnumDataType(DemangledDataType.getDemanglerCategoryPath(name, this.getNamespace()), name, dataTypeManager.getDataOrganization().getShortSize()) : (LONG.equals(this.enumType) || "unsigned long".equals(this.enumType) ? new EnumDataType(DemangledDataType.getDemanglerCategoryPath(name, this.getNamespace()), name, dataTypeManager.getDataOrganization().getLongSize()) : new EnumDataType(DemangledDataType.getDemanglerCategoryPath(name, this.getNamespace()), name, dataTypeManager.getDataOrganization().getIntegerSize()))));
                }
            } else if (this.isClass() || name.equals(STRING)) {
                if (baseType == null || !(baseType instanceof Structure)) {
                    dt = DemangledDataType.createPlaceHolderStructure(name, this.getNamespace());
                }
            } else if (dt == null) {
                dt = !this.isReference() && !this.isPointer() ? new TypedefDataType(DemangledDataType.getDemanglerCategoryPath(name, this.getNamespace()), name, (DataType)new DWordDataType()) : DemangledDataType.createPlaceHolderStructure(name, this.getNamespace());
            }
        }
        int numPointers = this.getPointerLevels();
        if (this.isReference()) {
            ++numPointers;
        }
        for (int i = 0; i < numPointers; ++i) {
            dt = PointerDataType.getPointer((DataType)dt, (DataTypeManager)dataTypeManager);
        }
        return dt;
    }

    private DataType getBuiltInType(DataTypeManager dataTypeManager) {
        Object dt = null;
        String name = this.getName();
        if (BOOL.equals(name)) {
            dt = BooleanDataType.dataType;
        } else if (VOID.equals(name)) {
            dt = VoidDataType.dataType;
        } else if (CHAR.equals(name)) {
            dt = this.isUnsigned() ? UnsignedCharDataType.dataType : CharDataType.dataType;
        } else if (SHORT.equals(name)) {
            dt = this.isUnsigned() ? UnsignedShortDataType.dataType : ShortDataType.dataType;
        } else if (INT.equals(name)) {
            dt = this.isUnsigned() ? UnsignedIntegerDataType.dataType : IntegerDataType.dataType;
        } else if (LONG.equals(name)) {
            dt = this.isUnsigned() ? UnsignedLongDataType.dataType : LongDataType.dataType;
        } else if (LONG_LONG.equals(name)) {
            dt = this.isUnsigned() ? UnsignedLongLongDataType.dataType : LongLongDataType.dataType;
        } else if (UNSIGNED.equals(name)) {
            dt = UnsignedIntegerDataType.dataType;
        } else if (FLOAT.equals(name)) {
            dt = FloatDataType.dataType;
        } else if (DOUBLE.equals(name)) {
            dt = DoubleDataType.dataType;
        } else if (LONG_DOUBLE.equals(name)) {
            dt = LongDoubleDataType.dataType;
        } else if (INT8.equals(name)) {
            dt = this.isUnsigned() ? new TypedefDataType("__uint8", AbstractIntegerDataType.getUnsignedDataType((int)1, (DataTypeManager)dataTypeManager)) : new TypedefDataType(INT8, AbstractIntegerDataType.getSignedDataType((int)1, (DataTypeManager)dataTypeManager));
        } else if (INT16.equals(name)) {
            dt = this.isUnsigned() ? new TypedefDataType("__uint16", AbstractIntegerDataType.getUnsignedDataType((int)2, (DataTypeManager)dataTypeManager)) : new TypedefDataType(INT16, AbstractIntegerDataType.getSignedDataType((int)2, (DataTypeManager)dataTypeManager));
        } else if (INT32.equals(name)) {
            dt = this.isUnsigned() ? new TypedefDataType("__uint32", AbstractIntegerDataType.getUnsignedDataType((int)4, (DataTypeManager)dataTypeManager)) : new TypedefDataType(INT32, AbstractIntegerDataType.getSignedDataType((int)4, (DataTypeManager)dataTypeManager));
        } else if (INT64.equals(name)) {
            dt = this.isUnsigned() ? new TypedefDataType("__uint64", AbstractIntegerDataType.getUnsignedDataType((int)8, (DataTypeManager)dataTypeManager)) : new TypedefDataType(INT64, AbstractIntegerDataType.getSignedDataType((int)8, (DataTypeManager)dataTypeManager));
        } else if (UNDEFINED.equals(name)) {
            dt = DataType.DEFAULT;
        }
        return dt;
    }

    static DataType findDataType(DataTypeManager dataTypeManager, DemangledType namespace, String dtName) {
        ArrayList list = new ArrayList();
        dataTypeManager.findDataTypes(dtName, list);
        if (!list.isEmpty()) {
            DataType anyDt = null;
            DataType preferredDataType = null;
            for (DataType existingDT : list) {
                if (existingDT instanceof BuiltIn) continue;
                if (namespace == null) {
                    if (existingDT.getCategoryPath().equals((Object)CategoryPath.ROOT)) {
                        return existingDT;
                    }
                    anyDt = existingDT;
                }
                if (!DemangledDataType.isNamespaceCategoryMatch(existingDT, namespace)) continue;
                preferredDataType = existingDT;
            }
            if (preferredDataType != null) {
                return preferredDataType;
            }
            return anyDt;
        }
        return null;
    }

    private static boolean isNamespaceCategoryMatch(DataType dt, DemangledType namespace) {
        if (namespace == null) {
            return true;
        }
        CategoryPath categoryPath = dt.getCategoryPath();
        for (DemangledType ns = namespace; ns != null; ns = ns.getNamespace()) {
            if (categoryPath.equals((Object)CategoryPath.ROOT) || !categoryPath.getName().equals(ns.getName())) {
                return false;
            }
            categoryPath = categoryPath.getParent();
        }
        return true;
    }

    private static String getNamespacePath(String dtName, DemangledType namespace) {
        Object namespacePath = "";
        for (DemangledType ns = namespace; ns != null; ns = ns.getNamespace()) {
            namespacePath = "/" + ns.getName() + (String)namespacePath;
        }
        return namespacePath;
    }

    private static CategoryPath getDemanglerCategoryPath(String dtName, DemangledType namespace) {
        return new CategoryPath("/Demangler" + DemangledDataType.getNamespacePath(dtName, namespace));
    }

    static Structure createPlaceHolderStructure(String dtName, DemangledType namespace) {
        StructureDataType structDT = new StructureDataType(dtName, 0);
        structDT.setDescription("PlaceHolder Structure");
        structDT.setCategoryPath(DemangledDataType.getDemanglerCategoryPath(dtName, namespace));
        return structDT;
    }

    public int getPointerLevels() {
        return this.pointerLevels;
    }

    public void incrementPointerLevels() {
        ++this.pointerLevels;
    }

    public void setArray(int dimensions) {
        this.arrayDimensions = dimensions;
    }

    public int getArrayDimensions() {
        return this.arrayDimensions;
    }

    public void setClass() {
        this.isClass = true;
    }

    public void setComplex() {
        this.isComplex = true;
    }

    public void setEnum() {
        this.isEnum = true;
    }

    public void setPointer64() {
        this.isPointer64 = true;
    }

    public void setReference() {
        this.isReference = true;
    }

    public void setSigned() {
        this.isSigned = true;
    }

    public void setStruct() {
        this.isStruct = true;
    }

    public void setTemplate() {
        this.isTemplate = true;
    }

    public void setUnion() {
        this.isUnion = true;
    }

    public void setCoclass() {
        this.isCoclass = true;
    }

    public void setCointerface() {
        this.isCointerface = true;
    }

    public void setUnsigned() {
        this.isUnsigned = true;
    }

    public void setUnaligned() {
        this.isUnaligned = true;
    }

    public boolean isUnaligned() {
        return this.isUnaligned;
    }

    public void setVarArgs() {
        this.isVarArgs = true;
    }

    public void setEnumType(String enumType) {
        this.enumType = enumType;
    }

    public void setRestrict() {
        this.isRestrict = true;
    }

    public boolean isRestrict() {
        return this.isRestrict;
    }

    public boolean isArray() {
        return this.arrayDimensions > 0;
    }

    public boolean isClass() {
        return this.isClass;
    }

    public boolean isComplex() {
        return this.isComplex;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public boolean isPointer() {
        return this.pointerLevels > 0;
    }

    public boolean isPointer64() {
        return this.isPointer64;
    }

    public boolean isReference() {
        return this.isReference;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public boolean isStruct() {
        return this.isStruct;
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public boolean isUnion() {
        return this.isUnion;
    }

    public boolean isCoclass() {
        return this.isCoclass;
    }

    public boolean isCointerface() {
        return this.isCointerface;
    }

    public boolean isUnsigned() {
        return this.isUnsigned;
    }

    public boolean isVarArgs() {
        return this.isVarArgs;
    }

    public boolean isVoid() {
        return VOID.equals(this.getName());
    }

    public String setEnumType() {
        return this.enumType;
    }

    public String getBasedName() {
        return this.basedName;
    }

    public void setBasedName(String basedName) {
        this.basedName = basedName;
    }

    public String getMemberScope() {
        return this.memberScope;
    }

    public void setMemberScope(String memberScope) {
        this.memberScope = memberScope;
    }

    public boolean isPrimitive() {
        boolean isPrimitiveDT;
        boolean bl = isPrimitiveDT = !this.isArray() && !this.isClass && !this.isComplex && !this.isEnum && !this.isPointer() && !this.isPointer64 && !this.isSigned && !this.isTemplate && !this.isUnion && !this.isCoclass && !this.isCointerface && !this.isVarArgs;
        if (isPrimitiveDT) {
            for (String primitiveNames : PRIMITIVES) {
                if (!this.getName().equals(primitiveNames)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String toSignature() {
        Matcher matcher;
        StringBuffer buffer = new StringBuffer();
        if (this.isUnion) {
            buffer.append("union ");
        }
        if (this.isStruct) {
            buffer.append("struct ");
        }
        if (this.isEnum) {
            buffer.append("enum ");
            if (this.enumType != null && !INT.equals(this.enumType)) {
                buffer.append(this.enumType + " ");
            }
        }
        if (this.isClass) {
            buffer.append("class ");
        }
        if (this.isCoclass) {
            buffer.append("coclass ");
        }
        if (this.isCointerface) {
            buffer.append("cointerface ");
        }
        if (this.isComplex) {
            buffer.append("complex ");
        }
        if (this.isSigned) {
            buffer.append("signed ");
        }
        if (this.isUnsigned) {
            buffer.append("unsigned ");
        }
        if (this.getNamespace() != null) {
            buffer.append(this.getNamespace().toNamespace());
        }
        buffer.append(this.getDemangledName());
        if (this.getTemplate() != null) {
            buffer.append(this.getTemplate().toTemplate());
        }
        if (this.isConst()) {
            buffer.append(" const");
        }
        if (this.isVolatile()) {
            buffer.append(" volatile");
        }
        if (this.basedName != null) {
            buffer.append(" " + this.basedName);
        }
        if (this.memberScope != null && this.memberScope.length() != 0) {
            buffer.append(" " + this.memberScope + "::");
        }
        if (this.isUnaligned) {
            buffer.append(" __unaligned");
        }
        if (this.pointerLevels >= 1) {
            buffer.append(" *");
        }
        if (this.isReference) {
            buffer.append(" &");
        }
        if (this.isPointer64) {
            buffer.append(" __ptr64");
        }
        if (this.isRestrict) {
            buffer.append(" __restrict");
        }
        for (int i = 1; i < this.pointerLevels; ++i) {
            buffer.append(" *");
        }
        if (this.isArray() && !(matcher = ARRAY_SUBSCRIPT_PATTERN.matcher(this.getName())).find()) {
            for (int i = 0; i < this.arrayDimensions; ++i) {
                buffer.append(ARR_NOTATION);
            }
        }
        return buffer.toString();
    }

    @Override
    public String toString() {
        return this.toSignature();
    }
}

