/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.demangler;

import ghidra.app.cmd.data.CreateDataCmd;
import ghidra.app.util.PseudoDisassembler;
import ghidra.app.util.demangler.DemangledDataType;
import ghidra.app.util.demangler.DemangledFunctionIndirect;
import ghidra.app.util.demangler.DemangledFunctionPointer;
import ghidra.app.util.demangler.DemangledFunctionReference;
import ghidra.app.util.demangler.DemangledObject;
import ghidra.app.util.demangler.DemangledObjectFactory;
import ghidra.app.util.demangler.DemanglerOptions;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;
import ghidra.util.exception.AssertException;
import ghidra.util.task.TaskMonitor;
import util.demangler.GenericDemangledDataType;
import util.demangler.GenericDemangledObject;
import util.demangler.GenericDemangledType;
import util.demangler.GenericDemangledVariable;

public class DemangledVariable
extends DemangledObject {
    private DemangledDataType datatype;

    public DemangledVariable(String name) {
        this.setName(name);
    }

    DemangledVariable(GenericDemangledVariable other) {
        super((GenericDemangledObject)other);
        GenericDemangledDataType otherDatatype = other.getDataType();
        if (otherDatatype != null) {
            this.datatype = (DemangledDataType)DemangledObjectFactory.convert((GenericDemangledType)otherDatatype);
        }
    }

    public void setDatatype(DemangledDataType datatype) {
        this.datatype = datatype;
    }

    public DemangledDataType getDataType() {
        return this.datatype;
    }

    private DataType getProgramDataType(Program program) {
        if (this.datatype != null) {
            return this.datatype.getDataType(program.getDataTypeManager());
        }
        return null;
    }

    @Override
    public String getSignature(boolean format) {
        StringBuffer buffer = new StringBuffer();
        buffer.append((String)(this.specialPrefix == null ? "" : this.specialPrefix + " "));
        buffer.append((String)(this.visibility == null || "global".equals(this.visibility) ? "" : this.visibility + " "));
        buffer.append(this.isStatic ? "static " : "");
        buffer.append(this.isVirtual ? "virtual " : "");
        String n = this.getDemangledName();
        boolean hasName = n != null && !n.isEmpty();
        StringBuffer datatypeBuffer = new StringBuffer();
        String spacer = "";
        if (!(this.datatype instanceof DemangledFunctionPointer || this.datatype instanceof DemangledFunctionReference || this.datatype instanceof DemangledFunctionIndirect || this.datatype == null)) {
            datatypeBuffer.append(this.datatype.toSignature());
            spacer = " ";
        }
        if (this.storageClass != null) {
            datatypeBuffer.append(spacer).append(this.storageClass);
            spacer = " ";
        }
        if (this.isConst()) {
            datatypeBuffer.append(spacer).append("const");
            spacer = " ";
        }
        if (this.isVolatile()) {
            datatypeBuffer.append(spacer).append("volatile");
            spacer = " ";
        }
        if (this.basedName != null) {
            datatypeBuffer.append(spacer).append(this.basedName);
            spacer = " ";
        }
        if (this.memberScope != null && this.memberScope.length() != 0) {
            datatypeBuffer.append(spacer).append(this.memberScope + "::");
            spacer = " ";
        }
        if (this.isUnaligned()) {
            datatypeBuffer.append(spacer).append("__unaligned");
            spacer = " ";
        }
        if (this.isPointer64()) {
            datatypeBuffer.append(spacer).append("__ptr64");
            spacer = " ";
        }
        if (this.isRestrict()) {
            datatypeBuffer.append(spacer).append("__restrict");
            spacer = " ";
        }
        if (this.namespace != null) {
            datatypeBuffer.append(spacer);
            spacer = "";
            datatypeBuffer.append(this.namespace.toNamespace());
            if (!hasName) {
                int end = buffer.length();
                datatypeBuffer.delete(end - 2, end);
            }
        }
        if (hasName) {
            datatypeBuffer.append(spacer);
            spacer = "";
            datatypeBuffer.append(this.getName());
        }
        datatypeBuffer.append((String)(this.specialMidfix == null ? "" : this.specialMidfix + " "));
        datatypeBuffer.append((String)(this.specialSuffix == null ? "" : " " + this.specialSuffix));
        if (this.datatype instanceof DemangledFunctionPointer) {
            DemangledFunctionPointer funcPtr = (DemangledFunctionPointer)this.datatype;
            return buffer.append(funcPtr.toSignature(datatypeBuffer.toString())).toString();
        }
        if (this.datatype instanceof DemangledFunctionReference) {
            DemangledFunctionReference funcRef = (DemangledFunctionReference)this.datatype;
            return buffer.append(funcRef.toSignature(datatypeBuffer.toString())).toString();
        }
        if (this.datatype instanceof DemangledFunctionIndirect) {
            DemangledFunctionIndirect funcDef = (DemangledFunctionIndirect)this.datatype;
            return buffer.append(funcDef.toSignature(datatypeBuffer.toString())).toString();
        }
        buffer.append(datatypeBuffer);
        return buffer.toString();
    }

    @Override
    protected boolean isAlreadyDemangled(Program program, Address address) {
        Data data = program.getListing().getDefinedDataAt(address);
        if (data == null || Undefined.isUndefined((DataType)data.getDataType())) {
            return false;
        }
        return super.isAlreadyDemangled(program, address);
    }

    @Override
    public boolean applyTo(Program program, Address address, DemanglerOptions options, TaskMonitor monitor) throws Exception {
        if (this.isAlreadyDemangled(program, address)) {
            return true;
        }
        if (!super.applyTo(program, address, options, monitor)) {
            return false;
        }
        Symbol demangledSymbol = this.applyDemangledName(address, true, true, program);
        DataType demangledDT = this.getProgramDataType(program);
        if (address.isExternalAddress()) {
            if (demangledSymbol == null) {
                throw new AssertException("Undefined external address: " + address);
            }
            if (demangledDT != null) {
                ExternalLocation extLoc = (ExternalLocation)demangledSymbol.getObject();
                extLoc.setDataType(demangledDT);
            }
            return true;
        }
        Listing listing = program.getListing();
        Data d = listing.getDefinedDataAt(address);
        if (!(d == null || demangledDT != null && Undefined.isUndefined((DataType)d.getDataType()))) {
            return true;
        }
        if (demangledDT != null) {
            CreateDataCmd cmd = new CreateDataCmd(address, demangledDT, false, DataUtilities.ClearDataMode.CLEAR_ALL_UNDEFINED_CONFLICT_DATA);
            if (!cmd.applyTo((DomainObject)program)) {
                Msg.error((Object)this, (Object)("Failed to create data at " + address + ": " + cmd.getStatusMsg()));
                return false;
            }
            return true;
        }
        MemoryBlock block = program.getMemory().getBlock(address);
        if (block == null || block.isExecute()) {
            return true;
        }
        Address nextSymbolLoc = this.getNextSymbolLocation(program, address);
        long maximumDataTypeSize = nextSymbolLoc.subtract(address);
        if (this.createPointer(program, address, maximumDataTypeSize)) {
            return true;
        }
        if (d != null) {
            return true;
        }
        int size = maximumDataTypeSize <= 8L ? (int)maximumDataTypeSize : 1;
        demangledDT = Undefined.getUndefinedDataType((int)size);
        try {
            listing.createData(address, demangledDT);
        }
        catch (CodeUnitInsertionException e) {
            Msg.trace((Object)this, (Object)("Unable to create demangled data '" + demangledDT + "' @ " + address));
        }
        return true;
    }

    @Override
    public String getName() {
        String myName = super.getName();
        if (!myName.isEmpty()) {
            return myName;
        }
        if (this.datatype != null) {
            return this.datatype.getName();
        }
        String signature = this.getSignature(true);
        String fixed = SymbolUtilities.replaceInvalidChars((String)signature, (boolean)true);
        return fixed;
    }

    private boolean createPointer(Program program, Address address, long maximumDataTypeSize) {
        if (maximumDataTypeSize < (long)address.getPointerSize()) {
            return false;
        }
        PseudoDisassembler pdis = new PseudoDisassembler(program);
        Address indirectAddress = pdis.getIndirectAddr(address);
        if (indirectAddress == null) {
            return false;
        }
        if (!program.getMemory().contains(indirectAddress)) {
            return false;
        }
        SymbolTable symbolTable = program.getSymbolTable();
        Symbol primarySymbol = symbolTable.getPrimarySymbol(indirectAddress);
        if (primarySymbol != null && primarySymbol.getSource() != SourceType.DEFAULT) {
            return this.createPointer(program, address);
        }
        Listing listing = program.getListing();
        Data data = listing.getDataAt(indirectAddress);
        if (data != null && data.isDefined()) {
            return this.createPointer(program, address);
        }
        return false;
    }

    private boolean createPointer(Program program, Address address) {
        PointerDataType pointer = new PointerDataType(program.getDataTypeManager());
        CreateDataCmd cmd = new CreateDataCmd(address, (DataType)pointer, false, DataUtilities.ClearDataMode.CLEAR_ALL_UNDEFINED_CONFLICT_DATA);
        if (!cmd.applyTo((DomainObject)program)) {
            Msg.error((Object)this, (Object)("Failed to create pointer at " + address + ": " + cmd.getStatusMsg()));
            return false;
        }
        return true;
    }

    private Address getNextSymbolLocation(Program program, Address address) {
        Symbol nextSym;
        SymbolIterator symIter = program.getSymbolTable().getSymbolIterator(address.add(1L), true);
        if (symIter.hasNext() && (nextSym = symIter.next()) != null) {
            return nextSym.getAddress();
        }
        return program.getMaxAddress();
    }
}

