/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.checkbox.GCheckBox;
import ghidra.app.util.viewer.field.NamespaceWrappedOption;
import ghidra.framework.options.CustomOptionsEditor;
import ghidra.util.HTMLUtilities;
import ghidra.util.layout.VerticalLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyEditorSupport;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NamespacePropertyEditor
extends PropertyEditorSupport
implements CustomOptionsEditor {
    private static final String DISPLAY_LOCAL_NAMESPACE_LABEL = "Display Local Namespace";
    private static final String DISPLAY_NON_LOCAL_NAMESPACE_LABEL = "Display Non-local Namespace";
    private static final String LOCAL_NAMESPACE_PREFIX_LABEL = "Local namespace prefix";
    private static final String DISPLAY_LIBRARY_IN_NAMESPACE_LABEL = "Display library in namespace";
    private static final String[] NAMES = new String[]{"Display Local Namespace", "Display Non-local Namespace", "Local namespace prefix", "Display library in namespace"};
    private static final String SHOW_NON_LOCAL_NAMESPACE_TOOLTIP = HTMLUtilities.toWrappedHTML((String)"Prepends namespaces to fields that are not in the local namespace.", (int)75);
    private static final String SHOW_LOCAL_NAMESPACE_TOOLTIP = HTMLUtilities.toWrappedHTML((String)"Prepends namespaces to fields that are in the local namespace.", (int)75);
    private static final String LOCAL_PREFIX_TOOLTIP = HTMLUtilities.toWrappedHTML((String)"The prefix value prepended to fields instead of the local namespace of the containing function.", (int)75);
    private static final String SHOW_LIBRARY_IN_NAMESPACE_TOOLTIP = HTMLUtilities.toWrappedHTML((String)"Includes library in namespace when displayed in fields.", (int)75);
    private static final String[] DESCRIPTIONS = new String[]{SHOW_LOCAL_NAMESPACE_TOOLTIP, SHOW_NON_LOCAL_NAMESPACE_TOOLTIP, LOCAL_PREFIX_TOOLTIP, SHOW_LIBRARY_IN_NAMESPACE_TOOLTIP};
    private NamespaceWrappedOption namespaceWrappedOption;
    private Component editorComponent = this.buildEditor();
    private JCheckBox showNonLocalCheckBox;
    private JCheckBox showLocalCheckBox;
    private JCheckBox useLocalPrefixCheckBox;
    private JTextField localPrefixField;
    private JCheckBox showLibraryInNamespaceCheckBox;

    private Component buildEditor() {
        JPanel panel = new JPanel((LayoutManager)new VerticalLayout(3));
        this.showNonLocalCheckBox = new GCheckBox(DISPLAY_NON_LOCAL_NAMESPACE_LABEL);
        this.showNonLocalCheckBox.setSelected(false);
        this.showNonLocalCheckBox.setToolTipText(SHOW_NON_LOCAL_NAMESPACE_TOOLTIP);
        this.showLocalCheckBox = new GCheckBox(DISPLAY_LOCAL_NAMESPACE_LABEL);
        this.showLocalCheckBox.setSelected(false);
        this.showLocalCheckBox.setToolTipText(SHOW_LOCAL_NAMESPACE_TOOLTIP);
        this.showLibraryInNamespaceCheckBox = new GCheckBox(DISPLAY_LIBRARY_IN_NAMESPACE_LABEL);
        this.showLibraryInNamespaceCheckBox.setSelected(true);
        this.showLocalCheckBox.setToolTipText(SHOW_LIBRARY_IN_NAMESPACE_TOOLTIP);
        panel.add(this.showNonLocalCheckBox);
        panel.add(this.showLocalCheckBox);
        panel.add(this.showLibraryInNamespaceCheckBox);
        this.localPrefixField = this.createLocalPrefixTextField(LOCAL_NAMESPACE_PREFIX_LABEL, LOCAL_PREFIX_TOOLTIP, panel);
        this.showLocalCheckBox.addItemListener(e -> {
            boolean enabled = this.showLocalCheckBox.isSelected();
            this.localPrefixField.setEnabled(enabled && this.useLocalPrefixCheckBox.isSelected());
            this.useLocalPrefixCheckBox.setEnabled(enabled);
            this.firePropertyChange();
        });
        this.showNonLocalCheckBox.addItemListener(e -> this.firePropertyChange());
        this.showLibraryInNamespaceCheckBox.addItemListener(e -> this.firePropertyChange());
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0), new TitledBorder("Namespace Options")));
        return panel;
    }

    private JTextField createLocalPrefixTextField(String labelText, String tooltipText, Container parent) {
        JTextField textField = new JTextField(20);
        textField.setEnabled(false);
        JPanel textFieldPanel = new JPanel();
        textFieldPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.useLocalPrefixCheckBox = new GCheckBox("Use Local Namespace Override");
        this.useLocalPrefixCheckBox.setToolTipText(tooltipText);
        this.useLocalPrefixCheckBox.addItemListener(e -> {
            textField.setEnabled(this.useLocalPrefixCheckBox.isSelected());
            this.firePropertyChange();
        });
        textFieldPanel.add(this.useLocalPrefixCheckBox);
        textFieldPanel.add(textField);
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                NamespacePropertyEditor.this.firePropertyChange();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NamespacePropertyEditor.this.firePropertyChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NamespacePropertyEditor.this.firePropertyChange();
            }
        });
        textField.setEnabled(false);
        parent.add(textFieldPanel);
        return textField;
    }

    @Override
    public void setValue(Object value) {
        if (!(value instanceof NamespaceWrappedOption)) {
            return;
        }
        this.namespaceWrappedOption = (NamespaceWrappedOption)value;
        this.setLocalValues(this.namespaceWrappedOption);
        this.firePropertyChange();
    }

    private void setLocalValues(NamespaceWrappedOption namespaceOption) {
        if (namespaceOption.isShowNonLocalNamespace() != this.showNonLocalCheckBox.isSelected()) {
            this.showNonLocalCheckBox.setSelected(namespaceOption.isShowNonLocalNamespace());
        }
        if (namespaceOption.isShowLocalNamespace() != this.showLocalCheckBox.isSelected()) {
            this.showLocalCheckBox.setSelected(namespaceOption.isShowLocalNamespace());
        }
        if (namespaceOption.isShowLibraryInNamespace() != this.showLibraryInNamespaceCheckBox.isSelected()) {
            this.showLibraryInNamespaceCheckBox.setSelected(namespaceOption.isShowLibraryInNamespace());
        }
        if (namespaceOption.isUseLocalPrefixOverride() != this.useLocalPrefixCheckBox.isSelected()) {
            this.useLocalPrefixCheckBox.setSelected(namespaceOption.isUseLocalPrefixOverride());
        }
        if (!this.localPrefixField.getText().equals(namespaceOption.getLocalPrefixText())) {
            this.localPrefixField.setText(namespaceOption.getLocalPrefixText());
        }
        boolean localNamespaceEnabled = this.showLocalCheckBox.isSelected();
        this.useLocalPrefixCheckBox.setEnabled(localNamespaceEnabled);
        this.localPrefixField.setEnabled(localNamespaceEnabled && this.useLocalPrefixCheckBox.isSelected());
        boolean nonLocalNamespaceEnabled = this.showNonLocalCheckBox.isSelected();
        this.showLibraryInNamespaceCheckBox.setEnabled(nonLocalNamespaceEnabled);
    }

    private NamespaceWrappedOption cloneNamespaceValues() {
        NamespaceWrappedOption newOption = new NamespaceWrappedOption();
        newOption.setShowLocalNamespace(this.showLocalCheckBox.isSelected());
        newOption.setShowNonLocalNamespace(this.showNonLocalCheckBox.isSelected());
        newOption.setShowLibraryInNamespace(this.showLibraryInNamespaceCheckBox.isSelected());
        newOption.setUseLocalPrefixOverride(this.useLocalPrefixCheckBox.isSelected());
        newOption.setLocalPrefixText(this.localPrefixField.getText());
        return newOption;
    }

    public String[] getOptionDescriptions() {
        return DESCRIPTIONS;
    }

    public String[] getOptionNames() {
        return NAMES;
    }

    @Override
    public Object getValue() {
        return this.cloneNamespaceValues();
    }

    @Override
    public Component getCustomEditor() {
        return this.editorComponent;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }
}

