/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.format;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.ClippingTextField;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextField;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import docking.widgets.fieldpanel.support.Highlight;
import docking.widgets.fieldpanel.support.HighlightFactory;
import ghidra.app.util.HighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.FieldHighlightFactory;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.proxy.ProxyObj;
import java.awt.Color;

public class ErrorListingField
extends ListingTextField {
    private Throwable t;
    private static HighlightProvider myProvider = new HighlightProvider(){

        @Override
        public Highlight[] getHighlights(String text, Object obj, Class<? extends FieldFactory> fieldFactoryClass, int cursorTextOffset) {
            return new Highlight[]{new Highlight(0, text.length() - 1, new Color(245, 158, 158))};
        }
    };

    public ErrorListingField(FieldFactory ff, ProxyObj proxy, int varWidth, Throwable t) {
        super(ff, proxy, ErrorListingField.createField(ff, proxy, varWidth, t));
        this.t = t;
    }

    private static TextField createField(FieldFactory ff, ProxyObj proxy, int varWidth, Throwable t) {
        FieldHighlightFactory hlFactory = new FieldHighlightFactory(myProvider, ff.getClass(), proxy.getObject());
        return new ClippingTextField(ff.getStartX() + varWidth, ff.getWidth(), ErrorListingField.createElement(ff, t), (HighlightFactory)hlFactory);
    }

    private static FieldElement createElement(FieldFactory ff, Throwable t) {
        String message = t.getMessage() == null ? t.toString() : t.getMessage();
        AttributedString as = new AttributedString("*Error*: " + message + ".  Double click for Details.", Color.BLACK, ff.getMetrics());
        return new TextFieldElement(as, 0, 0);
    }

    public Throwable getThrowable() {
        return this.t;
    }

    @Override
    public Object getClickedObject(FieldLocation fieldLocation) {
        return this;
    }
}

