/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.xml;

import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.xml.BytesFile;
import ghidra.app.util.xml.RangeBlock;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.mem.MemoryBlockSourceInfo;
import ghidra.program.model.mem.MemoryBlockType;
import ghidra.util.XmlProgramUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlAttributes;
import ghidra.util.xml.XmlUtilities;
import ghidra.util.xml.XmlWriter;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import org.xml.sax.SAXParseException;

class MemoryMapXmlMgr {
    private Program program;
    private Memory memory;
    private AddressFactory factory;
    private MessageLog log;

    MemoryMapXmlMgr(Program program, MessageLog log) {
        this.program = program;
        this.memory = program.getMemory();
        this.factory = program.getAddressFactory();
        this.log = log;
    }

    void read(XmlPullParser parser, boolean overwriteConflicts, TaskMonitor monitor, String directory) throws SAXParseException, FileNotFoundException, CancelledException {
        XmlElement element = parser.next();
        element = parser.next();
        while (element.getName().equals("MEMORY_SECTION")) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            this.processMemoryBlock(element, parser, directory, this.program, monitor);
            element = parser.next();
        }
        if (element.isStart() || !element.getName().equals("MEMORY_MAP")) {
            throw new SAXParseException("Expected MEMORY_MAP end tag, got " + element.getName(), null, null, parser.getLineNumber(), parser.getColumnNumber());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMemoryBlock(XmlElement memorySectionElement, XmlPullParser parser, String directory, Program program, TaskMonitor monitor) throws FileNotFoundException {
        String name = memorySectionElement.getAttribute("NAME");
        String addrStr = memorySectionElement.getAttribute("START_ADDR");
        Address addr = XmlProgramUtilities.parseAddress((AddressFactory)this.factory, (String)addrStr);
        String overlayName = XmlUtilities.parseOverlayName((String)addrStr);
        int length = XmlUtilities.parseInt((String)memorySectionElement.getAttribute("LENGTH"));
        String permissions = memorySectionElement.getAttribute("PERMISSIONS");
        if (permissions == null) {
            permissions = "r";
        }
        boolean r = permissions.indexOf("r") >= 0;
        boolean w = permissions.indexOf("w") >= 0;
        boolean x = permissions.indexOf("x") >= 0;
        String volatility = memorySectionElement.getAttribute("VOLATILE");
        boolean isVolatile = "y".equals(volatility);
        String comment = memorySectionElement.getAttribute("COMMENT");
        try {
            XmlElement element = parser.peek();
            if (element.getName().equals("MEMORY_CONTENTS")) {
                MemoryBlock block;
                byte[] bytes = new byte[length];
                Arrays.fill(bytes, (byte)-1);
                while (element.getName().equals("MEMORY_CONTENTS")) {
                    element = parser.next();
                    Address startAddr = addr;
                    if (element.hasAttribute("START_ADDR")) {
                        String startAddrStr = element.getAttribute("START_ADDR");
                        int index = startAddrStr.indexOf("::");
                        if (index > 0) {
                            startAddrStr = startAddrStr.substring(index + 2);
                        }
                        startAddr = XmlProgramUtilities.parseAddress((AddressFactory)this.factory, (String)startAddrStr);
                    }
                    String fileName = element.getAttribute("FILE_NAME");
                    int fileOffset = XmlUtilities.parseInt((String)element.getAttribute("FILE_OFFSET"));
                    int contentLen = element.hasAttribute("LENGTH") ? XmlUtilities.parseInt((String)element.getAttribute("LENGTH")) : length;
                    this.setData(bytes, (int)startAddr.subtract(addr), directory, fileName, fileOffset, contentLen, this.log);
                    parser.next();
                    element = parser.peek();
                }
                if (overlayName != null) {
                    block = MemoryBlockUtils.createInitializedBlock(program, true, overlayName, addr, new ByteArrayInputStream(bytes), (long)bytes.length, comment, null, r, w, x, this.log, monitor);
                    if (block != null) {
                        block.setVolatile(isVolatile);
                        if (!name.equals(overlayName)) {
                            block.setName(name);
                        }
                    }
                } else {
                    block = MemoryBlockUtils.createInitializedBlock(program, false, name, addr, new ByteArrayInputStream(bytes), (long)bytes.length, comment, null, r, w, x, this.log, monitor);
                    if (block != null) {
                        block.setVolatile(isVolatile);
                    }
                }
            } else if (element.getName().equals("BIT_MAPPED")) {
                Address sourceAddr = this.factory.getAddress(element.getAttribute("SOURCE_ADDRESS"));
                MemoryBlock block = MemoryBlockUtils.createBitMappedBlock(program, overlayName, addr, sourceAddr, length, comment, comment, r, w, x, this.log);
                if (block != null) {
                    block.setVolatile(isVolatile);
                }
                parser.next();
            } else if (element.getName().equals("BYTE_MAPPED")) {
                Address sourceAddr = this.factory.getAddress(element.getAttribute("SOURCE_ADDRESS"));
                MemoryBlock block = MemoryBlockUtils.createByteMappedBlock(program, overlayName, addr, sourceAddr, length, comment, comment, r, w, x, this.log);
                if (block != null) {
                    block.setVolatile(isVolatile);
                }
                parser.next();
            } else {
                MemoryBlock block = MemoryBlockUtils.createUninitializedBlock(program, overlayName != null, name, addr, length, comment, null, r, w, x, this.log);
                if (block != null) {
                    block.setVolatile(isVolatile);
                    if (overlayName != null && !name.equals(overlayName)) {
                        block.setName(name);
                    }
                }
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.appendException((Throwable)e);
        }
        finally {
            parser.discardSubTree(memorySectionElement);
        }
    }

    private void setData(byte[] bytes, int offset, String directory, String fileName, int fileOffset, int length, MessageLog log) throws IOException {
        File f = new File(directory, fileName);
        RandomAccessFile binfile = new RandomAccessFile(f, "r");
        try {
            int readLen;
            for (int pos = 0; pos < length; pos += readLen) {
                readLen = 524288;
                if (readLen + pos > length) {
                    readLen = length - pos;
                }
                binfile.seek(fileOffset + pos);
                readLen = binfile.read(bytes, offset + pos, readLen);
                if (readLen > 0) {
                    continue;
                }
                break;
            }
        }
        catch (IndexOutOfBoundsException e) {
            log.appendMsg("Invalid bin file offset " + offset + " with length " + length);
        }
        binfile.close();
    }

    void write(XmlWriter writer, AddressSetView addrs, TaskMonitor monitor, boolean isWriteContents, File file) throws IOException, CancelledException {
        monitor.setMessage("Writing MEMORY MAP ...");
        BytesFile bf = isWriteContents ? new BytesFile(file.getAbsolutePath()) : null;
        writer.startElement("MEMORY_MAP");
        AddressRangeIterator iter = addrs.getAddressRanges();
        while (iter.hasNext()) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            AddressRange range = (AddressRange)iter.next();
            RangeBlock rb = new RangeBlock(this.program.getAddressFactory(), this.program.getMemory(), range);
            for (int i = 0; i < rb.getRanges().length; ++i) {
                this.writeBlock(writer, rb.getRanges()[i], rb.getBlocks()[i], bf, isWriteContents);
            }
        }
        if (isWriteContents) {
            bf.close();
        }
        writer.endElement("MEMORY_MAP");
    }

    private void writeBlock(XmlWriter writer, AddressRange range, MemoryBlock block, BytesFile bytesFile, boolean isWriteContents) throws IOException {
        XmlAttributes attrs = new XmlAttributes();
        attrs.addAttribute("NAME", block.getName());
        attrs.addAttribute("START_ADDR", XmlProgramUtilities.toString((Address)range.getMinAddress()));
        attrs.addAttribute("LENGTH", range.getLength(), true);
        Object permissions = "r";
        if (block.isWrite()) {
            permissions = (String)permissions + "w";
        }
        if (block.isExecute()) {
            permissions = (String)permissions + "x";
        }
        attrs.addAttribute("PERMISSIONS", (String)permissions);
        if (block.getComment() != null) {
            attrs.addAttribute("COMMENT", block.getComment());
        }
        if (block.isVolatile()) {
            attrs.addAttribute("VOLATILE", true);
        }
        writer.startElement("MEMORY_SECTION", attrs);
        if (block.getType() == MemoryBlockType.BIT_MAPPED) {
            MemoryBlockSourceInfo info = (MemoryBlockSourceInfo)block.getSourceInfos().get(0);
            attrs.addAttribute("SOURCE_ADDRESS", ((AddressRange)info.getMappedRange().get()).getMinAddress().toString());
            writer.startElement("BIT_MAPPED", attrs);
            writer.endElement("BIT_MAPPED");
        } else if (block.getType() == MemoryBlockType.BYTE_MAPPED) {
            MemoryBlockSourceInfo info = (MemoryBlockSourceInfo)block.getSourceInfos().get(0);
            attrs.addAttribute("SOURCE_ADDRESS", ((AddressRange)info.getMappedRange().get()).getMinAddress().toString());
            writer.startElement("BYTE_MAPPED", attrs);
            writer.endElement("BYTE_MAPPED");
        } else if (block.isInitialized() && isWriteContents) {
            attrs.addAttribute("FILE_NAME", bytesFile.getFileName());
            attrs.addAttribute("FILE_OFFSET", bytesFile.getOffset(), true);
            writer.startElement("MEMORY_CONTENTS", attrs);
            writer.endElement("MEMORY_CONTENTS");
            bytesFile.writeBytes(this.memory, range);
        }
        writer.endElement("MEMORY_SECTION");
    }
}

