/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.fsbrowser;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.KeyBindingData;
import docking.action.MenuData;
import docking.widgets.filechooser.GhidraFileChooser;
import docking.widgets.filechooser.GhidraFileChooserMode;
import ghidra.app.events.ProgramActivatedPluginEvent;
import ghidra.app.services.FileSystemBrowserService;
import ghidra.app.services.ProgramManager;
import ghidra.app.services.TextEditorService;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemEventListener;
import ghidra.formats.gfilesystem.FileSystemProbeConflictResolver;
import ghidra.formats.gfilesystem.FileSystemRef;
import ghidra.formats.gfilesystem.FileSystemRefManager;
import ghidra.formats.gfilesystem.FileSystemService;
import ghidra.formats.gfilesystem.GFileSystem;
import ghidra.framework.main.FrontEndService;
import ghidra.framework.main.FrontEndable;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectListener;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.plugin.importer.ImporterUtilities;
import ghidra.plugin.importer.ProgramMappingService;
import ghidra.plugins.fsbrowser.FSBUtils;
import ghidra.plugins.fsbrowser.FileSystemBrowserComponentProvider;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.filechooser.GhidraFileFilter;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import utilities.util.FileUtilities;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Browse Filesystems in containers", description="This plugin allows users to browse and use the contents of containers (zips, tars, filesystems, etc)", servicesProvided={FileSystemBrowserService.class}, servicesRequired={TextEditorService.class}, eventsConsumed={ProgramActivatedPluginEvent.class})
public class FileSystemBrowserPlugin
extends Plugin
implements FrontEndable,
ProjectListener,
FileSystemEventListener,
FileSystemBrowserService {
    private static final String MENU_GROUP = "Import";
    DockingAction openFilesystemAction;
    private GhidraFileChooser chooserOpen;
    private FrontEndService frontEndService;
    private Map<FSRL, FileSystemBrowserComponentProvider> currentBrowsers = new HashMap<FSRL, FileSystemBrowserComponentProvider>();

    public FileSystemBrowserPlugin(PluginTool tool) {
        super(tool);
    }

    protected void init() {
        super.init();
        this.frontEndService = (FrontEndService)this.tool.getService(FrontEndService.class);
        if (this.frontEndService != null) {
            this.frontEndService.addProjectListener((ProjectListener)this);
        } else {
            FSBUtils.getProgramManager(this.tool, false);
        }
        this.setupOpenFileSystemAction();
    }

    protected void dispose() {
        super.dispose();
        if (this.openFilesystemAction != null) {
            this.openFilesystemAction.dispose();
        }
        if (this.frontEndService != null) {
            this.frontEndService.removeProjectListener((ProjectListener)this);
            this.frontEndService = null;
        }
        this.chooserOpen = null;
        for (FileSystemBrowserComponentProvider provider : this.currentBrowsers.values()) {
            provider.dispose();
        }
        this.currentBrowsers.clear();
    }

    @Override
    public void openFileSystem(FSRL fsrl) {
        TaskLauncher.launchModal((String)"Open File System", monitor -> this.doOpenFilesystem(fsrl, this.tool.getActiveWindow(), monitor));
    }

    void createNewFileSystemBrowser(FileSystemRef fsRef, boolean show) {
        SystemUtilities.runIfSwingOrPostSwingLater(() -> this.doCreateNewFileSystemBrowser(fsRef, show));
    }

    private void doCreateNewFileSystemBrowser(FileSystemRef fsRef, boolean show) {
        FSRLRoot fsFSRL = fsRef.getFilesystem().getFSRL();
        FileSystemBrowserComponentProvider provider = this.currentBrowsers.get(fsFSRL);
        if (provider != null) {
            Msg.info((Object)this, (Object)("Filesystem browser already open for " + fsFSRL));
            fsRef.close();
        } else {
            fsRef.getFilesystem().getRefManager().addListener(this);
            provider = new FileSystemBrowserComponentProvider(this, fsRef);
            this.currentBrowsers.put(fsFSRL, provider);
            this.getTool().addComponentProvider((ComponentProvider)provider, false);
            provider.afterAddedToTool();
        }
        if (show) {
            this.getTool().showComponentProvider((ComponentProvider)provider, true);
            this.getTool().toFront((ComponentProvider)provider);
        }
    }

    void removeFileSystemBrowser(FSRLRoot fsFSRL) {
        SystemUtilities.runIfSwingOrPostSwingLater(() -> {
            FileSystemBrowserComponentProvider fsbcp = this.currentBrowsers.get(fsFSRL);
            if (fsbcp == null) {
                return;
            }
            this.currentBrowsers.remove(fsFSRL);
            fsbcp.removeFromTool();
            fsbcp.dispose();
        });
    }

    private void removeAllFileSystemBrowsers() {
        SystemUtilities.runIfSwingOrPostSwingLater(() -> {
            for (FileSystemBrowserComponentProvider fsbcp : new ArrayList<FileSystemBrowserComponentProvider>(this.currentBrowsers.values())) {
                fsbcp.removeFromTool();
                fsbcp.dispose();
            }
            this.currentBrowsers.clear();
        });
    }

    public void processEvent(PluginEvent event) {
        super.processEvent(event);
        if (event instanceof ProgramActivatedPluginEvent) {
            ProgramActivatedPluginEvent pape = (ProgramActivatedPluginEvent)event;
            ProgramMappingService.createAutoAssocation(pape.getActiveProgram());
        }
    }

    public void projectClosed(Project project) {
        this.removeAllFileSystemBrowsers();
        FileSystemService.getInstance().closeUnusedFileSystems();
    }

    public void projectOpened(Project project) {
    }

    private void setupOpenFileSystemAction() {
        String actionName = "Open File System";
        this.openFilesystemAction = new DockingAction(actionName, this.getName()){

            public void actionPerformed(ActionContext context) {
                FileSystemBrowserPlugin.this.doOpenFileSystem();
            }

            public boolean isEnabledForContext(ActionContext context) {
                return FileSystemBrowserPlugin.this.tool.getProject() != null;
            }
        };
        this.openFilesystemAction.setMenuBarData(new MenuData(new String[]{"&File", actionName + "..."}, null, MENU_GROUP, -1, "z"));
        this.openFilesystemAction.setKeyBindingData(new KeyBindingData(73, 128));
        this.openFilesystemAction.setDescription(this.getPluginDescription().getDescription());
        this.openFilesystemAction.setEnabled(this.tool.getProject() != null);
        this.tool.addAction((DockingActionIf)this.openFilesystemAction);
    }

    private void openChooser(String title, String buttonText, boolean multiSelect) {
        if (this.chooserOpen == null) {
            this.chooserOpen = new GhidraFileChooser((Component)this.tool.getActiveWindow());
            this.chooserOpen.addFileFilter(ImporterUtilities.LOADABLE_FILES_FILTER);
            this.chooserOpen.addFileFilter(ImporterUtilities.CONTAINER_FILES_FILTER);
            this.chooserOpen.setSelectedFileFilter(GhidraFileFilter.ALL);
        }
        this.chooserOpen.setFileSelectionMode(GhidraFileChooserMode.FILES_ONLY);
        this.chooserOpen.setMultiSelectionEnabled(multiSelect);
        this.chooserOpen.setTitle(title);
        this.chooserOpen.setApproveButtonText(buttonText);
    }

    private void doOpenFilesystem(FSRL containerFSRL, Component parent, TaskMonitor monitor) {
        try {
            monitor.setMessage("Probing " + containerFSRL.getName() + " for filesystems");
            FileSystemRef ref = FileSystemService.getInstance().probeFileForFilesystem(containerFSRL, monitor, FileSystemProbeConflictResolver.GUI_PICKER);
            if (ref == null) {
                Msg.showWarn((Object)this, (Component)parent, (String)"Open Filesystem", (Object)("No filesystem provider for " + containerFSRL.getName()));
                return;
            }
            SystemUtilities.runSwingLater(() -> this.createNewFileSystemBrowser(ref, true));
        }
        catch (CancelledException | IOException e) {
            FSUtilities.displayException(this, parent, "Open Filesystem Error", "Error opening filesystem for " + containerFSRL.getName(), e);
        }
    }

    void openFileSystem() {
        SystemUtilities.runSwingLater(() -> this.doOpenFileSystem());
    }

    private void doOpenFileSystem() {
        Window parent = this.getTool().getActiveWindow();
        this.openChooser("Select Filesystem Container To Open", "Open", false);
        this.chooserOpen.setFileSelectionMode(GhidraFileChooserMode.FILES_AND_DIRECTORIES);
        File file = this.chooserOpen.getSelectedFile();
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            Msg.showInfo((Object)this, (Component)parent, (String)"Open File System Failed", (Object)("The specified file does not exist: " + file.getPath()));
            return;
        }
        if (FileUtilities.isEmpty((File)file)) {
            Msg.showInfo((Object)this, (Component)parent, (String)"Empty file", (Object)"The selected file is 0 bytes long, skipping.");
            return;
        }
        FSRL containerFSRL = FileSystemService.getInstance().getLocalFSRL(file);
        TaskLauncher.launchModal((String)"Open File System", monitor -> this.doOpenFilesystem(containerFSRL, parent, monitor));
    }

    @Override
    public void onFilesystemClose(GFileSystem fs) {
        Msg.info((Object)this, (Object)("File system " + fs.getFSRL() + " was closed! Closing browser window"));
        this.removeFileSystemBrowser(fs.getFSRL());
    }

    @Override
    public void onFilesystemRefChange(GFileSystem fs, FileSystemRefManager refManager) {
    }

    boolean hasProgramManager() {
        return this.tool.getService(ProgramManager.class) != null || FSBUtils.getRunningProgramManagerTools(this.getTool()).size() == 1;
    }

    FileSystemBrowserComponentProvider getProviderFor(FSRLRoot fsFSRL) {
        FileSystemBrowserComponentProvider provider = this.currentBrowsers.get(fsFSRL);
        if (provider == null) {
            Msg.info((Object)this, (Object)("Could not find browser for " + fsFSRL));
            return null;
        }
        return provider;
    }
}

