/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database;

import generic.jar.ResourceFile;
import generic.test.AbstractGenericTest;
import ghidra.app.cmd.data.CreateDataCmd;
import ghidra.app.cmd.disassemble.ArmDisassembleCommand;
import ghidra.app.cmd.disassemble.DisassembleCommand;
import ghidra.app.cmd.equate.SetEquateCmd;
import ghidra.app.cmd.function.CreateFunctionCmd;
import ghidra.app.cmd.label.AddLabelCmd;
import ghidra.app.cmd.label.CreateNamespacesCmd;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.SymbolPath;
import ghidra.docking.settings.Settings;
import ghidra.framework.Application;
import ghidra.framework.model.DomainObject;
import ghidra.framework.options.Options;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.data.ProgramDataTypeManager;
import ghidra.program.database.function.OverlappingFunctionException;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.data.AbstractStringDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.CharsetSettingsDefinition;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.TerminatedUnicodeDataType;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.model.lang.LanguageService;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Bookmark;
import ghidra.program.model.listing.BookmarkManager;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.GhidraClass;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Library;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.LocalVariableImpl;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.ParameterImpl;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.ProgramContext;
import ghidra.program.model.listing.ProgramFragment;
import ghidra.program.model.listing.ProgramModule;
import ghidra.program.model.listing.ReturnParameterImpl;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.program.model.util.IntPropertyMap;
import ghidra.program.model.util.ObjectPropertyMap;
import ghidra.program.model.util.PropertyMapManager;
import ghidra.program.model.util.StringPropertyMap;
import ghidra.program.util.DefaultLanguageService;
import ghidra.program.util.GhidraProgramUtilities;
import ghidra.test.AbstractGhidraHeadedIntegrationTest;
import ghidra.util.NumericUtilities;
import ghidra.util.Saveable;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ProgramBuilder {
    public static final String _ARM = "ARM:LE:32:v7";
    public static final String _AARCH64 = "AARCH64:LE:64:v8A";
    public static final String _X86 = "x86:LE:32:default";
    public static final String _X86_16_REAL_MODE = "x86:LE:16:Real Mode";
    public static final String _X64 = "x86:LE:64:default";
    public static final String _8051 = "8051:BE:16:default";
    public static final String _SPARC64 = "sparc:BE:64:default";
    public static final String _MIPS = "MIPS:BE:32:default";
    public static final String _MIPS_6432 = "MIPS:BE:64:64-32addr";
    public static final String _PPC_32 = "PowerPC:BE:32:default";
    public static final String _PPC_6432 = "PowerPC:BE:64:64-32addr";
    public static final String _TOY_BE = "Toy:BE:32:default";
    public static final String _TOY_BE_POSITIVE = "Toy:BE:32:posStack";
    public static final String _TOY_LE = "Toy:LE:32:default";
    public static final String _TOY_WORDSIZE2_BE = "Toy:BE:32:wordSize2";
    public static final String _TOY_WORDSIZE2_LE = "Toy:LE:32:wordSize2";
    public static final String _TOY64_BE = "Toy:BE:64:default";
    public static final String _TOY64_LE = "Toy:LE:64:default";
    public static final String _TOY = "Toy:BE:32:default";
    protected static final String _TOY_LANGUAGE_PREFIX = "Toy:";
    private static final Map<String, Language> LANGUAGE_CACHE = new HashMap<String, Language>();
    private ProgramDB program;
    private int transactionID;
    private int transactionCount = 0;

    public ProgramBuilder() throws Exception {
        this("Test Program", "Toy:BE:32:default");
    }

    public ProgramBuilder(String name, String languageName) throws Exception {
        this(name, languageName, null, null);
    }

    public ProgramBuilder(String name, String languageName, Object consumer) throws Exception {
        this(name, languageName, null, consumer);
    }

    public ProgramBuilder(String name, String languageName, String compilerSpecID, Object consumer) throws Exception {
        Language language = this.getLanguage(languageName);
        CompilerSpec compilerSpec = compilerSpecID == null ? language.getDefaultCompilerSpec() : language.getCompilerSpecByID(new CompilerSpecID(compilerSpecID));
        this.program = new ProgramDB(name, language, compilerSpec, consumer == null ? this : consumer);
        this.setAnalyzed(true);
        this.program.setTemporary(true);
    }

    public void analyze() {
        AutoAnalysisManager mgr = AutoAnalysisManager.getAnalysisManager((Program)this.program);
        this.startTransaction();
        mgr.reAnalyzeAll(this.program.getMemory().getLoadedAndInitializedAddressSet());
        mgr.startAnalysis(TaskMonitor.DUMMY, false);
        this.endTransaction();
        PluginTool analysisTool = mgr.getAnalysisTool();
        if (analysisTool != null) {
            AbstractGhidraHeadedIntegrationTest.waitForBusyTool(analysisTool);
        }
    }

    public ProgramDB getProgram() {
        this.program.flushEvents();
        return this.program;
    }

    public Language getLanguage() {
        return this.program.getLanguage();
    }

    public CompilerSpec getCompilerSpec() {
        return this.program.getCompilerSpec();
    }

    public Register getRegister(String regName) {
        return this.program.getRegister(regName);
    }

    public Address addr(long offset) {
        AddressFactory addressFactory = this.program.getAddressFactory();
        return addressFactory.getDefaultAddressSpace().getAddress(offset);
    }

    public Address addr(String addressString) {
        AddressFactory addressFactory = this.program.getAddressFactory();
        Address addr = addressFactory.getAddress(addressString);
        if (addr == null) {
            throw new IllegalArgumentException("Failed to parse address string: " + addressString);
        }
        return addr;
    }

    public void dispose() {
        if (this.program.isUsedBy((Object)this)) {
            this.program.release((Object)this);
        }
    }

    public void setName(String name) {
        this.startTransaction();
        try {
            this.program.setName(name);
        }
        finally {
            this.endTransaction();
        }
    }

    public void withTransaction(Runnable r) {
        this.startTransaction();
        try {
            r.run();
        }
        finally {
            this.endTransaction();
        }
    }

    protected void startTransaction() {
        if (this.transactionCount++ == 0) {
            this.transactionID = this.program.startTransaction("Test Transaction");
        }
    }

    protected void endTransaction() {
        if (--this.transactionCount == 0) {
            this.program.endTransaction(this.transactionID, true);
        }
    }

    private Language getLanguage(String languageName) throws Exception {
        Language language = LANGUAGE_CACHE.get(languageName);
        if (language != null) {
            return language;
        }
        ResourceFile ldefFile = null;
        if (_X86.equals(languageName) || _X64.equals(languageName)) {
            ldefFile = Application.getModuleDataFile((String)"x86", (String)"languages/x86.ldefs");
        } else if (_X86_16_REAL_MODE.equals(languageName)) {
            ldefFile = Application.getModuleDataFile((String)"x86", (String)"languages/x86.ldefs");
        } else if (_8051.equals(languageName)) {
            ldefFile = Application.getModuleDataFile((String)"8051", (String)"languages/8051.ldefs");
        } else if (_SPARC64.equals(languageName)) {
            ldefFile = Application.getModuleDataFile((String)"Sparc", (String)"languages/SparcV9.ldefs");
        } else if (_ARM.equals(languageName)) {
            ldefFile = Application.getModuleDataFile((String)"ARM", (String)"languages/ARM.ldefs");
        } else if (_AARCH64.equals(languageName)) {
            ldefFile = Application.getModuleDataFile((String)"AARCH64", (String)"languages/AARCH64.ldefs");
        } else if (_MIPS.equals(languageName) || _MIPS_6432.equals(languageName)) {
            ldefFile = Application.getModuleDataFile((String)"MIPS", (String)"languages/mips.ldefs");
        } else if (languageName.startsWith(_TOY_LANGUAGE_PREFIX)) {
            ldefFile = Application.getModuleDataFile((String)"Toy", (String)"languages/toy.ldefs");
        } else if (_PPC_32.equals(languageName) || _PPC_6432.equals(languageName)) {
            ldefFile = Application.getModuleDataFile((String)"PowerPC", (String)"languages/ppc.ldefs");
        }
        if (ldefFile != null) {
            LanguageService languageService = DefaultLanguageService.getLanguageService((ResourceFile)ldefFile);
            language = languageService.getLanguage(new LanguageID(languageName));
            LANGUAGE_CACHE.put(languageName, language);
            return language;
        }
        throw new LanguageNotFoundException("Unsupported test language: " + languageName);
    }

    public void setRecordChanges(boolean enabled) {
        AbstractGenericTest.setInstanceField((String)"recordChanges", (Object)this.program, (Object)enabled);
    }

    public void setAnalyzed(boolean analyzed) {
        GhidraProgramUtilities.setAnalyzedFlag((Program)this.program, analyzed);
    }

    public MemoryBlock createMemory(String name, String address, int size) {
        return this.createMemory(name, address, size, null);
    }

    public MemoryBlock createMemory(String name, String address, int size, String comment) {
        return this.createMemory(name, address, size, comment, (byte)0);
    }

    public MemoryBlock createMemory(String name, String address, int size, String comment, byte initialValue) {
        this.startTransaction();
        Address startAddress = this.addr(address);
        Memory memory = this.program.getMemory();
        MemoryBlock block = null;
        try {
            block = memory.createInitializedBlock(name, startAddress, (long)size, initialValue, TaskMonitorAdapter.DUMMY_MONITOR, false);
            block.setComment(comment);
        }
        catch (CancelledException cancelledException) {
        }
        catch (Exception e) {
            throw new RuntimeException("Exception building memory", e);
        }
        this.endTransaction();
        return block;
    }

    public MemoryBlock createUninitializedMemory(String name, String address, int size) {
        this.startTransaction();
        Address startAddress = this.addr(address);
        Memory memory = this.program.getMemory();
        MemoryBlock block = null;
        try {
            block = memory.createUninitializedBlock(name, startAddress, (long)size, false);
        }
        catch (Exception e) {
            throw new RuntimeException("Exception building memory", e);
        }
        this.endTransaction();
        return block;
    }

    public MemoryBlock createOverlayMemory(String name, String address, int size) {
        this.startTransaction();
        try {
            MemoryBlock memoryBlock = this.program.getMemory().createInitializedBlock(name, this.addr(address), (long)size, (byte)0, TaskMonitor.DUMMY, true);
            return memoryBlock;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception building memory", e);
        }
        finally {
            this.endTransaction();
        }
    }

    public void setBytes(String address, String byteString) throws Exception {
        byte[] bytes = NumericUtilities.convertStringToBytes((String)byteString);
        this.setBytes(address, bytes, false);
    }

    public void setBytes(String address, String byteString, boolean disassemble) throws Exception {
        byte[] bytes = NumericUtilities.convertStringToBytes((String)byteString);
        this.setBytes(address, bytes, disassemble);
    }

    public void setBytes(String stringAddress, byte[] bytes) throws Exception {
        this.setBytes(stringAddress, bytes, false);
    }

    public void setBytes(String stringAddress, byte[] bytes, boolean disassemble) throws Exception {
        Address address = this.addr(stringAddress);
        this.startTransaction();
        MemoryBlock block = this.program.getMemory().getBlock(address);
        if (block == null) {
            this.createMemory("Block_" + stringAddress, stringAddress, bytes.length);
        }
        Memory memory = this.program.getMemory();
        memory.setBytes(address, bytes);
        this.endTransaction();
        if (disassemble) {
            this.disassemble(stringAddress, bytes.length);
        }
    }

    public void setRead(MemoryBlock block, boolean r) {
        this.startTransaction();
        block.setRead(r);
    }

    public void setWrite(MemoryBlock block, boolean w) {
        this.startTransaction();
        block.setWrite(w);
    }

    public void setExecute(MemoryBlock block, boolean e) {
        this.startTransaction();
        block.setExecute(e);
    }

    public void disassemble(String addressString, int length) {
        this.disassemble(addressString, length, true);
    }

    public void disassemble(String addressString, int length, boolean followFlows) {
        this.startTransaction();
        Address address = this.addr(addressString);
        AddressSet addresses = new AddressSet(address, address.add((long)(length - 1)));
        DisassembleCommand cmd = new DisassembleCommand((AddressSetView)addresses, (AddressSetView)addresses, followFlows);
        cmd.applyTo((DomainObject)this.program);
        AutoAnalysisManager.getAnalysisManager((Program)this.program).startAnalysis(TaskMonitor.DUMMY);
        this.endTransaction();
    }

    public void disassemble(AddressSetView set) {
        this.startTransaction();
        DisassembleCommand cmd = new DisassembleCommand(set, set, true);
        cmd.applyTo((DomainObject)this.program);
        AutoAnalysisManager.getAnalysisManager((Program)this.program).startAnalysis(TaskMonitor.DUMMY);
        this.endTransaction();
    }

    public void disassemble(AddressSetView set, boolean followFlows) {
        this.startTransaction();
        DisassembleCommand cmd = new DisassembleCommand(set, set, followFlows);
        cmd.applyTo((DomainObject)this.program);
        AutoAnalysisManager.getAnalysisManager((Program)this.program).startAnalysis(TaskMonitor.DUMMY);
        this.endTransaction();
    }

    public void disassembleArm(String addressString, int length, boolean thumb) {
        this.startTransaction();
        Address address = this.addr(addressString);
        ArmDisassembleCommand cmd = new ArmDisassembleCommand(address, (AddressSetView)new AddressSet(address, address.add((long)(length - 1))), true);
        cmd.applyTo((DomainObject)this.program);
        AutoAnalysisManager.getAnalysisManager((Program)this.program).startAnalysis(TaskMonitor.DUMMY);
        this.endTransaction();
    }

    public void clearCodeUnits(String startAddressString, String endAddressString, boolean clearContext) throws Exception {
        this.startTransaction();
        Address startAddress = this.addr(startAddressString);
        Address endAddress = this.addr(endAddressString);
        Listing listing = this.program.getListing();
        listing.clearCodeUnits(startAddress, endAddress, clearContext);
        this.endTransaction();
    }

    public Symbol createLabel(String addressString, String name) {
        this.startTransaction();
        Address address = this.addr(addressString);
        AddLabelCmd cmd = new AddLabelCmd(address, name, SourceType.USER_DEFINED);
        cmd.applyTo((DomainObject)this.program);
        this.endTransaction();
        return cmd.getSymbol();
    }

    public Symbol createLabel(String addressString, String name, String namespace) {
        this.startTransaction();
        Address address = this.addr(addressString);
        Namespace ns = this.getNamespace(namespace, address);
        AddLabelCmd cmd = new AddLabelCmd(address, name, ns, SourceType.USER_DEFINED);
        cmd.applyTo((DomainObject)this.program);
        this.endTransaction();
        return cmd.getSymbol();
    }

    public Function createFunction(String addressString) {
        this.startTransaction();
        Address address = this.addr(addressString);
        CreateFunctionCmd cmd = new CreateFunctionCmd(address);
        cmd.applyTo((DomainObject)this.program);
        this.endTransaction();
        return cmd.getFunction();
    }

    public void addFunctionVariable(Function f, Variable v) throws DuplicateNameException, InvalidInputException {
        this.startTransaction();
        try {
            f.addLocalVariable(v, SourceType.USER_DEFINED);
        }
        finally {
            this.endTransaction();
        }
    }

    public Function createEmptyFunction(String name, String address, int size, DataType returnType, Parameter ... params) throws Exception, OverlappingFunctionException {
        return this.createEmptyFunction(name, null, null, false, address, size, returnType, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Function createEmptyFunction(String name, String address, int size, DataType returnType, boolean varargs, boolean inline, boolean noReturn, Parameter ... params) throws Exception, OverlappingFunctionException {
        this.startTransaction();
        try {
            Function fun = this.createEmptyFunction(name, null, null, false, address, size, returnType, params);
            fun.setVarArgs(varargs);
            fun.setInline(inline);
            fun.setNoReturn(noReturn);
            Function function = fun;
            return function;
        }
        finally {
            this.endTransaction();
        }
    }

    public Function createEmptyFunction(String name, String namespace, String address, int bodySize, DataType returnType, Parameter ... params) throws Exception {
        return this.createEmptyFunction(name, namespace, null, false, address, bodySize, returnType, params);
    }

    public Function createEmptyFunction(String name, String namespace, String callingConventionName, boolean customStorage, String address, int bodySize, DataType returnType, Parameter ... params) throws Exception {
        this.startTransaction();
        Address entryPoint = this.addr(address);
        Address endAddress = entryPoint.add((long)(bodySize - 1));
        AddressSet body = new AddressSet(entryPoint, endAddress);
        FunctionManager functionManager = this.program.getFunctionManager();
        Function function = null;
        if (namespace == null) {
            function = functionManager.createFunction(name, entryPoint, (AddressSetView)body, SourceType.USER_DEFINED);
        } else {
            Namespace ns = this.getNamespace(namespace);
            function = functionManager.createFunction(name, ns, entryPoint, (AddressSetView)body, SourceType.USER_DEFINED);
        }
        if (params == null) {
            params = new Parameter[]{};
        }
        ReturnParameterImpl returnVar = returnType != null ? new ReturnParameterImpl(returnType, (Program)this.program) : function.getReturn();
        function.updateFunction(callingConventionName, (Variable)returnVar, customStorage ? Function.FunctionUpdateType.CUSTOM_STORAGE : Function.FunctionUpdateType.DYNAMIC_STORAGE_FORMAL_PARAMS, false, SourceType.USER_DEFINED, (Variable[])params);
        this.endTransaction();
        return function;
    }

    public Function createEmptyFunction(String name, String namespace, String callingConventionName, String address, int size, DataType returnType, DataType ... paramTypes) throws Exception {
        ParameterImpl[] params = new ParameterImpl[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            params[i] = new ParameterImpl(null, paramTypes[i], (Program)this.program);
        }
        return this.createEmptyFunction(name, namespace, callingConventionName, false, address, size, returnType, (Parameter[])params);
    }

    public Library createLibrary(String libraryName) throws DuplicateNameException, InvalidInputException {
        return this.createLibrary(libraryName, SourceType.USER_DEFINED);
    }

    public Library createLibrary(String libraryName, SourceType type) throws DuplicateNameException, InvalidInputException {
        SymbolTable symbolTable = this.program.getSymbolTable();
        return symbolTable.createExternalLibrary(libraryName, type);
    }

    public Namespace createNamespace(String namespace) {
        return this.createNamespace(namespace, SourceType.USER_DEFINED);
    }

    public Namespace getNamespace(String namespace) {
        if (namespace == null) {
            return null;
        }
        try {
            return NamespaceUtils.createNamespaceHierarchy((String)namespace, null, (Program)this.program, (SourceType)SourceType.USER_DEFINED);
        }
        catch (InvalidInputException e) {
            throw new RuntimeException(e);
        }
    }

    public Namespace getNamespace(String namespace, Address address) {
        if (namespace == null) {
            return null;
        }
        try {
            return NamespaceUtils.createNamespaceHierarchy((String)namespace, null, (Program)this.program, (Address)address, (SourceType)SourceType.USER_DEFINED);
        }
        catch (InvalidInputException e) {
            throw new RuntimeException(e);
        }
    }

    public Namespace createNamespace(String namespace, SourceType type) {
        return this.createNamespace(namespace, null, type);
    }

    public Namespace createNamespace(String namespace, String parentNamespace, SourceType type) {
        this.startTransaction();
        Namespace ns = this.getNamespace(parentNamespace);
        CreateNamespacesCmd cmd = new CreateNamespacesCmd(namespace, ns, type);
        cmd.applyTo((DomainObject)this.program);
        this.endTransaction();
        return cmd.getNamespace();
    }

    public Namespace createClassNamespace(String name, String parentNamespace, SourceType type) throws Exception {
        this.startTransaction();
        Namespace ns = this.getNamespace(parentNamespace);
        SymbolTable symbolTable = this.program.getSymbolTable();
        GhidraClass c = symbolTable.createClass(ns, name, SourceType.USER_DEFINED);
        this.endTransaction();
        return c;
    }

    public void applyDataType(String addressString, DataType dt) {
        this.applyDataType(addressString, dt, 1);
    }

    public void applyDataType(String addressString, DataType dt, int n) {
        this.startTransaction();
        Address address = this.addr(addressString);
        for (int i = 0; i < n; ++i) {
            CreateDataCmd cmd = new CreateDataCmd(address, dt);
            if (!cmd.applyTo((DomainObject)this.program)) {
                throw new AssertException("Could not apply data at address " + address + ". " + cmd.getStatusMsg());
            }
            address = address.add((long)dt.getLength());
        }
        this.endTransaction();
    }

    public void applyStringDataType(String addressString, AbstractStringDataType dt, int n) {
        Address address = this.addr(addressString);
        int previousDataLength = 0;
        this.startTransaction();
        try {
            for (int i = 0; i < n; ++i) {
                address = address.addNoWrap((long)previousDataLength);
                Data newStringInstance = DataUtilities.createData((Program)this.program, (Address)address, (DataType)dt, (int)-1, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_SINGLE_DATA);
                previousDataLength = newStringInstance.getLength();
            }
        }
        catch (CodeUnitInsertionException e) {
            throw new AssertException("Could not apply string data type at address " + address, (Throwable)e);
        }
        catch (AddressOverflowException e) {
            throw new AssertException(e.getMessage());
        }
        finally {
            this.endTransaction();
        }
    }

    public void deleteReference(Reference reference) {
        this.startTransaction();
        try {
            ReferenceManager refMgr = this.program.getReferenceManager();
            refMgr.delete(reference);
        }
        finally {
            this.endTransaction();
        }
    }

    public Reference createMemoryReadReference(String fromAddress, String toAddress) {
        return this.createMemoryReference(fromAddress, toAddress, RefType.READ, SourceType.USER_DEFINED);
    }

    public Reference createMemoryCallReference(String fromAddress, String toAddress) {
        return this.createMemoryReference(fromAddress, toAddress, (RefType)RefType.UNCONDITIONAL_CALL, SourceType.USER_DEFINED);
    }

    public Reference createMemoryJumpReference(String fromAddress, String toAddress) {
        return this.createMemoryReference(fromAddress, toAddress, (RefType)RefType.UNCONDITIONAL_JUMP, SourceType.USER_DEFINED);
    }

    public Reference createMemoryReference(String fromAddress, String toAddress, RefType refType, SourceType sourceType) {
        return this.createMemoryReference(fromAddress, toAddress, refType, sourceType, 0);
    }

    public Reference createMemoryReference(String fromAddress, String toAddress, RefType refType, SourceType sourceType, int opIndex) {
        this.startTransaction();
        ReferenceManager refManager = this.program.getReferenceManager();
        Reference ref = refManager.addMemoryReference(this.addr(fromAddress), this.addr(toAddress), refType, sourceType, opIndex);
        this.endTransaction();
        return ref;
    }

    public Reference createOffsetMemReference(String fromAddress, String toAddress, int offset, RefType refType, SourceType sourceType, int opIndex) {
        this.startTransaction();
        ReferenceManager refManager = this.program.getReferenceManager();
        Reference ref = refManager.addOffsetMemReference(this.addr(fromAddress), this.addr(toAddress), (long)offset, refType, sourceType, opIndex);
        this.endTransaction();
        return ref;
    }

    public Reference createStackReference(String fromAddress, RefType refType, int stackOffset, SourceType sourceType, int opIndex) {
        this.startTransaction();
        ReferenceManager refManager = this.program.getReferenceManager();
        Reference ref = refManager.addStackReference(this.addr(fromAddress), opIndex, stackOffset, refType, sourceType);
        this.endTransaction();
        return ref;
    }

    public Reference createRegisterReference(String fromAddress, String registerName, int opIndex) {
        return this.createRegisterReference(fromAddress, RefType.DATA, registerName, SourceType.USER_DEFINED, opIndex);
    }

    public Reference createRegisterReference(String fromAddress, RefType refType, String registerName, SourceType sourceType, int opIndex) {
        this.startTransaction();
        ReferenceManager refManager = this.program.getReferenceManager();
        Register register = this.program.getRegister(registerName);
        Reference ref = refManager.addRegisterReference(this.addr(fromAddress), opIndex, register, refType, sourceType);
        this.endTransaction();
        return ref;
    }

    public Symbol createEntryPoint(String addressString, String name) throws DuplicateNameException, InvalidInputException {
        this.startTransaction();
        SymbolTable symbolTable = this.program.getSymbolTable();
        symbolTable.addExternalEntryPoint(this.addr(addressString));
        Symbol[] symbols = symbolTable.getSymbols(this.addr(addressString));
        symbols[0].setName(name, SourceType.ANALYSIS);
        this.endTransaction();
        return symbols[0];
    }

    public Bookmark createBookmark(String address, String bookmarkType, String category, String comment) {
        this.startTransaction();
        BookmarkManager bookMgr = this.program.getBookmarkManager();
        Address addr = this.addr(address);
        Bookmark bm = bookMgr.setBookmark(addr, bookmarkType, category, comment);
        this.endTransaction();
        return bm;
    }

    public void createEncodedString(String address, String string, Charset encoding, boolean nullTerminate) throws Exception {
        byte[] bytes = string.getBytes(encoding);
        if (encoding == StandardCharsets.US_ASCII || encoding == StandardCharsets.UTF_8) {
            if (nullTerminate) {
                bytes = Arrays.copyOf(bytes, bytes.length + 1);
            }
            this.setBytes(address, bytes);
            this.applyDataType(address, (DataType)new StringDataType(), 1);
        } else if (encoding == StandardCharsets.UTF_16BE || encoding == StandardCharsets.UTF_16LE) {
            if (nullTerminate) {
                bytes = Arrays.copyOf(bytes, bytes.length + 2);
                this.setBytes(address, bytes);
                this.applyDataType(address, (DataType)new TerminatedUnicodeDataType(), 1);
            } else {
                this.setBytes(address, bytes);
            }
        } else {
            this.setBytes(address, bytes);
        }
    }

    public Data createString(String address, String string, Charset charset, boolean nullTerminate, AbstractStringDataType dataType) throws Exception {
        if (nullTerminate) {
            string = (String)string + "\u0000";
        }
        byte[] bytes = ((String)string).getBytes(charset);
        return this.createString(address, bytes, charset, dataType);
    }

    public Data createString(String address, byte[] stringBytes, Charset charset, AbstractStringDataType dataType) throws Exception {
        Address addr = this.addr(address);
        this.setBytes(address, stringBytes);
        if (dataType != null) {
            this.startTransaction();
            Data data = DataUtilities.createData((Program)this.program, (Address)addr, (DataType)dataType, (int)stringBytes.length, (boolean)false, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CLEAR_ALL_UNDEFINED_CONFLICT_DATA);
            CharsetSettingsDefinition.CHARSET.setCharset((Settings)data, charset.name());
            this.endTransaction();
            return data;
        }
        return null;
    }

    public void setProperty(String name, Object value) {
        this.startTransaction();
        Options options = this.program.getOptions("Program Information");
        options.putObject(name, value);
        this.endTransaction();
    }

    public void setAnalysisEnabled(String name, boolean enabled) {
        this.startTransaction();
        Options options = this.program.getOptions("Analyzers");
        options.setBoolean(name, enabled);
        this.endTransaction();
    }

    public void addDataType(DataType dt) {
        this.startTransaction();
        ProgramDataTypeManager dtm = this.program.getDataTypeManager();
        dtm.addDataType(dt, DataTypeConflictHandler.REPLACE_HANDLER);
        this.endTransaction();
    }

    public void addCategory(CategoryPath path) {
        this.startTransaction();
        ProgramDataTypeManager dtm = this.program.getDataTypeManager();
        dtm.createCategory(path);
        this.endTransaction();
    }

    public void createProgramTree(String treeName) throws Exception {
        this.startTransaction();
        this.program.getListing().createRootModule(treeName);
        this.endTransaction();
    }

    public void createFragment(String treeName, String modulePath, String fragmentName, String startAddr, String endAddr) throws Exception {
        this.startTransaction();
        ProgramModule module = this.getOrCreateModule(treeName, modulePath);
        ProgramFragment fragment = module.createFragment(fragmentName);
        fragment.move(this.addr(startAddr), this.addr(endAddr));
        this.endTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgramModule getOrCreateModule(String treeName, String modulePath) throws Exception {
        ProgramModule m;
        this.startTransaction();
        try {
            ProgramModule rootModule = this.program.getListing().getRootModule(treeName);
            if (modulePath == null || modulePath.length() == 0) {
                ProgramModule programModule = rootModule;
                return programModule;
            }
            String[] modules = modulePath.split("\\.");
            m = rootModule;
            for (String moduleName : modules) {
                m = this.getOrCreateChildModule(m, moduleName);
            }
        }
        finally {
            this.endTransaction();
        }
        return m;
    }

    private ProgramModule getOrCreateChildModule(ProgramModule m, String moduleName) throws Exception {
        Group[] children;
        for (Group group : children = m.getChildren()) {
            if (!group.getName().equals(moduleName)) continue;
            return (ProgramModule)group;
        }
        return m.createModule(moduleName);
    }

    public Equate createEquate(String address, String name, long value, int opIndex) {
        this.startTransaction();
        SetEquateCmd cmd = new SetEquateCmd(name, this.addr(address), opIndex, value);
        cmd.applyTo((DomainObject)this.program);
        Equate equate = cmd.getEquate();
        this.endTransaction();
        return equate;
    }

    public void createComment(String address, String comment, int commentType) {
        this.startTransaction();
        Listing listing = this.program.getListing();
        listing.setComment(this.addr(address), commentType, comment);
        this.endTransaction();
    }

    public void createFunctionComment(String entryPointAddress, String comment) {
        this.startTransaction();
        FunctionManager functionManager = this.program.getFunctionManager();
        Address addr = this.addr(entryPointAddress);
        Function function = functionManager.getFunctionAt(addr);
        function.setComment(comment);
        this.endTransaction();
    }

    public void setFallthrough(String from, String to) {
        this.startTransaction();
        Listing listing = this.program.getListing();
        Instruction inst = listing.getInstructionAt(this.addr(from));
        inst.setFallThrough(this.addr(to));
        this.endTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createExternalLibraries(String ... libraryNames) throws Exception {
        this.startTransaction();
        try {
            SymbolTable symbolTable = this.program.getSymbolTable();
            for (String libraryName : libraryNames) {
                symbolTable.createExternalLibrary(libraryName, SourceType.IMPORTED);
            }
        }
        finally {
            this.endTransaction();
        }
    }

    public void bindExternalLibrary(String libraryName, String pathname) throws Exception {
        this.startTransaction();
        try {
            this.program.getExternalManager().setExternalPath(libraryName, pathname, true);
        }
        finally {
            this.endTransaction();
        }
    }

    public void createExternalReference(String fromAddress, String libraryName, String externalLabel, int opIndex) throws Exception {
        this.createExternalReference(fromAddress, libraryName, externalLabel, null, opIndex, RefType.DATA, SourceType.IMPORTED);
    }

    public void createExternalReference(String fromAddress, String libraryName, String externalLabel, String extAddress, int opIndex) throws Exception {
        this.createExternalReference(fromAddress, libraryName, externalLabel, extAddress, opIndex, RefType.DATA, SourceType.IMPORTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createExternalReference(String fromAddress, String libraryName, String externalLabel, String extAddress, int opIndex, RefType refType, SourceType sourceType) throws Exception {
        this.startTransaction();
        try {
            ReferenceManager refMgr = this.program.getReferenceManager();
            Address eAddress = extAddress == null ? null : this.addr(extAddress);
            SymbolTable symTable = this.program.getSymbolTable();
            ExternalManager extMgr = this.program.getExternalManager();
            Library namespace = extMgr.addExternalLibraryName(libraryName, sourceType);
            if (externalLabel != null && externalLabel.indexOf("::") > 0) {
                SymbolPath symPath = new SymbolPath(externalLabel);
                externalLabel = symPath.getName();
                namespace = NamespaceUtils.createNamespaceHierarchy((String)symPath.getParentPath(), (Namespace)namespace, (Program)this.program, null, (SourceType)sourceType);
            }
            Reference ref = refMgr.addExternalReference(this.addr(fromAddress), libraryName, externalLabel, eAddress, sourceType, opIndex, refType);
            if (!(namespace instanceof Library)) {
                Symbol s = symTable.getSymbol(ref);
                s.setNamespace((Namespace)namespace);
            }
        }
        finally {
            this.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalLocation createExternalFunction(String extAddress, String libName, String functionName) throws Exception {
        this.startTransaction();
        try {
            ExternalManager em = this.program.getExternalManager();
            Address eAddress = extAddress == null ? null : this.addr(extAddress);
            ExternalLocation externalLocation = em.addExtFunction(libName, functionName, eAddress, SourceType.IMPORTED);
            return externalLocation;
        }
        finally {
            this.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalLocation createExternalFunction(String extAddress, String libName, String functionName, String originalName) throws Exception {
        this.startTransaction();
        try {
            ExternalManager em = this.program.getExternalManager();
            Address eAddress = extAddress == null ? null : this.addr(extAddress);
            ExternalLocation extLoc = em.addExtFunction("<EXTERNAL>", originalName, eAddress, SourceType.IMPORTED);
            Library lib = em.addExternalLibraryName(libName, SourceType.IMPORTED);
            extLoc.setName((Namespace)lib, functionName, SourceType.IMPORTED);
            ExternalLocation externalLocation = extLoc;
            return externalLocation;
        }
        finally {
            this.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createLocalVariable(Function function, String name, DataType dt, int stackOffset) throws Exception {
        this.startTransaction();
        try {
            LocalVariableImpl variable = new LocalVariableImpl(name, dt, stackOffset, (Program)this.program);
            function.addLocalVariable((Variable)variable, SourceType.USER_DEFINED);
        }
        finally {
            this.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRegisterValue(String registerName, String startAddress, String endAddress, long value) throws Exception {
        this.startTransaction();
        try {
            Register register = this.program.getRegister(registerName);
            ProgramContext programContext = this.program.getProgramContext();
            programContext.setValue(register, this.addr(startAddress), this.addr(endAddress), BigInteger.valueOf(value));
        }
        finally {
            this.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIntProperty(String address, String propertyName, int value) throws Exception {
        this.startTransaction();
        try {
            PropertyMapManager pm = this.program.getUsrPropertyManager();
            IntPropertyMap propertyMap = pm.getIntPropertyMap(propertyName);
            if (propertyMap == null) {
                propertyMap = pm.createIntPropertyMap(propertyName);
            }
            propertyMap.add(this.addr(address), value);
        }
        finally {
            this.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStringProperty(String address, String propertyName, String value) throws Exception {
        this.startTransaction();
        try {
            PropertyMapManager pm = this.program.getUsrPropertyManager();
            StringPropertyMap propertyMap = pm.getStringPropertyMap(propertyName);
            if (propertyMap == null) {
                propertyMap = pm.createStringPropertyMap(propertyName);
            }
            propertyMap.add(this.addr(address), value);
        }
        finally {
            this.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObjectProperty(String address, String propertyName, Saveable value) throws Exception {
        this.startTransaction();
        try {
            PropertyMapManager pm = this.program.getUsrPropertyManager();
            ObjectPropertyMap propertyMap = pm.getObjectPropertyMap(propertyName);
            if (propertyMap == null) {
                propertyMap = pm.createObjectPropertyMap(propertyName, value.getClass());
            }
            propertyMap.add(this.addr(address), value);
        }
        finally {
            this.endTransaction();
        }
    }

    public void setChanged(boolean changed) {
        this.program.setChanged(changed);
    }
}

