/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.util;

import ghidra.app.services.ProgramManager;
import ghidra.framework.options.Options;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Program;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class GhidraProgramUtilities {
    private GhidraProgramUtilities() {
    }

    public static Program getCurrentProgram(PluginTool tool) {
        ProgramManager pmService = (ProgramManager)tool.getService(ProgramManager.class);
        return pmService == null ? null : pmService.getCurrentProgram();
    }

    public static boolean shouldAskToAnalyze(Program program) {
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MMM-dd");
            Date analysisStartDate = format.parse("2007-Jan-01");
            Date creationDate = program.getCreationDate();
            if (creationDate.compareTo(analysisStartDate) < 0) {
                return false;
            }
        }
        catch (ParseException format) {
            // empty catch block
        }
        Options options = program.getOptions("Program Information");
        return !options.contains("Analyzed");
    }

    public static void removeAnalyzedFlag(Program program) {
        int transactionID = program.startTransaction("Analyzed");
        try {
            Options options = program.getOptions("Program Information");
            options.removeOption("Analyzed");
        }
        finally {
            program.endTransaction(transactionID, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAnalyzedFlag(Program program, boolean analyzed) {
        Options options = program.getOptions("Program Information");
        if (analyzed && !options.isRegistered("Analyzed")) {
            options.registerOption("Analyzed", (Object)false, null, "Indicates if program has been analyzed");
        }
        int transactionID = program.startTransaction("Analyzed");
        try {
            options.setBoolean("Analyzed", analyzed);
        }
        finally {
            program.endTransaction(transactionID, true);
        }
    }
}

