/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.search.memory;

import ghidra.util.datastruct.Accumulator;
import ghidra.util.datastruct.ListAccumulator;
import ghidra.util.search.memory.MemSearchResult;
import ghidra.util.search.memory.MemorySearchAlgorithm;
import ghidra.util.search.memory.SearchInfo;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public class MemSearcherTask
extends Task {
    private MemorySearchAlgorithm algorithm;
    private List<MemSearchResult> results;

    public MemSearcherTask(SearchInfo searchInfo, MemorySearchAlgorithm algorithm) {
        super("Search Memory", true, true, false);
        this.algorithm = algorithm;
        this.addTaskListener(searchInfo.getListener());
    }

    public void run(TaskMonitor monitor) {
        ListAccumulator accumulator = new ListAccumulator();
        this.algorithm.search((Accumulator<MemSearchResult>)accumulator, monitor);
        this.results = accumulator.asList();
    }

    public List<MemSearchResult> getMatchingAddresses() {
        return this.results;
    }
}

