/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.finder;

import java.io.PrintStream;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfsexplorer.Util;

public class FXInfo
implements StructElements {
    public static final int STRUCTSIZE = 16;
    private final byte[] fdIconID = new byte[2];
    private final byte[] fdReserved = new byte[6];
    private final byte[] fdScript = new byte[1];
    private final byte[] fdXFlags = new byte[1];
    private final byte[] fdComment = new byte[2];
    private final byte[] fdPutAway = new byte[4];

    public FXInfo(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.fdIconID, 0, 2);
        System.arraycopy(data, offset + 2, this.fdReserved, 0, 6);
        System.arraycopy(data, offset + 8, this.fdScript, 0, 1);
        System.arraycopy(data, offset + 9, this.fdXFlags, 0, 1);
        System.arraycopy(data, offset + 10, this.fdComment, 0, 2);
        System.arraycopy(data, offset + 12, this.fdPutAway, 0, 4);
    }

    public static int length() {
        return 16;
    }

    public short getFdIconID() {
        return Util.readShortBE((byte[])this.fdIconID);
    }

    public short[] getFdReserved() {
        return Util.readShortArrayBE((byte[])this.fdReserved);
    }

    public byte getFdScript() {
        return Util.readByteBE((byte[])this.fdScript);
    }

    public byte getFdXFlags() {
        return Util.readByteBE((byte[])this.fdXFlags);
    }

    public short getFdComment() {
        return Util.readShortBE((byte[])this.fdComment);
    }

    public int getFdPutAway() {
        return Util.readIntBE((byte[])this.fdPutAway);
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " fdIconID: " + this.getFdIconID());
        ps.println(prefix + " fdReserved: " + this.getFdReserved());
        ps.println(prefix + " fdScript: " + this.getFdScript());
        ps.println(prefix + " fdXFlags: " + this.getFdXFlags());
        ps.println(prefix + " fdComment: " + this.getFdComment());
        ps.println(prefix + " fdPutAway: " + this.getFdPutAway());
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "FXInfo:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[16];
        int offset = 0;
        System.arraycopy(this.fdIconID, 0, result, offset, this.fdIconID.length);
        System.arraycopy(this.fdReserved, 0, result, offset += this.fdIconID.length, this.fdReserved.length);
        System.arraycopy(this.fdScript, 0, result, offset += this.fdReserved.length, this.fdScript.length);
        System.arraycopy(this.fdXFlags, 0, result, offset += this.fdScript.length, this.fdXFlags.length);
        System.arraycopy(this.fdComment, 0, result, offset += this.fdXFlags.length, this.fdComment.length);
        System.arraycopy(this.fdPutAway, 0, result, offset += this.fdComment.length, this.fdPutAway.length);
        offset += this.fdPutAway.length;
        return result;
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(FXInfo.class.getSimpleName());
        db.addSIntBE("fdIconID", this.fdIconID);
        db.addIntArray("fdReserved", this.fdReserved, BITS_16, UNSIGNED, BIG_ENDIAN);
        db.addSIntBE("fdScript", this.fdScript);
        db.addUIntBE("fdXFlags", this.fdXFlags);
        db.addSIntBE("fdComment", this.fdComment);
        db.addSIntBE("fdPutAway", this.fdPutAway);
        return db.getResult();
    }
}

