/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.hfscommon;

import java.io.PrintStream;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.types.hfs.ExtDescriptor;
import org.catacombae.hfsexplorer.types.hfsplus.HFSPlusExtentDescriptor;

public abstract class CommonHFSExtentDescriptor
implements StructElements {
    public abstract long getStartBlock();

    public abstract long getBlockCount();

    public abstract void print(PrintStream var1, String var2);

    public static CommonHFSExtentDescriptor create(HFSPlusExtentDescriptor hped) {
        return new HFSPlusImplementation(hped);
    }

    public static CommonHFSExtentDescriptor create(ExtDescriptor hped) {
        return new HFSImplementation(hped);
    }

    public static class HFSImplementation
    extends CommonHFSExtentDescriptor {
        private final ExtDescriptor hped;

        public HFSImplementation(ExtDescriptor hped) {
            this.hped = hped;
        }

        public long getStartBlock() {
            return Util.unsign((short)this.hped.getXdrStABN());
        }

        public long getBlockCount() {
            return Util.unsign((short)this.hped.getXdrNumABlks());
        }

        public void print(PrintStream ps, String prefix) {
            this.hped.print(ps, prefix);
        }

        public Dictionary getStructElements() {
            return this.hped.getStructElements();
        }
    }

    public static class HFSPlusImplementation
    extends CommonHFSExtentDescriptor {
        private final HFSPlusExtentDescriptor hped;

        public HFSPlusImplementation(HFSPlusExtentDescriptor hped) {
            this.hped = hped;
        }

        public long getStartBlock() {
            return Util.unsign((int)this.hped.getStartBlock());
        }

        public long getBlockCount() {
            return Util.unsign((int)this.hped.getBlockCount());
        }

        public void print(PrintStream ps, String prefix) {
            this.hped.print(ps, prefix);
        }

        public Dictionary getStructElements() {
            return this.hped.getStructElements();
        }
    }
}

