/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.hfsplus;

import java.io.PrintStream;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfsexplorer.Util;

public class HFSPlusExtentDescriptor
implements StructElements {
    private final byte[] startBlock = new byte[4];
    private final byte[] blockCount = new byte[4];

    public HFSPlusExtentDescriptor(byte[] data, int offset) {
        System.arraycopy(data, offset, this.startBlock, 0, 4);
        System.arraycopy(data, offset + 4, this.blockCount, 0, 4);
    }

    public HFSPlusExtentDescriptor(int startBlock, int blockCount) {
        System.arraycopy(Util.toByteArrayBE((int)startBlock), 0, this.startBlock, 0, 4);
        System.arraycopy(Util.toByteArrayBE((int)blockCount), 0, this.blockCount, 0, 4);
    }

    public static int getSize() {
        return 8;
    }

    public int getStartBlock() {
        return Util.readIntBE((byte[])this.startBlock);
    }

    public int getBlockCount() {
        return Util.readIntBE((byte[])this.blockCount);
    }

    public void print(PrintStream ps, int pregap) {
        String pregapString = "";
        for (int i = 0; i < pregap; ++i) {
            pregapString = pregapString + " ";
        }
        this.print(ps, pregapString);
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "startBlock: " + this.getStartBlock());
        ps.println(prefix + "blockCount: " + this.getBlockCount());
    }

    byte[] getBytes() {
        byte[] result = new byte[HFSPlusExtentDescriptor.getSize()];
        int offset = 0;
        System.arraycopy(this.startBlock, 0, result, offset, this.startBlock.length);
        System.arraycopy(this.blockCount, 0, result, offset += this.startBlock.length, this.blockCount.length);
        offset += this.blockCount.length;
        return result;
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder sb = new StructElements.DictionaryBuilder(HFSPlusExtentDescriptor.class.getSimpleName());
        sb.addUIntBE("startBlock", this.startBlock);
        sb.addUIntBE("blockCount", this.blockCount);
        return sb.getResult();
    }
}

