/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.vfs.dropbox;

import com.dropbox.core.DbxException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.VfsLog;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.local.LocalFileName;
import org.rzo.vfs.dropbox.DropboxClient;
import org.rzo.vfs.dropbox.DropboxClientWrapper;
import org.rzo.vfs.dropbox.DropboxFileObject;
import org.rzo.vfs.dropbox.DropboxFileProvider;

public class DropboxFileSystem
extends AbstractFileSystem {
    private static final Log LOG = LogFactory.getLog(DropboxFileSystem.class);
    private final AtomicReference<DropboxClient> idleClient = new AtomicReference();

    public DropboxFileSystem(LocalFileName rootName, DropboxClient dbxClient, FileSystemOptions fileSystemOptions) {
        super((FileName)rootName, null, fileSystemOptions == null ? DropboxFileProvider.DEFAULT_OPTIONS : fileSystemOptions);
        this.idleClient.set(dbxClient);
    }

    protected void doCloseCommunicationLink() {
        DropboxClient idle = this.idleClient.getAndSet(null);
        if (idle != null) {
            this.closeConnection(idle);
        }
    }

    protected void addCapabilities(Collection<Capability> caps) {
        caps.addAll(DropboxFileProvider.capabilities);
    }

    private void closeConnection(DropboxClient client) {
        try {
            if (client.isConnected()) {
                client.disconnect();
            }
        }
        catch (Exception e) {
            VfsLog.warn((Log)this.getLogger(), (Log)LOG, (String)"vfs.provider.dbx/close-connection.error", (Throwable)e);
        }
    }

    public DropboxClient getClient() throws FileSystemException {
        DropboxClient client = this.idleClient.getAndSet(null);
        try {
            if (client == null || !client.isConnected()) {
                client = new DropboxClientWrapper((LocalFileName)this.getRoot().getName(), this.getFileSystemOptions());
            }
        }
        catch (DbxException e) {
            throw new FileSystemException((Throwable)e);
        }
        return client;
    }

    public void putClient(DropboxClient client) {
        if (!this.idleClient.compareAndSet(null, client)) {
            this.closeConnection(client);
        }
    }

    protected FileObject createFile(AbstractFileName name) throws FileSystemException {
        return new DropboxFileObject(name, this, this.getRootName());
    }
}

