/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.ObjectUtils;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.ResolvedModuleVersion;
import org.gradle.api.internal.artifacts.DependencyGraphNodeResult;
import org.gradle.api.internal.artifacts.ResolvedConfigurationIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCollectingVisitor;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions.DefaultResolvedModuleVersion;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.CompositeResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ParallelResolveArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.internal.operations.BuildOperationExecutor;

public class DefaultResolvedDependency
implements ResolvedDependency,
DependencyGraphNodeResult {
    private final Set<DefaultResolvedDependency> children = new LinkedHashSet<DefaultResolvedDependency>();
    private final Set<ResolvedDependency> parents = new LinkedHashSet<ResolvedDependency>();
    private final ListMultimap<ResolvedDependency, ResolvedArtifactSet> parentArtifacts = ArrayListMultimap.create();
    private final String name;
    private final ResolvedConfigurationIdentifier resolvedConfigId;
    private final BuildOperationExecutor buildOperationProcessor;
    private final Set<ResolvedArtifactSet> moduleArtifacts;
    private final Map<ResolvedDependency, Set<ResolvedArtifact>> allArtifactsCache = new HashMap<ResolvedDependency, Set<ResolvedArtifact>>();
    private Set<ResolvedArtifact> allModuleArtifactsCache;

    public DefaultResolvedDependency(ResolvedConfigurationIdentifier resolvedConfigurationIdentifier, BuildOperationExecutor buildOperationProcessor) {
        this.name = String.format("%s:%s:%s", resolvedConfigurationIdentifier.getModuleGroup(), resolvedConfigurationIdentifier.getModuleName(), resolvedConfigurationIdentifier.getModuleVersion());
        this.resolvedConfigId = resolvedConfigurationIdentifier;
        this.buildOperationProcessor = buildOperationProcessor;
        this.moduleArtifacts = new LinkedHashSet<ResolvedArtifactSet>();
    }

    @Override
    public ResolvedDependency getPublicView() {
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getModuleGroup() {
        return this.resolvedConfigId.getModuleGroup();
    }

    public String getModuleName() {
        return this.resolvedConfigId.getModuleName();
    }

    public String getModuleVersion() {
        return this.resolvedConfigId.getModuleVersion();
    }

    public String getConfiguration() {
        return this.resolvedConfigId.getConfiguration();
    }

    public ResolvedModuleVersion getModule() {
        return new DefaultResolvedModuleVersion(this.resolvedConfigId.getId());
    }

    public Set<ResolvedDependency> getChildren() {
        return ImmutableSet.copyOf(this.children);
    }

    @Override
    public Collection<? extends DependencyGraphNodeResult> getOutgoingEdges() {
        return this.children;
    }

    public Set<ResolvedArtifact> getModuleArtifacts() {
        return this.sort(CompositeResolvedArtifactSet.of(this.moduleArtifacts));
    }

    public Set<ResolvedArtifact> getAllModuleArtifacts() {
        if (this.allModuleArtifactsCache == null) {
            LinkedHashSet<ResolvedArtifact> allArtifacts = new LinkedHashSet<ResolvedArtifact>(this.getModuleArtifacts());
            for (ResolvedDependency childResolvedDependency : this.getChildren()) {
                allArtifacts.addAll(childResolvedDependency.getAllModuleArtifacts());
            }
            this.allModuleArtifactsCache = allArtifacts;
        }
        return this.allModuleArtifactsCache;
    }

    public Set<ResolvedArtifact> getParentArtifacts(ResolvedDependency parent) {
        return this.sort(this.getArtifactsForIncomingEdge((DependencyGraphNodeResult)parent));
    }

    private Set<ResolvedArtifact> sort(ResolvedArtifactSet artifacts) {
        ArtifactCollectingVisitor visitor = new ArtifactCollectingVisitor(new TreeSet<ResolvedArtifact>(new ResolvedArtifactComparator()));
        ParallelResolveArtifactSet.wrap(artifacts, this.buildOperationProcessor).visit(visitor);
        return visitor.getArtifacts();
    }

    @Override
    public ResolvedArtifactSet getArtifactsForNode() {
        return CompositeResolvedArtifactSet.of(this.moduleArtifacts);
    }

    private ResolvedArtifactSet getArtifactsForIncomingEdge(DependencyGraphNodeResult parent) {
        if (!this.parents.contains(parent)) {
            throw new InvalidUserDataException("Provided dependency (" + parent + ") must be a parent of: " + this);
        }
        return CompositeResolvedArtifactSet.of(this.parentArtifacts.get((Object)((ResolvedDependency)parent)));
    }

    public Set<ResolvedArtifact> getArtifacts(ResolvedDependency parent) {
        return this.getParentArtifacts(parent);
    }

    public Set<ResolvedArtifact> getAllArtifacts(ResolvedDependency parent) {
        if (this.allArtifactsCache.get(parent) == null) {
            LinkedHashSet<ResolvedArtifact> allArtifacts = new LinkedHashSet<ResolvedArtifact>(this.getArtifacts(parent));
            for (ResolvedDependency childResolvedDependency : this.getChildren()) {
                for (ResolvedDependency childParent : childResolvedDependency.getParents()) {
                    allArtifacts.addAll(childResolvedDependency.getAllArtifacts(childParent));
                }
            }
            this.allArtifactsCache.put(parent, allArtifacts);
        }
        return this.allArtifactsCache.get(parent);
    }

    public Set<ResolvedDependency> getParents() {
        return this.parents;
    }

    public String toString() {
        return this.name + ";" + this.getConfiguration();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultResolvedDependency that = (DefaultResolvedDependency)o;
        return this.resolvedConfigId.equals(that.resolvedConfigId);
    }

    public int hashCode() {
        return this.resolvedConfigId.hashCode();
    }

    public void addChild(DefaultResolvedDependency child) {
        this.children.add(child);
        child.parents.add(this);
    }

    public void addParentSpecificArtifacts(ResolvedDependency parent, ResolvedArtifactSet artifacts) {
        this.parentArtifacts.put((Object)parent, (Object)artifacts);
        this.moduleArtifacts.add(artifacts);
    }

    public void addModuleArtifacts(ResolvedArtifactSet artifacts) {
        this.moduleArtifacts.add(artifacts);
    }

    private static class ResolvedArtifactComparator
    implements Comparator<ResolvedArtifact> {
        private ResolvedArtifactComparator() {
        }

        @Override
        public int compare(ResolvedArtifact artifact1, ResolvedArtifact artifact2) {
            int diff = artifact1.getName().compareTo(artifact2.getName());
            if (diff != 0) {
                return diff;
            }
            diff = ObjectUtils.compare((Comparable)((Object)artifact1.getClassifier()), (Comparable)((Object)artifact2.getClassifier()));
            if (diff != 0) {
                return diff;
            }
            diff = ObjectUtils.compare((Comparable)((Object)artifact1.getExtension()), (Comparable)((Object)artifact2.getExtension()));
            if (diff != 0) {
                return diff;
            }
            diff = artifact1.getType().compareTo(artifact2.getType());
            if (diff != 0) {
                return diff;
            }
            return artifact1.hashCode() - artifact2.hashCode();
        }
    }
}

