/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DefaultDependencySubstitutions;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionsInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.composite.CompositeBuildContext;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncludedBuildDependencySubstitutionsBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncludedBuildDependencySubstitutionsBuilder.class);
    private final CompositeBuildContext context;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final Instantiator instantiator;
    private final ObjectFactory objectFactory;
    private final ImmutableAttributesFactory attributesFactory;
    private final NotationParser<Object, Capability> capabilitiesParser;

    public IncludedBuildDependencySubstitutionsBuilder(CompositeBuildContext context, ImmutableModuleIdentifierFactory moduleIdentifierFactory, Instantiator instantiator, ObjectFactory objectFactory, ImmutableAttributesFactory attributesFactory, NotationParser<Object, Capability> capabilitiesParser) {
        this.context = context;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.instantiator = instantiator;
        this.objectFactory = objectFactory;
        this.attributesFactory = attributesFactory;
        this.capabilitiesParser = capabilitiesParser;
    }

    public void build(IncludedBuildState build) {
        DependencySubstitutionsInternal substitutions = this.resolveDependencySubstitutions(build);
        if (!substitutions.hasRules()) {
            LOGGER.info("[composite-build] Configuring build: " + build.getRootDirectory());
            this.context.addAvailableModules(build.getAvailableModules());
        } else {
            this.context.registerSubstitution(substitutions.getRuleAction());
        }
    }

    private DependencySubstitutionsInternal resolveDependencySubstitutions(IncludedBuildState build) {
        DefaultDependencySubstitutions dependencySubstitutions = DefaultDependencySubstitutions.forIncludedBuild((IncludedBuildState)build, (ImmutableModuleIdentifierFactory)this.moduleIdentifierFactory, (Instantiator)this.instantiator, (ObjectFactory)this.objectFactory, (ImmutableAttributesFactory)this.attributesFactory, this.capabilitiesParser);
        build.getRegisteredDependencySubstitutions().execute((Object)dependencySubstitutions);
        return dependencySubstitutions;
    }
}

