/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.DirectShortBufferRS;
import java.nio.ShortBuffer;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

class DirectShortBufferS
extends ShortBuffer
implements DirectBuffer {
    protected static final Unsafe unsafe = Bits.unsafe();
    private static final long arrayBaseOffset = unsafe.arrayBaseOffset(short[].class);
    protected static final boolean unaligned = Bits.unaligned();
    private final Object att;

    @Override
    public Object attachment() {
        return this.att;
    }

    @Override
    public Cleaner cleaner() {
        return null;
    }

    DirectShortBufferS(DirectBuffer directBuffer, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4);
        this.address = directBuffer.address() + (long)n5;
        this.att = directBuffer;
    }

    @Override
    public ShortBuffer slice() {
        int n;
        int n2 = this.position();
        int n3 = n2 <= (n = this.limit()) ? n - n2 : 0;
        int n4 = n2 << 1;
        assert (n4 >= 0);
        return new DirectShortBufferS(this, -1, 0, n3, n3, n4);
    }

    @Override
    public ShortBuffer duplicate() {
        return new DirectShortBufferS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public ShortBuffer asReadOnlyBuffer() {
        return new DirectShortBufferRS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public long address() {
        return this.address;
    }

    private long ix(int n) {
        return this.address + ((long)n << 1);
    }

    @Override
    public short get() {
        return Bits.swap(unsafe.getShort(this.ix(this.nextGetIndex())));
    }

    @Override
    public short get(int n) {
        return Bits.swap(unsafe.getShort(this.ix(this.checkIndex(n))));
    }

    @Override
    public ShortBuffer get(short[] sArray, int n, int n2) {
        if ((long)n2 << 1 > 6L) {
            int n3;
            DirectShortBufferS.checkBounds(n, n2, sArray.length);
            int n4 = this.position();
            int n5 = this.limit();
            assert (n4 <= n5);
            int n6 = n3 = n4 <= n5 ? n5 - n4 : 0;
            if (n2 > n3) {
                throw new BufferUnderflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyToShortArray(this.ix(n4), sArray, (long)n << 1, (long)n2 << 1);
            } else {
                Bits.copyToArray(this.ix(n4), sArray, arrayBaseOffset, (long)n << 1, (long)n2 << 1);
            }
            this.position(n4 + n2);
        } else {
            super.get(sArray, n, n2);
        }
        return this;
    }

    @Override
    public ShortBuffer put(short s) {
        unsafe.putShort(this.ix(this.nextPutIndex()), Bits.swap(s));
        return this;
    }

    @Override
    public ShortBuffer put(int n, short s) {
        unsafe.putShort(this.ix(this.checkIndex(n)), Bits.swap(s));
        return this;
    }

    @Override
    public ShortBuffer put(ShortBuffer shortBuffer) {
        if (shortBuffer instanceof DirectShortBufferS) {
            int n;
            if (shortBuffer == this) {
                throw new IllegalArgumentException();
            }
            DirectShortBufferS directShortBufferS = (DirectShortBufferS)shortBuffer;
            int n2 = directShortBufferS.position();
            int n3 = directShortBufferS.limit();
            assert (n2 <= n3);
            int n4 = n2 <= n3 ? n3 - n2 : 0;
            int n5 = this.position();
            int n6 = this.limit();
            assert (n5 <= n6);
            int n7 = n = n5 <= n6 ? n6 - n5 : 0;
            if (n4 > n) {
                throw new BufferOverflowException();
            }
            unsafe.copyMemory(directShortBufferS.ix(n2), this.ix(n5), (long)n4 << 1);
            directShortBufferS.position(n2 + n4);
            this.position(n5 + n4);
        } else if (shortBuffer.hb != null) {
            int n = shortBuffer.position();
            int n8 = shortBuffer.limit();
            assert (n <= n8);
            int n9 = n <= n8 ? n8 - n : 0;
            this.put(shortBuffer.hb, shortBuffer.offset + n, n9);
            shortBuffer.position(n + n9);
        } else {
            super.put(shortBuffer);
        }
        return this;
    }

    @Override
    public ShortBuffer put(short[] sArray, int n, int n2) {
        if ((long)n2 << 1 > 6L) {
            int n3;
            DirectShortBufferS.checkBounds(n, n2, sArray.length);
            int n4 = this.position();
            int n5 = this.limit();
            assert (n4 <= n5);
            int n6 = n3 = n4 <= n5 ? n5 - n4 : 0;
            if (n2 > n3) {
                throw new BufferOverflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyFromShortArray(sArray, (long)n << 1, this.ix(n4), (long)n2 << 1);
            } else {
                Bits.copyFromArray(sArray, arrayBaseOffset, (long)n << 1, this.ix(n4), (long)n2 << 1);
            }
            this.position(n4 + n2);
        } else {
            super.put(sArray, n, n2);
        }
        return this;
    }

    @Override
    public ShortBuffer compact() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        unsafe.copyMemory(this.ix(n), this.ix(0), (long)n3 << 1);
        this.position(n3);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

