/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.lang.invoke.MethodHandle;
import org.jruby.RubyModule;
import org.jruby.compiler.Compilable;
import org.jruby.internal.runtime.AbstractIRMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRScope;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class CompiledIRMethod
extends AbstractIRMethod
implements Compilable<DynamicMethod> {
    private MethodHandle specific;
    private final int specificArity;

    public CompiledIRMethod(MethodHandle variable, IRScope method2, Visibility visibility, RubyModule implementationClass) {
        this(variable, null, -1, method2, visibility, implementationClass);
    }

    public CompiledIRMethod(MethodHandle variable, MethodHandle specific, int specificArity, IRScope method2, Visibility visibility, RubyModule implementationClass) {
        super(method2, visibility, implementationClass);
        this.specific = specific;
        this.specificArity = method2.receivesKeywordArgs() ? -1 : specificArity;
        this.method.getStaticScope().determineModule();
        this.setHandle(variable);
        method2.compilable = this;
    }

    public MethodHandle getHandleFor(int arity2) {
        if (this.specificArity != -1 && arity2 == this.specificArity) {
            return this.specific;
        }
        return null;
    }

    public void setVariable(MethodHandle variable) {
        super.setHandle(variable);
    }

    public void setSpecific(MethodHandle specific) {
        this.specific = specific;
    }

    @Override
    public ArgumentDescriptor[] getArgumentDescriptors() {
        return ((IRMethod)this.method).getArgumentDescriptors();
    }

    @Override
    public void completeBuild(DynamicMethod buildResult) {
    }

    @Override
    protected void printMethodIR() {
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        try {
            return ((MethodHandle)this.handle).invokeExact(context, this.staticScope, self2, args2, block, clazz, name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, Block block) {
        if (this.specificArity != 0) {
            return this.call(context, self2, clazz, name2, IRubyObject.NULL_ARRAY, block);
        }
        try {
            return this.specific.invokeExact(context, this.staticScope, self2, block, clazz, name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
        if (this.specificArity != 1) {
            return this.call(context, self2, clazz, name2, new IRubyObject[]{arg0}, block);
        }
        try {
            return this.specific.invokeExact(context, this.staticScope, self2, arg0, block, clazz, name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        if (this.specificArity != 2) {
            return this.call(context, self2, clazz, name2, new IRubyObject[]{arg0, arg1}, block);
        }
        try {
            return this.specific.invokeExact(context, this.staticScope, self2, arg0, arg1, block, clazz, name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        if (this.specificArity != 3) {
            return this.call(context, self2, clazz, name2, new IRubyObject[]{arg0, arg1, arg2}, block);
        }
        try {
            return this.specific.invokeExact(context, this.staticScope, self2, arg0, arg1, arg2, block, clazz, name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2) {
        try {
            return ((MethodHandle)this.handle).invokeExact(context, this.staticScope, self2, args2, Block.NULL_BLOCK, clazz, name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
        if (this.specificArity != 0) {
            return this.call(context, self2, clazz, name2, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
        }
        try {
            return this.specific.invokeExact(context, this.staticScope, self2, Block.NULL_BLOCK, clazz, name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0) {
        if (this.specificArity != 1) {
            return this.call(context, self2, clazz, name2, new IRubyObject[]{arg0}, Block.NULL_BLOCK);
        }
        try {
            return this.specific.invokeExact(context, this.staticScope, self2, arg0, Block.NULL_BLOCK, clazz, name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1) {
        if (this.specificArity != 2) {
            return this.call(context, self2, clazz, name2, new IRubyObject[]{arg0, arg1}, Block.NULL_BLOCK);
        }
        try {
            return this.specific.invokeExact(context, this.staticScope, self2, arg0, arg1, Block.NULL_BLOCK, clazz, name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        if (this.specificArity != 3) {
            return this.call(context, self2, clazz, name2, new IRubyObject[]{arg0, arg1, arg2}, Block.NULL_BLOCK);
        }
        try {
            return this.specific.invokeExact(context, this.staticScope, self2, arg0, arg1, arg2, Block.NULL_BLOCK, clazz, name2);
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }
}

