/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useEffect, useRef } from 'react';
import { render, unmountComponentAtNode } from 'react-dom';
import { I18nProvider } from '@kbn/i18n/react';
var defaultWrapperClass = 'kbnMountWrapper';
/**
 * MountWrapper is a react component to mount a {@link MountPoint} inside a react tree.
 */

export var MountWrapper = function MountWrapper(_ref) {
  var mount = _ref.mount,
      _ref$className = _ref.className,
      className = _ref$className === void 0 ? defaultWrapperClass : _ref$className;
  var element = useRef(null);
  useEffect(function () {
    return mount(element.current);
  }, [mount]);
  return /*#__PURE__*/React.createElement("div", {
    className: className,
    ref: element
  });
};
/**
 * Mount converter for react node.
 *
 * @param node to get a mount for
 */

export var mountReactNode = function mountReactNode(node) {
  return function (element) {
    render( /*#__PURE__*/React.createElement(I18nProvider, null, node), element);
    return function () {
      return unmountComponentAtNode(element);
    };
  };
};