/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import { render, unmountComponentAtNode } from 'react-dom';
import { ServicesContextProvider, EditorContextProvider, RequestContextProvider } from './contexts';
import { Main } from './containers';
import { createStorage, createHistory, createSettings } from '../services';
import * as localStorageObjectClient from '../lib/local_storage_object_client';
import { createUsageTracker } from '../services/tracker';
export function renderApp(_ref) {
  var I18nContext = _ref.I18nContext,
      notifications = _ref.notifications,
      docLinkVersion = _ref.docLinkVersion,
      elasticsearchUrl = _ref.elasticsearchUrl,
      usageCollection = _ref.usageCollection,
      element = _ref.element;
  var trackUiMetric = createUsageTracker(usageCollection);
  trackUiMetric.load('opened_app');
  var storage = createStorage({
    engine: window.localStorage,
    prefix: 'sense:'
  });
  var history = createHistory({
    storage: storage
  });
  var settings = createSettings({
    storage: storage
  });
  var objectStorageClient = localStorageObjectClient.create(storage);
  render( /*#__PURE__*/React.createElement(I18nContext, null, /*#__PURE__*/React.createElement(ServicesContextProvider, {
    value: {
      elasticsearchUrl: elasticsearchUrl,
      docLinkVersion: docLinkVersion,
      services: {
        storage: storage,
        history: history,
        settings: settings,
        notifications: notifications,
        trackUiMetric: trackUiMetric,
        objectStorageClient: objectStorageClient
      }
    }
  }, /*#__PURE__*/React.createElement(RequestContextProvider, null, /*#__PURE__*/React.createElement(EditorContextProvider, {
    settings: settings.toJSON()
  }, /*#__PURE__*/React.createElement(Main, null))))), element);
  return function () {
    return unmountComponentAtNode(element);
  };
}