/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { getQueryLog } from './get_query_log';
export function createAddToQueryLog(_ref) {
  var storage = _ref.storage,
      uiSettings = _ref.uiSettings;

  /**
   * This function is to be used in conjunction with `<QueryStringInput />`.
   * It provides a way for external editors to add new filter entries to the
   * persisted query log which lives in `localStorage`. These entries are then
   * read by `<QueryStringInput />` and provided in the autocomplete options.
   *
   * @param appName Name of the app where this filter is added from.
   * @param query Filter value to add.
   */
  return function addToQueryLog(appName, _ref2) {
    var language = _ref2.language,
        query = _ref2.query;
    var persistedLog = getQueryLog(uiSettings, storage, appName, language);
    persistedLog.add(query);
  };
}