"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchService = void 0;

var _routes = require("./routes");

var _es_search = require("./es_search");

var _register = require("./collectors/register");

var _usage = require("./collectors/usage");

var _saved_objects = require("../saved_objects");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class SearchService {
  constructor(initializerContext) {
    this.initializerContext = initializerContext;

    _defineProperty(this, "searchStrategies", {});

    _defineProperty(this, "registerSearchStrategy", (name, strategy) => {
      this.searchStrategies[name] = strategy;
    });

    _defineProperty(this, "getSearchStrategy", name => {
      const strategy = this.searchStrategies[name];

      if (!strategy) {
        throw new Error(`Search strategy ${name} not found`);
      }

      return strategy;
    });
  }

  setup(core, {
    usageCollection
  }) {
    const usage = usageCollection ? (0, _usage.usageProvider)(core) : undefined;
    this.registerSearchStrategy(_es_search.ES_SEARCH_STRATEGY, (0, _es_search.esSearchStrategyProvider)(this.initializerContext.config.legacy.globalConfig$, usage));
    core.savedObjects.registerType(_saved_objects.searchTelemetry);

    if (usageCollection) {
      (0, _register.registerUsageCollector)(usageCollection, this.initializerContext);
    }

    (0, _routes.registerSearchRoute)(core);
    return {
      registerSearchStrategy: this.registerSearchStrategy,
      usage
    };
  }

  search(context, searchRequest, options) {
    return this.getSearchStrategy(options.strategy || _es_search.ES_SEARCH_STRATEGY).search(context, searchRequest, {
      signal: options.signal
    });
  }

  start() {
    return {
      getSearchStrategy: this.getSearchStrategy,
      search: this.search
    };
  }

  stop() {}

}

exports.SearchService = SearchService;