function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import _ from 'lodash';
import { FilterManager } from './filter_manager';
import { esFilters } from '../../../../data/public';
export var PhraseFilterManager = /*#__PURE__*/function (_FilterManager) {
  _inherits(PhraseFilterManager, _FilterManager);

  var _super = _createSuper(PhraseFilterManager);

  function PhraseFilterManager(controlId, fieldName, indexPattern, queryFilter) {
    _classCallCheck(this, PhraseFilterManager);

    return _super.call(this, controlId, fieldName, indexPattern, queryFilter);
  }

  _createClass(PhraseFilterManager, [{
    key: "createFilter",
    value: function createFilter(phrases) {
      var newFilter;
      var value = this.indexPattern.fields.getByName(this.fieldName);

      if (!value) {
        throw new Error("Unable to find field with name: ".concat(this.fieldName, " on indexPattern"));
      }

      if (phrases.length === 1) {
        newFilter = esFilters.buildPhraseFilter(value, phrases[0], this.indexPattern);
      } else {
        newFilter = esFilters.buildPhrasesFilter(value, phrases, this.indexPattern);
      }

      newFilter.meta.key = this.fieldName;
      newFilter.meta.controlledBy = this.controlId;
      return newFilter;
    }
  }, {
    key: "getValueFromFilterBar",
    value: function getValueFromFilterBar() {
      var _this = this;

      var kbnFilters = this.findFilters();

      if (kbnFilters.length === 0) {
        return;
      }

      var values = kbnFilters.map(function (kbnFilter) {
        return _this.getValueFromFilter(kbnFilter);
      }).filter(function (value) {
        return value != null;
      });

      if (values.length === 0) {
        return;
      }

      return values.reduce(function (accumulator, currentValue) {
        return accumulator.concat(currentValue);
      }, []);
    }
    /**
     * Extract filtering value from kibana filters
     *
     * @param  {PhraseFilter} kbnFilter
     * @return {Array.<string>} array of values pulled from filter
     */

  }, {
    key: "getValueFromFilter",
    value: function getValueFromFilter(kbnFilter) {
      var _this2 = this;

      // bool filter - multiple phrase filters
      if (_.has(kbnFilter, 'query.bool.should')) {
        return _.get(kbnFilter, 'query.bool.should').map(function (kbnQueryFilter) {
          return _this2.getValueFromFilter(kbnQueryFilter);
        }).filter(function (value) {
          if (value) {
            return true;
          }

          return false;
        });
      } // scripted field filter


      if (_.has(kbnFilter, 'script')) {
        return _.get(kbnFilter, 'script.script.params.value');
      } // single phrase filter


      if (esFilters.isPhraseFilter(kbnFilter)) {
        if (esFilters.getPhraseFilterField(kbnFilter) !== this.fieldName) {
          return;
        }

        return esFilters.getPhraseFilterValue(kbnFilter);
      } // single phrase filter from bool filter


      if (_.has(kbnFilter, ['match_phrase', this.fieldName])) {
        return _.get(kbnFilter, ['match_phrase', this.fieldName]);
      }
    }
  }]);

  return PhraseFilterManager;
}(FilterManager);