function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { Component } from 'react';
import PropTypes from 'prop-types';
import { i18n } from '@kbn/i18n';
import { EuiTab, EuiTabs } from '@elastic/eui';
import { RequestDetailsRequest, RequestDetailsResponse, RequestDetailsStats } from './details';
var DETAILS = [{
  name: 'Statistics',
  label: i18n.translate('inspector.requests.statisticsTabLabel', {
    defaultMessage: 'Statistics'
  }),
  component: RequestDetailsStats
}, {
  name: 'Request',
  label: i18n.translate('inspector.requests.requestTabLabel', {
    defaultMessage: 'Request'
  }),
  component: RequestDetailsRequest
}, {
  name: 'Response',
  label: i18n.translate('inspector.requests.responseTabLabel', {
    defaultMessage: 'Response'
  }),
  component: RequestDetailsResponse
}];
export var RequestDetails = /*#__PURE__*/function (_Component) {
  _inherits(RequestDetails, _Component);

  var _super = _createSuper(RequestDetails);

  function RequestDetails() {
    var _this;

    _classCallCheck(this, RequestDetails);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {
      availableDetails: [],
      selectedDetail: null
    });

    _defineProperty(_assertThisInitialized(_this), "selectDetailsTab", function (detail) {
      if (detail !== _this.state.selectedDetail) {
        _this.setState({
          selectedDetail: detail
        });
      }
    });

    _defineProperty(_assertThisInitialized(_this), "renderDetailTab", function (detail) {
      return /*#__PURE__*/React.createElement(EuiTab, {
        key: detail.name,
        isSelected: detail === _this.state.selectedDetail,
        onClick: function onClick() {
          return _this.selectDetailsTab(detail);
        },
        "data-test-subj": "inspectorRequestDetail".concat(detail.name)
      }, detail.label);
    });

    return _this;
  }

  _createClass(RequestDetails, [{
    key: "render",
    value: function render() {
      var _this$state = this.state,
          selectedDetail = _this$state.selectedDetail,
          availableDetails = _this$state.availableDetails;
      var DetailComponent = RequestDetails.getSelectedDetailComponent(selectedDetail);

      if (!availableDetails.length || !DetailComponent) {
        return null;
      }

      return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiTabs, {
        size: "s"
      }, this.state.availableDetails.map(this.renderDetailTab)), /*#__PURE__*/React.createElement(DetailComponent, {
        request: this.props.request
      }));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(nextProps, prevState) {
      var selectedDetail = prevState && prevState.selectedDetail;
      var availableDetails = DETAILS.filter(function (detail) {
        return !detail.component.shouldShow || detail.component.shouldShow(nextProps.request);
      }); // If the previously selected detail is still available we want to stay
      // on this tab and not set another selectedDetail.

      if (selectedDetail && availableDetails.includes(selectedDetail)) {
        return {
          availableDetails: availableDetails
        };
      }

      return {
        availableDetails: availableDetails,
        selectedDetail: availableDetails[0]
      };
    }
  }, {
    key: "getSelectedDetailComponent",
    value: function getSelectedDetailComponent(detail) {
      return detail ? detail.component : null;
    }
  }]);

  return RequestDetails;
}(Component);

_defineProperty(RequestDetails, "propTypes", {
  request: PropTypes.object.isRequired
});