function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useState, useEffect } from 'react';
import { omit, isEqual } from 'lodash';
import { htmlIdGenerator, EuiButton, EuiSpacer } from '@elastic/eui';
import { FormattedMessage } from '@kbn/i18n/react';
import { useMount } from 'react-use';
import { UI_SETTINGS } from '../../../../data/public';
import { useKibana } from '../../../../kibana_react/public';
import { FilterRow } from './filter';
var generateId = htmlIdGenerator();

function FiltersParamEditor(_ref) {
  var agg = _ref.agg,
      _ref$value = _ref.value,
      value = _ref$value === void 0 ? [] : _ref$value,
      setValue = _ref.setValue;

  var _useState = useState(function () {
    return value.map(function (filter) {
      return _objectSpread(_objectSpread({}, filter), {}, {
        id: generateId()
      });
    });
  }),
      _useState2 = _slicedToArray(_useState, 2),
      filters = _useState2[0],
      setFilters = _useState2[1];

  useMount(function () {
    // set parsed values into model after initialization
    setValue(filters.map(function (filter) {
      return omit(_objectSpread(_objectSpread({}, filter), {}, {
        input: filter.input
      }), 'id');
    }));
  });
  useEffect(function () {
    // responsible for discarding changes
    if (value.length !== filters.length || value.some(function (filter, index) {
      return !isEqual(filter, omit(filters[index], 'id'));
    })) {
      setFilters(value.map(function (filter) {
        return _objectSpread(_objectSpread({}, filter), {}, {
          id: generateId()
        });
      }));
    }
  }, [filters, value]);

  var updateFilters = function updateFilters(updatedFilters) {
    // do not set internal id parameter into saved object
    setValue(updatedFilters.map(function (filter) {
      return omit(filter, 'id');
    }));
    setFilters(updatedFilters);
  };

  var _useKibana = useKibana(),
      services = _useKibana.services;

  var onAddFilter = function onAddFilter() {
    return updateFilters([].concat(_toConsumableArray(filters), [{
      input: {
        query: '',
        language: services.uiSettings.get(UI_SETTINGS.SEARCH_QUERY_LANGUAGE)
      },
      label: '',
      id: generateId()
    }]));
  };

  var onRemoveFilter = function onRemoveFilter(id) {
    return updateFilters(filters.filter(function (filter) {
      return filter.id !== id;
    }));
  };

  var onChangeValue = function onChangeValue(id, query, label) {
    return updateFilters(filters.map(function (filter) {
      return filter.id === id ? _objectSpread(_objectSpread({}, filter), {}, {
        input: query,
        label: label
      }) : filter;
    }));
  };

  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "m"
  }), filters.map(function (_ref2, arrayIndex) {
    var input = _ref2.input,
        label = _ref2.label,
        id = _ref2.id;
    return /*#__PURE__*/React.createElement(FilterRow, {
      key: id,
      id: id,
      arrayIndex: arrayIndex,
      customLabel: label,
      value: input,
      autoFocus: arrayIndex === filters.length - 1,
      disableRemove: arrayIndex === 0 && filters.length === 1,
      dataTestSubj: "visEditorFilterInput_".concat(agg.id, "_").concat(arrayIndex),
      agg: agg,
      onChangeValue: onChangeValue,
      onRemoveFilter: onRemoveFilter
    });
  }), /*#__PURE__*/React.createElement(EuiButton, {
    iconType: "plusInCircle",
    fill: true,
    fullWidth: true,
    onClick: onAddFilter,
    size: "s",
    "data-test-subj": "visEditorAddFilterButton"
  }, /*#__PURE__*/React.createElement(FormattedMessage, {
    id: "visDefaultEditor.controls.filters.addFilterButtonLabel",
    defaultMessage: "Add filter"
  })), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "m"
  }));
}

export { FiltersParamEditor };