function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useState, useMemo, useCallback } from 'react';
import { EuiFormRow, EuiIconTip, EuiCodeEditor, EuiScreenReaderOnly } from '@elastic/eui';
import { i18n } from '@kbn/i18n';
import 'brace/theme/github';

function RawJsonParamEditor(_ref) {
  var showValidation = _ref.showValidation,
      _ref$value = _ref.value,
      value = _ref$value === void 0 ? '' : _ref$value,
      setValidity = _ref.setValidity,
      setValue = _ref.setValue,
      setTouched = _ref.setTouched;

  var _useState = useState(true),
      _useState2 = _slicedToArray(_useState, 2),
      isFieldValid = _useState2[0],
      setFieldValidity = _useState2[1];

  var _useState3 = useState(false),
      _useState4 = _slicedToArray(_useState3, 2),
      editorReady = _useState4[0],
      setEditorReady = _useState4[1];

  var editorTooltipText = useMemo(function () {
    return i18n.translate('visDefaultEditor.controls.jsonInputTooltip', {
      defaultMessage: "Any JSON formatted properties you add here will be merged with the elasticsearch aggregation definition for this section. For example 'shard_size' on a terms aggregation."
    });
  }, []);
  var jsonEditorLabelText = useMemo(function () {
    return i18n.translate('visDefaultEditor.controls.jsonInputLabel', {
      defaultMessage: 'JSON input'
    });
  }, []);
  var label = useMemo(function () {
    return /*#__PURE__*/React.createElement(React.Fragment, null, jsonEditorLabelText, ' ', /*#__PURE__*/React.createElement(EuiIconTip, {
      position: "right",
      content: editorTooltipText,
      type: "questionInCircle"
    }));
  }, [jsonEditorLabelText, editorTooltipText]);
  var onEditorValidate = useCallback(function (annotations) {
    // The first onValidate returned from EuiCodeEditor is a false negative
    if (editorReady) {
      var validity = annotations.length === 0;
      setFieldValidity(validity);
      setValidity(validity);
    } else {
      setEditorReady(true);
    }
  }, [setValidity, editorReady]);
  return /*#__PURE__*/React.createElement(EuiFormRow, {
    label: label,
    isInvalid: showValidation ? !isFieldValid : false,
    fullWidth: true,
    compressed: true
  }, /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(EuiCodeEditor, {
    mode: "json",
    theme: "github",
    width: "100%",
    height: "250px",
    value: value,
    onValidate: onEditorValidate,
    setOptions: {
      fontSize: '14px'
    },
    onChange: setValue,
    onBlur: setTouched,
    "aria-label": jsonEditorLabelText,
    "aria-describedby": "jsonEditorDescription"
  }), /*#__PURE__*/React.createElement(EuiScreenReaderOnly, null, /*#__PURE__*/React.createElement("p", {
    id: "jsonEditorDescription"
  }, editorTooltipText))));
}

export { RawJsonParamEditor };