function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React, { useMemo, useCallback } from 'react';
import { findLast } from 'lodash';
import { EuiSpacer } from '@elastic/eui';
import { AggGroupNames, search } from '../../../../data/public';
import { DefaultEditorAggGroup } from '../agg_group';
import { addNewAgg, removeAgg, reorderAggs, setAggParamValue, changeAggType, toggleEnabledAgg } from './state';

function DefaultEditorDataTab(_ref) {
  var dispatch = _ref.dispatch,
      formIsTouched = _ref.formIsTouched,
      metricAggs = _ref.metricAggs,
      schemas = _ref.schemas,
      state = _ref.state,
      setTouched = _ref.setTouched,
      setValidity = _ref.setValidity,
      setStateValue = _ref.setStateValue,
      timeRange = _ref.timeRange;
  var lastParentPipelineAgg = useMemo(function () {
    return findLast(metricAggs, function (_ref2) {
      var type = _ref2.type;
      return type.subtype === search.aggs.parentPipelineType;
    });
  }, [metricAggs]);
  var lastParentPipelineAggTitle = lastParentPipelineAgg && lastParentPipelineAgg.type.title;
  var addSchema = useCallback(function (schema) {
    return dispatch(addNewAgg(schema));
  }, [dispatch]);
  var onAggRemove = useCallback(function (aggId) {
    return dispatch(removeAgg(aggId, schemas.all || []));
  }, [dispatch, schemas]);
  var onReorderAggs = useCallback(function () {
    return dispatch(reorderAggs.apply(void 0, arguments));
  }, [dispatch]);
  var onAggParamValueChange = useCallback(function () {
    return dispatch(setAggParamValue.apply(void 0, arguments));
  }, [dispatch]);
  var onAggTypeChange = useCallback(function () {
    return dispatch(changeAggType.apply(void 0, arguments));
  }, [dispatch]);
  var onToggleEnableAgg = useCallback(function () {
    return dispatch(toggleEnabledAgg.apply(void 0, arguments));
  }, [dispatch]);
  var commonProps = {
    addSchema: addSchema,
    formIsTouched: formIsTouched,
    lastParentPipelineAggTitle: lastParentPipelineAggTitle,
    metricAggs: metricAggs,
    state: state,
    reorderAggs: onReorderAggs,
    setAggParamValue: onAggParamValueChange,
    setStateParamValue: setStateValue,
    onAggTypeChange: onAggTypeChange,
    onToggleEnableAgg: onToggleEnableAgg,
    setValidity: setValidity,
    setTouched: setTouched,
    removeAgg: onAggRemove
  };
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(DefaultEditorAggGroup, _extends({
    groupName: AggGroupNames.Metrics,
    schemas: schemas.metrics
  }, commonProps)), /*#__PURE__*/React.createElement(EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/React.createElement(DefaultEditorAggGroup, _extends({
    groupName: AggGroupNames.Buckets,
    schemas: schemas.buckets,
    timeRange: timeRange
  }, commonProps)));
}

export { DefaultEditorDataTab };